/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sync.common;

import io.hops.hudi.com.beust.jcommander.Parameter;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.apache.hudi.sync.common.util.ConfigUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class HoodieSyncConfig
extends HoodieConfig {
    private static final Logger LOG = LogManager.getLogger(HoodieSyncConfig.class);
    public static final ConfigProperty<String> META_SYNC_BASE_PATH = ConfigProperty.key("hoodie.datasource.meta.sync.base.path").defaultValue("").withDocumentation("Base path of the hoodie table to sync");
    public static final ConfigProperty<String> META_SYNC_ENABLED = ConfigProperty.key("hoodie.datasource.meta.sync.enable").defaultValue("false").withDocumentation("Enable Syncing the Hudi Table with an external meta store or data catalog.");
    public static final ConfigProperty<String> META_SYNC_DATABASE_NAME = ConfigProperty.key("hoodie.datasource.hive_sync.database").defaultValue("default").withInferFunction(cfg -> Option.ofNullable(cfg.getString(HoodieTableConfig.DATABASE_NAME))).withDocumentation("The name of the destination database that we should sync the hudi table to.");
    public static final ConfigProperty<String> META_SYNC_TABLE_NAME = ConfigProperty.key("hoodie.datasource.hive_sync.table").defaultValue("unknown").withInferFunction(cfg -> Option.ofNullable(cfg.getString("hoodie.table.name")).or(() -> Option.ofNullable(cfg.getString("hoodie.datasource.write.table.name")))).withDocumentation("The name of the destination table that we should sync the hudi table to.");
    public static final ConfigProperty<String> META_SYNC_BASE_FILE_FORMAT = ConfigProperty.key("hoodie.datasource.hive_sync.base_file_format").defaultValue("PARQUET").withInferFunction(cfg -> Option.ofNullable(cfg.getString(HoodieTableConfig.BASE_FILE_FORMAT))).withDocumentation("Base file format for the sync.");
    public static final ConfigProperty<String> META_SYNC_PARTITION_FIELDS = ConfigProperty.key("hoodie.datasource.hive_sync.partition_fields").defaultValue("").withInferFunction(cfg -> Option.ofNullable(cfg.getString(HoodieTableConfig.PARTITION_FIELDS)).or(() -> Option.ofNullable(cfg.getString(KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME)))).withDocumentation("Field in the table to use for determining hive partition columns.");
    public static final ConfigProperty<String> META_SYNC_PARTITION_EXTRACTOR_CLASS = ConfigProperty.key("hoodie.datasource.hive_sync.partition_extractor_class").defaultValue("org.apache.hudi.hive.MultiPartKeysValueExtractor").withInferFunction(cfg -> {
        Option<String> partitionFieldsOpt = StringUtils.nonEmpty(cfg.getString(META_SYNC_PARTITION_FIELDS)) ? Option.ofNullable(cfg.getString(META_SYNC_PARTITION_FIELDS)) : Option.ofNullable(cfg.getString(HoodieTableConfig.PARTITION_FIELDS)).or(() -> Option.ofNullable(cfg.getString(KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME)));
        if (!partitionFieldsOpt.isPresent()) {
            return Option.empty();
        }
        String partitionFields = partitionFieldsOpt.get();
        if (StringUtils.nonEmpty(partitionFields)) {
            int numOfPartFields = partitionFields.split(",").length;
            if (numOfPartFields == 1) {
                if (cfg.contains(HoodieTableConfig.HIVE_STYLE_PARTITIONING_ENABLE) && cfg.getString(HoodieTableConfig.HIVE_STYLE_PARTITIONING_ENABLE).equals("true")) {
                    return Option.of("org.apache.hudi.hive.HiveStylePartitionValueExtractor");
                }
                return Option.of("org.apache.hudi.hive.SinglePartPartitionValueExtractor");
            }
            return Option.of("org.apache.hudi.hive.MultiPartKeysValueExtractor");
        }
        return Option.of("org.apache.hudi.hive.NonPartitionedExtractor");
    }).withDocumentation("Class which implements PartitionValueExtractor to extract the partition values, default 'org.apache.hudi.hive.MultiPartKeysValueExtractor'.");
    public static final ConfigProperty<String> META_SYNC_ASSUME_DATE_PARTITION = ConfigProperty.key("hoodie.datasource.hive_sync.assume_date_partitioning").defaultValue(HoodieMetadataConfig.ASSUME_DATE_PARTITIONING.defaultValue()).withInferFunction(cfg -> Option.ofNullable(cfg.getString(HoodieMetadataConfig.ASSUME_DATE_PARTITIONING))).withDocumentation("Assume partitioning is yyyy/MM/dd");
    public static final ConfigProperty<Boolean> META_SYNC_DECODE_PARTITION = ConfigProperty.key("hoodie.meta.sync.decode_partition").defaultValue(false).withInferFunction(cfg -> Option.ofNullable(cfg.getBoolean(HoodieTableConfig.URL_ENCODE_PARTITIONING))).withDocumentation("If true, meta sync will url-decode the partition path, as it is deemed as url-encoded. Default to false.");
    public static final ConfigProperty<Boolean> META_SYNC_USE_FILE_LISTING_FROM_METADATA = ConfigProperty.key("hoodie.meta.sync.metadata_file_listing").defaultValue(false).withInferFunction(cfg -> Option.of(cfg.getBooleanOrDefault(HoodieMetadataConfig.ENABLE, false))).withDocumentation("Enable the internal metadata table for file listing for syncing with metastores");
    public static final ConfigProperty<String> META_SYNC_CONDITIONAL_SYNC = ConfigProperty.key("hoodie.datasource.meta_sync.condition.sync").defaultValue("false").withDocumentation("If true, only sync on conditions like schema change or partition change.");
    public static final ConfigProperty<String> META_SYNC_SPARK_VERSION = ConfigProperty.key("hoodie.meta_sync.spark.version").defaultValue("").withDocumentation("The spark version used when syncing with a metastore.");
    private Configuration hadoopConf;

    public HoodieSyncConfig(Properties props) {
        this(props, ConfigUtils.createHadoopConf(props));
    }

    public HoodieSyncConfig(Properties props, Configuration hadoopConf) {
        super(props);
        LOG.debug((Object)("Passed in properties:\n" + props.entrySet().stream().sorted(Comparator.comparing(e -> e.getKey().toString())).map(e -> e.getKey() + "=" + e.getValue()).collect(Collectors.joining("\n"))));
        this.setDefaults(HoodieSyncConfig.class.getName());
        this.hadoopConf = hadoopConf;
    }

    public void setHadoopConf(Configuration hadoopConf) {
        this.hadoopConf = hadoopConf;
    }

    public Configuration getHadoopConf() {
        return this.hadoopConf;
    }

    public FileSystem getHadoopFileSystem() {
        return FSUtils.getFs(this.getString(META_SYNC_BASE_PATH), this.getHadoopConf());
    }

    public String getAbsoluteBasePath() {
        return this.getString(META_SYNC_BASE_PATH);
    }

    public String toString() {
        return this.props.toString();
    }

    public static class HoodieSyncConfigParams {
        @Parameter(names={"--database"}, description="name of the target database in meta store")
        public String databaseName;
        @Parameter(names={"--table"}, description="name of the target table in meta store")
        public String tableName;
        @Parameter(names={"--base-path"}, description="Base path of the hoodie table to sync", required=true)
        public String basePath;
        @Parameter(names={"--base-file-format"}, description="Format of the base files (PARQUET (or) HFILE)")
        public String baseFileFormat;
        @Parameter(names={"--partitioned-by"}, description="Fields in the schema partitioned by")
        public List<String> partitionFields;
        @Parameter(names={"--partition-value-extractor"}, description="Class which implements PartitionValueExtractor to extract the partition values from HDFS path")
        public String partitionValueExtractorClass;
        @Parameter(names={"--assume-date-partitioning"}, description="Assume standard yyyy/mm/dd partitioning, this exists to support backward compatibility. If you use hoodie 0.3.x, do not set this parameter")
        public Boolean assumeDatePartitioning;
        @Parameter(names={"--decode-partition"}, description="Decode the partition value if the partition has encoded during writing")
        public Boolean decodePartition;
        @Parameter(names={"--use-file-listing-from-metadata"}, description="Fetch file listing from Hudi's metadata")
        public Boolean useFileListingFromMetadata;
        @Parameter(names={"--conditional-sync"}, description="If true, only sync on conditions like schema change or partition change.")
        public Boolean isConditionalSync;
        @Parameter(names={"--spark-version"}, description="The spark version")
        public String sparkVersion;
        @Parameter(names={"--help", "-h"}, help=true)
        public boolean help = false;

        public boolean isHelp() {
            return this.help;
        }

        public TypedProperties toProps() {
            TypedProperties props = new TypedProperties();
            props.setPropertyIfNonNull(META_SYNC_BASE_PATH.key(), this.basePath);
            props.setPropertyIfNonNull(META_SYNC_DATABASE_NAME.key(), this.databaseName);
            props.setPropertyIfNonNull(META_SYNC_TABLE_NAME.key(), this.tableName);
            props.setPropertyIfNonNull(META_SYNC_BASE_FILE_FORMAT.key(), this.baseFileFormat);
            props.setPropertyIfNonNull(META_SYNC_PARTITION_FIELDS.key(), StringUtils.join((CharSequence)",", this.partitionFields));
            props.setPropertyIfNonNull(META_SYNC_PARTITION_EXTRACTOR_CLASS.key(), this.partitionValueExtractorClass);
            props.setPropertyIfNonNull(META_SYNC_ASSUME_DATE_PARTITION.key(), this.assumeDatePartitioning);
            props.setPropertyIfNonNull(META_SYNC_DECODE_PARTITION.key(), this.decodePartition);
            props.setPropertyIfNonNull(META_SYNC_USE_FILE_LISTING_FROM_METADATA.key(), this.useFileListingFromMetadata);
            props.setPropertyIfNonNull(META_SYNC_CONDITIONAL_SYNC.key(), this.isConditionalSync);
            props.setPropertyIfNonNull(META_SYNC_SPARK_VERSION.key(), this.sparkVersion);
            return props;
        }
    }
}

