/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table;

import java.io.IOException;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.versioning.TimelineLayoutVersion;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieMetadataException;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.index.SparkHoodieIndexFactory;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.metadata.HoodieTableMetadataWriter;
import org.apache.hudi.metadata.SparkHoodieBackedTableMetadataWriter;
import org.apache.hudi.table.HoodieSparkCopyOnWriteTable;
import org.apache.hudi.table.HoodieSparkMergeOnReadTable;
import org.apache.hudi.table.HoodieTable;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskContext$;

public abstract class HoodieSparkTable<T extends HoodieRecordPayload>
extends HoodieTable<T, HoodieData<HoodieRecord<T>>, HoodieData<HoodieKey>, HoodieData<WriteStatus>> {
    private volatile boolean isMetadataTableExists = false;

    protected HoodieSparkTable(HoodieWriteConfig config, HoodieEngineContext context, HoodieTableMetaClient metaClient) {
        super(config, context, metaClient);
    }

    public static <T extends HoodieRecordPayload> HoodieSparkTable<T> create(HoodieWriteConfig config, HoodieEngineContext context) {
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(context.getHadoopConf().get()).setBasePath(config.getBasePath()).setLoadActiveTimelineOnLoad(true).setConsistencyGuardConfig(config.getConsistencyGuardConfig()).setLayoutVersion(Option.of(new TimelineLayoutVersion(config.getTimelineLayoutVersion()))).setFileSystemRetryConfig(config.getFileSystemRetryConfig()).setProperties(config.getProps()).build();
        return HoodieSparkTable.create(config, context, metaClient);
    }

    public static <T extends HoodieRecordPayload> HoodieSparkTable<T> create(HoodieWriteConfig config, HoodieEngineContext context, HoodieTableMetaClient metaClient) {
        HoodieSparkCopyOnWriteTable hoodieSparkTable;
        switch (metaClient.getTableType()) {
            case COPY_ON_WRITE: {
                hoodieSparkTable = new HoodieSparkCopyOnWriteTable(config, context, metaClient);
                break;
            }
            case MERGE_ON_READ: {
                hoodieSparkTable = new HoodieSparkMergeOnReadTable(config, context, metaClient);
                break;
            }
            default: {
                throw new HoodieException("Unsupported table type :" + (Object)((Object)metaClient.getTableType()));
            }
        }
        return hoodieSparkTable;
    }

    @Override
    protected HoodieIndex getIndex(HoodieWriteConfig config, HoodieEngineContext context) {
        return SparkHoodieIndexFactory.createIndex(config);
    }

    @Override
    public <R extends SpecificRecordBase> Option<HoodieTableMetadataWriter> getMetadataWriter(String triggeringInstantTimestamp, Option<R> actionMetadata) {
        block4: {
            if (this.config.isMetadataTableEnabled()) {
                HoodieTableMetadataWriter metadataWriter = SparkHoodieBackedTableMetadataWriter.create(this.context.getHadoopConf().get(), this.config, this.context, actionMetadata, Option.of(triggeringInstantTimestamp));
                this.deleteMetadataIndexIfNecessary();
                try {
                    if (this.isMetadataTableExists || this.metaClient.getFs().exists(new Path(HoodieTableMetadata.getMetadataTableBasePath(this.metaClient.getBasePath())))) {
                        this.isMetadataTableExists = true;
                        return Option.of(metadataWriter);
                    }
                    break block4;
                }
                catch (IOException e) {
                    throw new HoodieMetadataException("Checking existence of metadata table failed", e);
                }
            }
            this.maybeDeleteMetadataTable();
        }
        return Option.empty();
    }

    @Override
    public Runnable getPreExecuteRunnable() {
        TaskContext taskContext = TaskContext.get();
        return () -> TaskContext$.MODULE$.setTaskContext(taskContext);
    }
}

