/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command;

import java.io.Serializable;
import org.apache.hudi.HoodieSparkSqlWriter$;
import org.apache.hudi.SparkAdapterSupport;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.hive.HiveSyncConfig;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.HoodieCatalystPlansUtils;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Alias$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.hudi.HoodieSqlCommonUtils$;
import org.apache.spark.sql.hudi.ProvidesHoodieConfig;
import org.apache.spark.sql.hudi.SparkAdapter;
import org.apache.spark.sql.hudi.command.InsertIntoHoodieTableCommand;
import org.apache.spark.sql.hudi.command.InsertIntoHoodieTableCommand$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.Tuple6;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public final class InsertIntoHoodieTableCommand$
implements ProvidesHoodieConfig,
SparkAdapterSupport,
scala.Serializable {
    public static InsertIntoHoodieTableCommand$ MODULE$;
    private SparkAdapter sparkAdapter;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    static {
        new InsertIntoHoodieTableCommand$();
    }

    @Override
    public Map<String, String> buildHoodieConfig(HoodieCatalogTable hoodieCatalogTable) {
        return ProvidesHoodieConfig.buildHoodieConfig$(this, hoodieCatalogTable);
    }

    @Override
    public Map<String, String> buildHoodieInsertConfig(HoodieCatalogTable hoodieCatalogTable, SparkSession sparkSession, boolean isOverwrite, Map<String, Option<String>> insertPartitions, Map<String, String> extraOptions) {
        return ProvidesHoodieConfig.buildHoodieInsertConfig$(this, hoodieCatalogTable, sparkSession, isOverwrite, insertPartitions, extraOptions);
    }

    @Override
    public Map<String, Option<String>> buildHoodieInsertConfig$default$4() {
        return ProvidesHoodieConfig.buildHoodieInsertConfig$default$4$(this);
    }

    @Override
    public Map<String, String> buildHoodieDropPartitionsConfig(SparkSession sparkSession, HoodieCatalogTable hoodieCatalogTable, String partitionsToDrop) {
        return ProvidesHoodieConfig.buildHoodieDropPartitionsConfig$(this, sparkSession, hoodieCatalogTable, partitionsToDrop);
    }

    @Override
    public Map<String, String> buildHoodieDeleteTableConfig(HoodieCatalogTable hoodieCatalogTable, SparkSession sparkSession) {
        return ProvidesHoodieConfig.buildHoodieDeleteTableConfig$(this, hoodieCatalogTable, sparkSession);
    }

    @Override
    public HiveSyncConfig buildHiveSyncConfig(SparkSession sparkSession, HoodieCatalogTable hoodieCatalogTable, HoodieTableConfig tableConfig, Map<String, String> extraOptions) {
        return ProvidesHoodieConfig.buildHiveSyncConfig$(this, sparkSession, hoodieCatalogTable, tableConfig, extraOptions);
    }

    @Override
    public Map<String, String> buildHiveSyncConfig$default$4() {
        return ProvidesHoodieConfig.buildHiveSyncConfig$default$4$(this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    private SparkAdapter sparkAdapter$lzycompute() {
        InsertIntoHoodieTableCommand$ insertIntoHoodieTableCommand$ = this;
        synchronized (insertIntoHoodieTableCommand$) {
            if (!this.bitmap$0) {
                this.sparkAdapter = SparkAdapterSupport.sparkAdapter$(this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkAdapter;
    }

    @Override
    public SparkAdapter sparkAdapter() {
        return !this.bitmap$0 ? this.sparkAdapter$lzycompute() : this.sparkAdapter;
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public boolean run(SparkSession sparkSession, CatalogTable table, LogicalPlan query, Map<String, Option<String>> partitionSpec, boolean overwrite, boolean refreshTable, Map<String, String> extraOptions) {
        boolean success;
        block2: {
            boolean success2;
            HoodieCatalogTable catalogTable = new HoodieCatalogTable(sparkSession, table);
            Map<String, String> config = this.buildHoodieInsertConfig(catalogTable, sparkSession, overwrite, partitionSpec, extraOptions);
            SaveMode mode = overwrite && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])catalogTable.partitionFields())).isEmpty() ? SaveMode.Overwrite : SaveMode.Append;
            LogicalPlan alignedQuery = this.alignQueryOutput(query, catalogTable, partitionSpec, sparkSession.sessionState().conf());
            Tuple6<Object, org.apache.hudi.common.util.Option<String>, org.apache.hudi.common.util.Option<String>, org.apache.hudi.common.util.Option<String>, SparkRDDWriteClient<HoodieRecordPayload<Nothing$>>, HoodieTableConfig> tuple6 = HoodieSparkSqlWriter$.MODULE$.write(sparkSession.sqlContext(), mode, config, (Dataset<Row>)Dataset$.MODULE$.ofRows(sparkSession, alignedQuery), HoodieSparkSqlWriter$.MODULE$.write$default$5(), HoodieSparkSqlWriter$.MODULE$.write$default$6(), HoodieSparkSqlWriter$.MODULE$.write$default$7(), HoodieSparkSqlWriter$.MODULE$.write$default$8());
            if (tuple6 == null) {
                throw new MatchError(tuple6);
            }
            boolean bl = success2 = BoxesRunTime.unboxToBoolean((Object)tuple6._1());
            success = bl;
            if (!success) {
                throw new HoodieException("Insert Into to Hudi table failed");
            }
            if (!success || !refreshTable) break block2;
            sparkSession.catalog().refreshTable(table.identifier().unquotedString());
        }
        return success;
    }

    public boolean run$default$6() {
        return true;
    }

    public Map<String, String> run$default$7() {
        return Predef$.MODULE$.Map().empty();
    }

    private LogicalPlan alignQueryOutput(LogicalPlan query, HoodieCatalogTable catalogTable, Map<String, Option<String>> partitionsSpec, SQLConf conf) {
        StructType targetPartitionSchema = catalogTable.partitionSchema();
        Map<String, String> staticPartitionValues = this.filterStaticPartitionValues(partitionsSpec);
        LogicalPlan cleanedQuery = this.stripMetaFields(query);
        Seq expectedQueryColumns = (Seq)catalogTable.tableSchemaWithoutMetaFields().filterNot((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)staticPartitionValues.contains((Object)f.name())));
        LogicalPlan coercedQueryOutput = this.coerceQueryOutputColumns(StructType$.MODULE$.apply(expectedQueryColumns), cleanedQuery, catalogTable, conf);
        this.validate(HoodieSqlCommonUtils$.MODULE$.removeMetaFields(coercedQueryOutput.schema()), partitionsSpec, catalogTable);
        Seq<NamedExpression> staticPartitionValuesExprs = this.createStaticPartitionValuesExpressions(staticPartitionValues, targetPartitionSchema, conf);
        return new Project((Seq)coercedQueryOutput.output().$plus$plus(staticPartitionValuesExprs, Seq$.MODULE$.canBuildFrom()), coercedQueryOutput);
    }

    private LogicalPlan coerceQueryOutputColumns(StructType expectedSchema, LogicalPlan query, HoodieCatalogTable catalogTable, SQLConf conf) {
        LogicalPlan logicalPlan;
        HoodieCatalystPlansUtils planUtils = this.sparkAdapter().getCatalystPlanUtils();
        try {
            logicalPlan = planUtils.resolveOutputColumns(catalogTable.catalogTableName(), (Seq<Attribute>)expectedSchema.toAttributes(), query, true, conf);
        }
        catch (Throwable throwable) {
            AnalysisException analysisException;
            Throwable throwable2 = throwable;
            if (!(throwable2 instanceof AnalysisException) || !(analysisException = (AnalysisException)throwable2).getMessage().startsWith("Cannot write incompatible data to table")) {
                throw throwable;
            }
            LogicalPlan logicalPlan2 = planUtils.resolveOutputColumns(catalogTable.catalogTableName(), (Seq<Attribute>)expectedSchema.toAttributes(), query, false, conf);
            logicalPlan = logicalPlan2;
        }
        return logicalPlan;
    }

    private void validate(StructType queryOutputSchema, Map<String, Option<String>> partitionsSpec, HoodieCatalogTable catalogTable) {
        if (partitionsSpec.nonEmpty() && partitionsSpec.size() != catalogTable.partitionSchema().size()) {
            throw new HoodieException(new StringBuilder(51).append("Required partition schema is: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])catalogTable.partitionSchema().fieldNames())).mkString("[", ", ", "]")).append(", ").append("partition spec is: ").append(partitionsSpec.mkString("[", ", ", "]")).toString());
        }
        Map<String, String> staticPartitionValues = this.filterStaticPartitionValues(partitionsSpec);
        StructType fullQueryOutputSchema = new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])queryOutputSchema.fields())).$plus$plus((GenTraversableOnce)staticPartitionValues.keys().map((Function1 & Serializable & scala.Serializable)x$1 -> new StructField(x$1, (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), Iterable$.MODULE$.canBuildFrom()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
        if (!this.conforms(fullQueryOutputSchema, catalogTable.tableSchemaWithoutMetaFields())) {
            throw new HoodieException(new StringBuilder(79).append("Expected table's schema: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])catalogTable.tableSchemaWithoutMetaFields().fields())).mkString("[", ", ", "]")).append(", ").append("query's output (including static partition values): ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fullQueryOutputSchema.fields())).mkString("[", ", ", "]")).toString());
        }
    }

    private Seq<NamedExpression> createStaticPartitionValuesExpressions(Map<String, String> staticPartitionValues, StructType partitionSchema, SQLConf conf) {
        return (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionSchema.fields())).filter((Function1 & Serializable & scala.Serializable)pf -> BoxesRunTime.boxToBoolean((boolean)staticPartitionValues.contains((Object)pf.name()))))).map((Function1 & Serializable & scala.Serializable)pf -> {
            Expression castExpr;
            String staticPartitionValue = (String)staticPartitionValues.apply((Object)pf.name());
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(MODULE$.getClass().getClassLoader());
            public final class Org_apache_spark_sql_hudi_command_InsertIntoHoodieTableCommand$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
                }

                public Org_apache_spark_sql_hudi_command_InsertIntoHoodieTableCommand$$typecreator1$1() {
                }
            }
            Expression x$1 = castExpr = HoodieSqlCommonUtils$.MODULE$.castIfNeeded((Expression)Literal$.MODULE$.create((Object)staticPartitionValue, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hudi_command_InsertIntoHoodieTableCommand$$typecreator1$1())), pf.dataType(), conf);
            String x$2 = pf.name();
            ExprId x$3 = Alias$.MODULE$.apply$default$3(x$1, x$2);
            Seq x$4 = Alias$.MODULE$.apply$default$4(x$1, x$2);
            Option x$5 = Alias$.MODULE$.apply$default$5(x$1, x$2);
            Seq x$6 = Alias$.MODULE$.apply$default$6(x$1, x$2);
            return new Alias(x$1, x$2, x$3, x$4, x$5, x$6);
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    private boolean conforms(StructType sourceSchema, StructType targetSchema) {
        return sourceSchema.fields().length != targetSchema.fields().length ? false : new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])targetSchema.fields())).zip((GenIterable)sourceSchema, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).forall((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)InsertIntoHoodieTableCommand$.$anonfun$conforms$1(x0$1)));
    }

    public LogicalPlan stripMetaFields(LogicalPlan query) {
        Seq filteredOutput;
        Seq seq = filteredOutput = (Seq)query.output().filterNot((Function1 & Serializable & scala.Serializable)attr -> BoxesRunTime.boxToBoolean((boolean)HoodieSqlCommonUtils$.MODULE$.isMetaField(attr.name())));
        Seq seq2 = query.output();
        return !(seq != null ? !seq.equals(seq2) : seq2 != null) ? query : new Project(filteredOutput, query);
    }

    private Map<String, String> filterStaticPartitionValues(Map<String, Option<String>> partitionsSpec) {
        return ((MapLike)partitionsSpec.filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)InsertIntoHoodieTableCommand$.$anonfun$filterStaticPartitionValues$1(p)))).mapValues((Function1 & Serializable & scala.Serializable)x$2 -> (String)x$2.get());
    }

    public InsertIntoHoodieTableCommand apply(LogicalRelation logicalRelation, LogicalPlan query, Map<String, Option<String>> partitionSpec, boolean overwrite) {
        return new InsertIntoHoodieTableCommand(logicalRelation, query, partitionSpec, overwrite);
    }

    public Option<Tuple4<LogicalRelation, LogicalPlan, Map<String, Option<String>>, Object>> unapply(InsertIntoHoodieTableCommand x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple4((Object)x$0.logicalRelation(), (Object)x$0.query(), x$0.partitionSpec(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.overwrite())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$conforms$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        StructField targetColumn = (StructField)tuple2._1();
        StructField sourceColumn = (StructField)tuple2._2();
        boolean bl = Cast$.MODULE$.canCast(sourceColumn.dataType(), targetColumn.dataType());
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$filterStaticPartitionValues$1(Tuple2 p) {
        return ((Option)p._2()).isDefined();
    }

    private InsertIntoHoodieTableCommand$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        ProvidesHoodieConfig.$init$(this);
        SparkAdapterSupport.$init$(this);
    }
}

