/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command;

import java.io.Serializable;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.DataSourceOptionsHelper$;
import org.apache.hudi.DataSourceUtils;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.client.utils.SparkInternalSchemaConverter;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.CommitUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.internal.schema.action.TableChange;
import org.apache.hudi.internal.schema.convert.AvroInternalSchemaConverter;
import org.apache.hudi.internal.schema.io.FileBasedInternalSchemaStorageManager;
import org.apache.hudi.internal.schema.utils.SerDeHelper;
import org.apache.hudi.table.HoodieSparkTable;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.connector.catalog.TableChange;
import org.apache.spark.sql.hudi.command.Spark31AlterTableCommand;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

public final class Spark31AlterTableCommand$
implements Logging,
scala.Serializable {
    public static Spark31AlterTableCommand$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new Spark31AlterTableCommand$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public void commitWithSchema(InternalSchema internalSchema, String historySchemaStr, CatalogTable table, SparkSession sparkSession) {
        block6: {
            Schema schema = AvroInternalSchemaConverter.convert(internalSchema, table.identifier().table());
            String path = this.getTableLocation(table, sparkSession);
            JavaSparkContext jsc = new JavaSparkContext(sparkSession.sparkContext());
            SparkRDDWriteClient client = DataSourceUtils.createHoodieClient(jsc, schema.toString(), path, table.identifier().table(), (Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.parametersWithWriteDefaults((scala.collection.immutable.Map<String, String>)table.storage().properties())).asJava());
            Configuration hadoopConf = sparkSession.sessionState().newHadoopConf();
            HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setBasePath(path).setConf(hadoopConf).build();
            String commitActionType = CommitUtils.getCommitActionType(WriteOperationType.ALTER_SCHEMA, metaClient.getTableType());
            String instantTime = HoodieActiveTimeline.createNewInstantTime();
            client.startCommitWithTime(instantTime, commitActionType);
            HoodieSparkTable hoodieTable = HoodieSparkTable.create(client.getConfig(), client.getEngineContext());
            HoodieActiveTimeline timeLine = hoodieTable.getActiveTimeline();
            HoodieInstant requested = new HoodieInstant(HoodieInstant.State.REQUESTED, commitActionType, instantTime);
            HoodieCommitMetadata metadata = new HoodieCommitMetadata();
            metadata.setOperationType(WriteOperationType.ALTER_SCHEMA);
            timeLine.transitionRequestedToInflight(requested, org.apache.hudi.common.util.Option.of(metadata.toJsonString().getBytes(StandardCharsets.UTF_8)));
            HashMap<String, String> extraMeta = new HashMap<String, String>();
            extraMeta.put("latest_schema", SerDeHelper.toJson(internalSchema.setSchemaId(new StringOps(Predef$.MODULE$.augmentString(instantTime)).toLong())));
            FileBasedInternalSchemaStorageManager schemaManager = new FileBasedInternalSchemaStorageManager(metaClient);
            schemaManager.persistHistorySchemaStr(instantTime, SerDeHelper.inheritSchemas(internalSchema, historySchemaStr));
            client.commit(instantTime, jsc.emptyRDD(), org.apache.hudi.common.util.Option.of(extraMeta));
            boolean existRoTable = sparkSession.catalog().tableExists(new StringBuilder(3).append(table.identifier().unquotedString()).append("_ro").toString());
            boolean existRtTable = sparkSession.catalog().tableExists(new StringBuilder(3).append(table.identifier().unquotedString()).append("_rt").toString());
            try {
                sparkSession.catalog().refreshTable(table.identifier().unquotedString());
                if (existRoTable) {
                    sparkSession.catalog().refreshTable(new StringBuilder(3).append(table.identifier().unquotedString()).append("_ro").toString());
                }
                if (existRoTable) {
                    sparkSession.catalog().refreshTable(new StringBuilder(3).append(table.identifier().unquotedString()).append("_rt").toString());
                }
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    this.log().error(new StringBuilder(43).append("Exception when attempting to refresh table ").append(table.identifier().quotedString()).toString(), e);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                throw throwable;
            }
            StructType fullSparkSchema = SparkInternalSchemaConverter.constructSparkSchemaFromInternalSchema(internalSchema);
            StructType dataSparkSchema = new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fullSparkSchema.fields())).filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)Spark31AlterTableCommand$.$anonfun$commitWithSchema$1(table, sparkSession, p))));
            this.alterTableDataSchema(sparkSession, (String)table.identifier().database().getOrElse((Function0 & Serializable & scala.Serializable)() -> "default"), table.identifier().table(), dataSparkSchema);
            if (existRoTable) {
                this.alterTableDataSchema(sparkSession, (String)table.identifier().database().getOrElse((Function0 & Serializable & scala.Serializable)() -> "default"), new StringBuilder(3).append(table.identifier().table()).append("_ro").toString(), dataSparkSchema);
            }
            if (!existRtTable) break block6;
            this.alterTableDataSchema(sparkSession, (String)table.identifier().database().getOrElse((Function0 & Serializable & scala.Serializable)() -> "default"), new StringBuilder(3).append(table.identifier().table()).append("_rt").toString(), dataSparkSchema);
        }
    }

    public void alterTableDataSchema(SparkSession sparkSession, String db, String tableName, StructType dataSparkSchema) {
        sparkSession.sessionState().catalog().externalCatalog().alterTableDataSchema(db, tableName, dataSparkSchema);
    }

    public String getTableLocation(CatalogTable table, SparkSession sparkSession) {
        CatalogTableType catalogTableType = table.tableType();
        CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.MANAGED();
        Some uri2 = !(catalogTableType != null ? !catalogTableType.equals(catalogTableType2) : catalogTableType2 != null) ? new Some((Object)sparkSession.sessionState().catalog().defaultTablePath(table.identifier())) : table.storage().locationUri();
        Configuration conf = sparkSession.sessionState().newHadoopConf();
        return (String)uri2.map((Function1 & Serializable & scala.Serializable)x$11 -> MODULE$.makePathQualified((URI)x$11, conf)).map((Function1 & Serializable & scala.Serializable)path -> MODULE$.removePlaceHolder((String)path)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(21).append("Missing location for ").append(table.identifier()).toString());
        });
    }

    private String removePlaceHolder(String path) {
        return path == null || path.length() == 0 ? path : (path.endsWith("-__PLACEHOLDER__") ? path.substring(0, path.length() - 16) : path);
    }

    public String makePathQualified(URI path, Configuration hadoopConf) {
        Path hadoopPath = new Path(path);
        FileSystem fs = hadoopPath.getFileSystem(hadoopConf);
        return fs.makeQualified(hadoopPath).toUri().toString();
    }

    public String getParentName(String[] names) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])names)).size() > 1 ? new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])names)).dropRight(1))).mkString(".") : "";
    }

    public scala.collection.immutable.Map<String, String> parametersWithWriteDefaults(scala.collection.immutable.Map<String, String> parameters) {
        return ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.OPERATION().key()), (Object)DataSourceWriteOptions$.MODULE$.OPERATION().defaultValue()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().defaultValue()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), (Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().defaultValue()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.WRITE_PAYLOAD_CLASS_NAME.key()), (Object)HoodieWriteConfig.DEFAULT_WRITE_PAYLOAD_CLASS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.INSERT_DROP_DUPS().key()), (Object)DataSourceWriteOptions$.MODULE$.INSERT_DROP_DUPS().defaultValue()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.ASYNC_COMPACT_ENABLE().key()), (Object)DataSourceWriteOptions$.MODULE$.ASYNC_COMPACT_ENABLE().defaultValue()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.INLINE_CLUSTERING_ENABLE().key()), (Object)DataSourceWriteOptions$.MODULE$.INLINE_CLUSTERING_ENABLE().defaultValue()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.ASYNC_CLUSTERING_ENABLE().key()), (Object)DataSourceWriteOptions$.MODULE$.ASYNC_CLUSTERING_ENABLE().defaultValue())}))).$plus$plus(DataSourceOptionsHelper$.MODULE$.translateConfigurations(parameters));
    }

    public void checkSchemaChange(Seq<String> colNames, CatalogTable catalogTable) {
        String[] primaryKeys = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((String)catalogTable.storage().properties().getOrElse((Object)"primaryKey", (Function0 & Serializable & scala.Serializable)() -> (String)catalogTable.properties().getOrElse((Object)"primaryKey", (Function0 & Serializable & scala.Serializable)() -> "keyid"))).split(","))).map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.trim(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        Seq preCombineKey = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)catalogTable.storage().properties().getOrElse((Object)"preCombineField", (Function0 & Serializable & scala.Serializable)() -> (String)catalogTable.properties().getOrElse((Object)"preCombineField", (Function0 & Serializable & scala.Serializable)() -> "ts"))}))).map((Function1 & Serializable & scala.Serializable)x$13 -> x$13.trim(), Seq$.MODULE$.canBuildFrom());
        Seq partitionKey = (Seq)catalogTable.partitionColumnNames().map((Function1 & Serializable & scala.Serializable)x$14 -> x$14.trim(), Seq$.MODULE$.canBuildFrom());
        String[] checkNames = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])primaryKeys)).$plus$plus((GenTraversableOnce)preCombineKey, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).$plus$plus((GenTraversableOnce)partitionKey, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        colNames.foreach((Function1 & Serializable & scala.Serializable)col -> {
            Spark31AlterTableCommand$.$anonfun$checkSchemaChange$8(checkNames, col);
            return BoxedUnit.UNIT;
        });
    }

    public Spark31AlterTableCommand apply(CatalogTable table, Seq<TableChange> changes, TableChange.ColumnChangeID changeType) {
        return new Spark31AlterTableCommand(table, changes, changeType);
    }

    public Option<Tuple3<CatalogTable, Seq<TableChange>, TableChange.ColumnChangeID>> unapply(Spark31AlterTableCommand x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple3((Object)x$0.table(), x$0.changes(), (Object)x$0.changeType()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$commitWithSchema$2(SparkSession sparkSession$1, StructField p$1, String f) {
        return BoxesRunTime.unboxToBoolean((Object)sparkSession$1.sessionState().conf().resolver().apply((Object)f, (Object)p$1.name()));
    }

    public static final /* synthetic */ boolean $anonfun$commitWithSchema$1(CatalogTable table$1, SparkSession sparkSession$1, StructField p) {
        return !table$1.partitionColumnNames().exists((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)Spark31AlterTableCommand$.$anonfun$commitWithSchema$2(sparkSession$1, p, f)));
    }

    public static final /* synthetic */ void $anonfun$checkSchemaChange$8(String[] checkNames$1, String col) {
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])checkNames$1)).contains((Object)col)) {
            throw new UnsupportedOperationException("cannot support apply changes for primaryKey/CombineKey/partitionKey");
        }
    }

    private Spark31AlterTableCommand$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

