/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.payload;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import io.hops.hudi.org.apache.spark.sql.avro.HoodieAvroDeserializer;
import java.util.function.Function;
import org.apache.avro.Schema;
import org.apache.hudi.AvroConversionUtils$;
import org.apache.hudi.HoodieSparkUtils$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;

public final class SqlTypedRecord$ {
    public static SqlTypedRecord$ MODULE$;
    private final Cache<Schema, StructType> sqlTypeCache;
    private final ThreadLocal<Cache<Schema, HoodieAvroDeserializer>> avroDeserializerCacheLocal;

    static {
        new SqlTypedRecord$();
    }

    private Cache<Schema, StructType> sqlTypeCache() {
        return this.sqlTypeCache;
    }

    private ThreadLocal<Cache<Schema, HoodieAvroDeserializer>> avroDeserializerCacheLocal() {
        return this.avroDeserializerCacheLocal;
    }

    public StructType getSqlType(Schema schema) {
        return this.sqlTypeCache().get(schema, new Function<Schema, StructType>(){

            public <V> Function<V, StructType> compose(Function<? super V, ? extends Schema> x$1) {
                return Function.super.compose(x$1);
            }

            public <V> Function<Schema, V> andThen(Function<? super StructType, ? extends V> x$1) {
                return Function.super.andThen(x$1);
            }

            public StructType apply(Schema t) {
                return AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(t);
            }
        });
    }

    public HoodieAvroDeserializer getAvroDeserializer(Schema schema) {
        return this.avroDeserializerCacheLocal().get().get(schema, new Function<Schema, HoodieAvroDeserializer>(){

            public <V> Function<V, HoodieAvroDeserializer> compose(Function<? super V, ? extends Schema> x$1) {
                return Function.super.compose(x$1);
            }

            public <V> Function<Schema, V> andThen(Function<? super HoodieAvroDeserializer, ? extends V> x$1) {
                return Function.super.andThen(x$1);
            }

            public HoodieAvroDeserializer apply(Schema t) {
                return HoodieSparkUtils$.MODULE$.sparkAdapter().createAvroDeserializer(t, (DataType)SqlTypedRecord$.MODULE$.getSqlType(t));
            }
        });
    }

    private SqlTypedRecord$() {
        MODULE$ = this;
        this.sqlTypeCache = Caffeine.newBuilder().maximumSize(16L).build();
        this.avroDeserializerCacheLocal = new ThreadLocal<Cache<Schema, HoodieAvroDeserializer>>(){

            public Cache<Schema, HoodieAvroDeserializer> initialValue() {
                return Caffeine.newBuilder().maximumSize(16L).build();
            }
        };
    }
}

