/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.procedures;

import io.hops.hudi.com.codahale.metrics.Histogram;
import io.hops.hudi.com.codahale.metrics.Snapshot;
import io.hops.hudi.com.codahale.metrics.UniformReservoir;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.fs.HoodieWrapperFileSystem;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.hudi.command.procedures.BaseProcedure;
import org.apache.spark.sql.hudi.command.procedures.Procedure;
import org.apache.spark.sql.hudi.command.procedures.ProcedureArgs;
import org.apache.spark.sql.hudi.command.procedures.ProcedureBuilder;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter$;
import org.apache.spark.sql.hudi.command.procedures.StatsFileSizeProcedure$;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015b\u0001B\b\u0011\u0001}AQa\n\u0001\u0005\u0002!BQA\u000b\u0001\u0005B-BQ!\u000e\u0001\u0005BYBQ!\u0010\u0001\u0005ByBQ\u0001\u0016\u0001\u0005\u0002UCQ\u0001\u001c\u0001\u0005B5<Q!\u001d\t\t\u0002I4Qa\u0004\t\t\u0002MDQa\n\u0005\u0005\u0002]Dq\u0001\u001f\u0005C\u0002\u0013\u0005\u0011\u0010\u0003\u0004~\u0011\u0001\u0006IA\u001f\u0005\b}\"\u0011\r\u0011\"\u0001\u0000\u0011!\ty\u0001\u0003Q\u0001\n\u0005\u0005\u0001bBA\t\u0011\u0011\u0005\u00111\u0003\u0002\u0017'R\fGo\u001d$jY\u0016\u001c\u0016N_3Qe>\u001cW\rZ;sK*\u0011\u0011CE\u0001\u000baJ|7-\u001a3ve\u0016\u001c(BA\n\u0015\u0003\u001d\u0019w.\\7b]\u0012T!!\u0006\f\u0002\t!,H-\u001b\u0006\u0003/a\t1a]9m\u0015\tI\"$A\u0003ta\u0006\u00148N\u0003\u0002\u001c9\u00051\u0011\r]1dQ\u0016T\u0011!H\u0001\u0004_J<7\u0001A\n\u0004\u0001\u0001\"\u0003CA\u0011#\u001b\u0005\u0001\u0012BA\u0012\u0011\u00055\u0011\u0015m]3Qe>\u001cW\rZ;sKB\u0011\u0011%J\u0005\u0003MA\u0011\u0001\u0003\u0015:pG\u0016$WO]3Ck&dG-\u001a:\u0002\rqJg.\u001b;?)\u0005I\u0003CA\u0011\u0001\u0003)\u0001\u0018M]1nKR,'o]\u000b\u0002YA\u0019Q\u0006\r\u001a\u000e\u00039R\u0011aL\u0001\u0006g\u000e\fG.Y\u0005\u0003c9\u0012Q!\u0011:sCf\u0004\"!I\u001a\n\u0005Q\u0002\"A\u0005)s_\u000e,G-\u001e:f!\u0006\u0014\u0018-\\3uKJ\f!b\\;uaV$H+\u001f9f+\u00059\u0004C\u0001\u001d<\u001b\u0005I$B\u0001\u001e\u0017\u0003\u0015!\u0018\u0010]3t\u0013\ta\u0014H\u0001\u0006TiJ,8\r\u001e+za\u0016\fAaY1mYR\u0011qh\u0014\t\u0004\u0001\"[eBA!G\u001d\t\u0011U)D\u0001D\u0015\t!e$\u0001\u0004=e>|GOP\u0005\u0002_%\u0011qIL\u0001\ba\u0006\u001c7.Y4f\u0013\tI%JA\u0002TKFT!a\u0012\u0018\u0011\u00051kU\"\u0001\f\n\u000593\"a\u0001*po\")\u0001\u000b\u0002a\u0001#\u0006!\u0011M]4t!\t\t#+\u0003\u0002T!\ti\u0001K]8dK\u0012,(/Z!sON\fa\u0003\u001d:j]R4\u0015\u000e\\3TSj,\u0007*[:u_\u001e\u0014\u0018-\u001c\u000b\u0004\u0017Z\u0003\u0007\"B,\u0006\u0001\u0004A\u0016aC5ogR\fg\u000e\u001e+j[\u0016\u0004\"!W/\u000f\u0005i[\u0006C\u0001\"/\u0013\taf&\u0001\u0004Qe\u0016$WMZ\u0005\u0003=~\u0013aa\u0015;sS:<'B\u0001//\u0011\u0015\tW\u00011\u0001c\u0003!\u0019h.\u00199tQ>$\bCA2k\u001b\u0005!'BA3g\u0003\u001diW\r\u001e:jGNT!a\u001a5\u0002\u0011\r|G-\u00195bY\u0016T\u0011![\u0001\u0004G>l\u0017BA6e\u0005!\u0019f.\u00199tQ>$\u0018!\u00022vS2$W#\u00018\u0011\u0005\u0005z\u0017B\u00019\u0011\u0005%\u0001&o\\2fIV\u0014X-\u0001\fTi\u0006$8OR5mKNK'0\u001a)s_\u000e,G-\u001e:f!\t\t\u0003b\u0005\u0002\tiB\u0011Q&^\u0005\u0003m:\u0012a!\u00118z%\u00164G#\u0001:\u0002\u00135\u000b\u0005l\u0018$J\u0019\u0016\u001bV#\u0001>\u0011\u00055Z\u0018B\u0001?/\u0005\rIe\u000e^\u0001\u000b\u001b\u0006CvLR%M\u000bN\u0003\u0013\u0001\u0002(B\u001b\u0016+\"!!\u0001\u0011\t\u0005\r\u0011QB\u0007\u0003\u0003\u000bQA!a\u0002\u0002\n\u0005!A.\u00198h\u0015\t\tY!\u0001\u0003kCZ\f\u0017b\u00010\u0002\u0006\u0005)a*Q'FA\u00059!-^5mI\u0016\u0014XCAA\u000b!\u0015\t9\"!\t%\u001b\t\tIB\u0003\u0003\u0002\u001c\u0005u\u0011\u0001\u00034v]\u000e$\u0018n\u001c8\u000b\t\u0005}\u0011\u0011B\u0001\u0005kRLG.\u0003\u0003\u0002$\u0005e!\u0001C*vaBd\u0017.\u001a:")
public class StatsFileSizeProcedure
extends BaseProcedure
implements ProcedureBuilder {
    public static Supplier<ProcedureBuilder> builder() {
        return StatsFileSizeProcedure$.MODULE$.builder();
    }

    public static String NAME() {
        return StatsFileSizeProcedure$.MODULE$.NAME();
    }

    public static int MAX_FILES() {
        return StatsFileSizeProcedure$.MODULE$.MAX_FILES();
    }

    @Override
    public ProcedureParameter[] parameters() {
        return (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.required(0, "table", DataTypes.StringType, None$.MODULE$), ProcedureParameter$.MODULE$.optional(1, "partition_path", DataTypes.StringType, ""), ProcedureParameter$.MODULE$.optional(2, "limit", DataTypes.IntegerType, BoxesRunTime.boxToInteger((int)10))});
    }

    @Override
    public StructType outputType() {
        return new StructType((StructField[])((Object[])new StructField[]{new StructField("commit_time", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("min", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("10th", DataTypes.DoubleType, true, Metadata$.MODULE$.empty()), new StructField("50th", DataTypes.DoubleType, true, Metadata$.MODULE$.empty()), new StructField("avg", DataTypes.DoubleType, true, Metadata$.MODULE$.empty()), new StructField("95th", DataTypes.DoubleType, true, Metadata$.MODULE$.empty()), new StructField("max", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("num_files", DataTypes.IntegerType, true, Metadata$.MODULE$.empty()), new StructField("std_dev", DataTypes.DoubleType, true, Metadata$.MODULE$.empty())}));
    }

    @Override
    public Seq<Row> call(ProcedureArgs args2) {
        this.checkArgs(this.parameters(), args2);
        Option<Object> table = this.getArgValueOrDefault(args2, this.parameters()[0]);
        String globRegex = (String)this.getArgValueOrDefault(args2, this.parameters()[1]).get();
        int limit = BoxesRunTime.unboxToInt((Object)this.getArgValueOrDefault(args2, this.parameters()[2]).get());
        String basePath = this.getBasePath(table, this.getBasePath$default$2());
        HoodieWrapperFileSystem fs = HoodieTableMetaClient.builder().setConf(this.jsc().hadoopConfiguration()).setBasePath(basePath).build().getFs();
        String globPath = String.format("%s/%s/*", basePath, globRegex);
        List<FileStatus> statuses = FSUtils.getGlobStatusExcludingMetaFolder(fs, new Path(globPath));
        Histogram globalHistogram = new Histogram(new UniformReservoir(StatsFileSizeProcedure$.MODULE$.MAX_FILES()));
        HashMap commitHistogramMap = new HashMap();
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(statuses).asScala()).foreach((Function1 & Serializable & scala.Serializable)status -> {
            StatsFileSizeProcedure.$anonfun$call$1(commitHistogramMap, globalHistogram, status);
            return BoxedUnit.UNIT;
        });
        ArrayList<Row> rows = new ArrayList<Row>();
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(commitHistogramMap).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)StatsFileSizeProcedure.$anonfun$call$2(this, rows, x0$1)));
        Snapshot snapshot = globalHistogram.getSnapshot();
        rows.add(this.printFileSizeHistogram("ALL", snapshot));
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(rows.stream().limit(limit).toArray())).map((Function1 & Serializable & scala.Serializable)r -> (Row)r, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Row.class))))).toList();
    }

    public Row printFileSizeHistogram(String instantTime, Snapshot snapshot) {
        return Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{instantTime, BoxesRunTime.boxToLong((long)snapshot.getMin()), BoxesRunTime.boxToDouble((double)snapshot.getValue(0.1)), BoxesRunTime.boxToDouble((double)snapshot.getMedian()), BoxesRunTime.boxToDouble((double)snapshot.getMean()), BoxesRunTime.boxToDouble((double)snapshot.get95thPercentile()), BoxesRunTime.boxToLong((long)snapshot.getMax()), BoxesRunTime.boxToInteger((int)snapshot.size()), BoxesRunTime.boxToDouble((double)snapshot.getStdDev())}));
    }

    @Override
    public Procedure build() {
        return new StatsFileSizeProcedure();
    }

    public static final /* synthetic */ void $anonfun$call$1(HashMap commitHistogramMap$1, Histogram globalHistogram$1, FileStatus status) {
        String instantTime = FSUtils.getCommitTime(status.getPath().getName());
        long len = status.getLen();
        commitHistogramMap$1.putIfAbsent(instantTime, new Histogram(new UniformReservoir(StatsFileSizeProcedure$.MODULE$.MAX_FILES())));
        ((Histogram)commitHistogramMap$1.get(instantTime)).update(len);
        globalHistogram$1.update(len);
    }

    public static final /* synthetic */ boolean $anonfun$call$2(StatsFileSizeProcedure $this, List rows$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String instantTime = (String)tuple2._1();
        Histogram histogram = (Histogram)tuple2._2();
        Snapshot snapshot = histogram.getSnapshot();
        boolean bl = rows$1.add($this.printFileSizeHistogram(instantTime, snapshot));
        return bl;
    }
}

