/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.jsr310.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import java.io.IOException;
import java.time.DateTimeException;
import java.util.Arrays;

abstract class JSR310DeserializerBase<T>
extends StdScalarDeserializer<T> {
    private static final long serialVersionUID = 1L;

    protected JSR310DeserializerBase(Class<T> supportedType) {
        super(supportedType);
    }

    protected JSR310DeserializerBase(JSR310DeserializerBase<?> base) {
        super(base);
    }

    public Object deserializeWithType(JsonParser parser, DeserializationContext context, TypeDeserializer typeDeserializer) throws IOException {
        return typeDeserializer.deserializeTypedFromAny(parser, context);
    }

    protected <BOGUS> BOGUS _reportWrongToken(DeserializationContext context, JsonToken exp, String unit) throws IOException {
        context.reportWrongTokenException((JsonDeserializer)this, exp, "Expected %s for '%s' of %s value", new Object[]{exp.name(), unit, this.handledType().getName()});
        return null;
    }

    protected <BOGUS> BOGUS _reportWrongToken(JsonParser parser, DeserializationContext context, JsonToken ... expTypes) throws IOException {
        return (BOGUS)context.reportInputMismatch(this.handledType(), "Unexpected token (%s), expected one of %s for %s value", new Object[]{parser.getCurrentToken(), Arrays.asList(expTypes).toString(), this.handledType().getName()});
    }

    protected <R> R _handleDateTimeException(DeserializationContext context, DateTimeException e0, String value) throws JsonMappingException {
        try {
            return (R)context.handleWeirdStringValue(this.handledType(), value, "Failed to deserialize %s: (%s) %s", new Object[]{this.handledType().getName(), e0.getClass().getName(), e0.getMessage()});
        }
        catch (JsonMappingException e) {
            e.initCause((Throwable)e0);
            throw e;
        }
        catch (IOException e) {
            if (null == e.getCause()) {
                e.initCause(e0);
            }
            throw JsonMappingException.fromUnexpectedIOE((IOException)e);
        }
    }

    protected <R> R _handleUnexpectedToken(DeserializationContext context, JsonParser parser, String message, Object ... args2) throws JsonMappingException {
        try {
            return (R)context.handleUnexpectedToken(this.handledType(), parser.getCurrentToken(), parser, message, args2);
        }
        catch (JsonMappingException e) {
            throw e;
        }
        catch (IOException e) {
            throw JsonMappingException.fromUnexpectedIOE((IOException)e);
        }
    }

    protected <R> R _handleUnexpectedToken(DeserializationContext context, JsonParser parser, JsonToken ... expTypes) throws JsonMappingException {
        return this._handleUnexpectedToken(context, parser, "Unexpected token (%s), expected one of %s for %s value", parser.currentToken(), Arrays.asList(expTypes), this.handledType().getName());
    }

    protected DateTimeException _peelDTE(DateTimeException e) {
        Throwable t;
        while ((t = e.getCause()) != null && t instanceof DateTimeException) {
            e = (DateTimeException)t;
        }
        return e;
    }
}

