/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase;

import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RunnableScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class JitterScheduledThreadPoolExecutorImpl
extends ScheduledThreadPoolExecutor {
    private final double spread;

    public JitterScheduledThreadPoolExecutorImpl(int corePoolSize, ThreadFactory threadFactory, double spread) {
        super(corePoolSize, threadFactory);
        this.spread = spread;
    }

    @Override
    protected <V> RunnableScheduledFuture<V> decorateTask(Runnable runnable, RunnableScheduledFuture<V> task) {
        return new JitteredRunnableScheduledFuture<V>(task);
    }

    @Override
    protected <V> RunnableScheduledFuture<V> decorateTask(Callable<V> callable, RunnableScheduledFuture<V> task) {
        return new JitteredRunnableScheduledFuture<V>(task);
    }

    protected class JitteredRunnableScheduledFuture<V>
    implements RunnableScheduledFuture<V> {
        private final RunnableScheduledFuture<V> wrapped;

        JitteredRunnableScheduledFuture(RunnableScheduledFuture<V> wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public boolean isPeriodic() {
            return this.wrapped.isPeriodic();
        }

        @Override
        public long getDelay(TimeUnit unit) {
            long baseDelay = this.wrapped.getDelay(unit);
            long spreadTime = (long)((double)baseDelay * JitterScheduledThreadPoolExecutorImpl.this.spread);
            long delay = spreadTime <= 0L ? baseDelay : baseDelay + ThreadLocalRandom.current().nextLong(-spreadTime, spreadTime);
            return delay < 0L ? baseDelay : delay;
        }

        @Override
        public int compareTo(Delayed o) {
            return this.wrapped.compareTo(o);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            return obj instanceof Delayed ? this.compareTo((Delayed)obj) == 0 : false;
        }

        public int hashCode() {
            return this.wrapped.hashCode();
        }

        @Override
        public void run() {
            this.wrapped.run();
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.wrapped.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this.wrapped.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.wrapped.isDone();
        }

        @Override
        public V get() throws InterruptedException, ExecutionException {
            return this.wrapped.get();
        }

        @Override
        public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.wrapped.get(timeout, unit);
        }
    }
}

