/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.io.encoding;

import io.hops.hudi.org.apache.hadoop.hbase.Cell;
import io.hops.hudi.org.apache.hadoop.hbase.KeyValueUtil;
import io.hops.hudi.org.apache.hadoop.hbase.PrivateCellUtil;
import io.hops.hudi.org.apache.hadoop.hbase.io.encoding.HFileBlockDefaultEncodingContext;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.hadoop.io.WritableUtils;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class NoneEncoder {
    private DataOutputStream out;
    private HFileBlockDefaultEncodingContext encodingCtx;

    public NoneEncoder(DataOutputStream out, HFileBlockDefaultEncodingContext encodingCtx) {
        this.out = out;
        this.encodingCtx = encodingCtx;
    }

    public int write(Cell cell) throws IOException {
        int size = KeyValueUtil.oswrite(cell, this.out, false);
        if (this.encodingCtx.getHFileContext().isIncludesTags()) {
            int tagsLength = cell.getTagsLength();
            this.out.writeShort(tagsLength);
            if (tagsLength > 0) {
                PrivateCellUtil.writeTags(this.out, cell, tagsLength);
            }
            size += tagsLength + 2;
        }
        if (this.encodingCtx.getHFileContext().isIncludesMvcc()) {
            WritableUtils.writeVLong((DataOutput)this.out, (long)cell.getSequenceId());
            size += WritableUtils.getVIntSize((long)cell.getSequenceId());
        }
        return size;
    }
}

