/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.master.balancer;

import io.hops.hudi.org.apache.hadoop.hbase.master.balancer.MetricsBalancerSource;
import io.hops.hudi.org.apache.hadoop.hbase.metrics.BaseSourceImpl;
import io.hops.hudi.org.apache.hadoop.metrics2.MetricHistogram;
import io.hops.hudi.org.apache.hadoop.metrics2.lib.MutableFastCounter;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MetricsBalancerSourceImpl
extends BaseSourceImpl
implements MetricsBalancerSource {
    private MetricHistogram blanceClusterHisto;
    private MutableFastCounter miscCount;

    public MetricsBalancerSourceImpl() {
        this("Balancer", "Metrics about HBase master balancer", "master", "Master,sub=Balancer");
    }

    public MetricsBalancerSourceImpl(String metricsName, String metricsDescription, String metricsContext, String metricsJmxContext) {
        super(metricsName, metricsDescription, metricsContext, metricsJmxContext);
        this.updateBalancerStatus(true);
    }

    @Override
    public void init() {
        this.blanceClusterHisto = this.metricsRegistry.newTimeHistogram("balancerCluster");
        this.miscCount = this.metricsRegistry.newCounter("miscInvocationCount", "", 0L);
    }

    @Override
    public void updateBalanceCluster(long time) {
        this.blanceClusterHisto.add(time);
    }

    @Override
    public void incrMiscInvocations() {
        this.miscCount.incr();
    }

    @Override
    public void updateBalancerStatus(boolean status) {
        this.metricsRegistry.tag("isBalancerActive", "", String.valueOf(status), true);
    }
}

