/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.regionserver;

import io.hops.hudi.org.apache.hadoop.hbase.Cell;
import io.hops.hudi.org.apache.hadoop.hbase.PrivateCellUtil;
import io.hops.hudi.org.apache.hadoop.hbase.client.Scan;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.HStore;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.NonLazyKeyValueScanner;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.Segment;
import java.io.IOException;
import java.util.Iterator;
import java.util.SortedSet;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.hadoop.fs.Path;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class SegmentScanner
implements KeyValueScanner {
    protected final Segment segment;
    private long readPoint;
    protected Iterator<Cell> iter;
    protected Cell current = null;
    private boolean stopSkippingKVsIfNextRow = false;
    private Cell stopSkippingKVsRow;
    private Cell last = null;
    protected boolean closed = false;

    protected SegmentScanner(Segment segment, long readPoint) {
        this.segment = segment;
        this.readPoint = readPoint;
        this.segment.incScannerCount();
        this.iter = segment.iterator();
        this.updateCurrent();
        if (this.current == null) {
            this.close();
        }
    }

    @Override
    public Cell peek() {
        if (this.closed) {
            return null;
        }
        if (this.current != null && this.current.getSequenceId() > this.readPoint) {
            throw new RuntimeException("current is invalid: read point is " + this.readPoint + ", while current sequence id is " + this.current.getSequenceId());
        }
        return this.current;
    }

    @Override
    public Cell next() throws IOException {
        if (this.closed) {
            return null;
        }
        Cell oldCurrent = this.current;
        this.updateCurrent();
        return oldCurrent;
    }

    @Override
    public boolean seek(Cell cell) throws IOException {
        if (this.closed) {
            return false;
        }
        if (cell == null) {
            this.close();
            return false;
        }
        this.iter = this.getIterator(cell);
        this.last = null;
        this.updateCurrent();
        return this.current != null;
    }

    protected Iterator<Cell> getIterator(Cell cell) {
        return this.segment.tailSet(cell).iterator();
    }

    @Override
    public boolean reseek(Cell cell) throws IOException {
        if (this.closed) {
            return false;
        }
        this.iter = this.getIterator(this.getHighest(cell, this.last));
        this.updateCurrent();
        return this.current != null;
    }

    @Override
    public boolean backwardSeek(Cell key) throws IOException {
        if (this.closed) {
            return false;
        }
        this.seek(key);
        if (this.peek() == null || this.segment.compareRows(this.peek(), key) > 0) {
            return this.seekToPreviousRow(key);
        }
        return true;
    }

    @Override
    public boolean seekToPreviousRow(Cell cell) throws IOException {
        boolean keepSeeking;
        if (this.closed) {
            return false;
        }
        Cell key = cell;
        do {
            Cell firstKeyOnRow;
            SortedSet<Cell> cellHead;
            Cell lastCellBeforeRow;
            Cell cell2 = lastCellBeforeRow = (cellHead = this.segment.headSet(firstKeyOnRow = PrivateCellUtil.createFirstOnRow(key))).isEmpty() ? null : cellHead.last();
            if (lastCellBeforeRow == null) {
                this.current = null;
                return false;
            }
            Cell firstKeyOnPreviousRow = PrivateCellUtil.createFirstOnRow(lastCellBeforeRow);
            this.stopSkippingKVsIfNextRow = true;
            this.stopSkippingKVsRow = firstKeyOnPreviousRow;
            this.seek(firstKeyOnPreviousRow);
            this.stopSkippingKVsIfNextRow = false;
            if (this.peek() == null || this.segment.getComparator().compareRows(this.peek(), firstKeyOnPreviousRow) > 0) {
                keepSeeking = true;
                key = firstKeyOnPreviousRow;
                continue;
            }
            keepSeeking = false;
        } while (keepSeeking);
        return true;
    }

    @Override
    public boolean seekToLastRow() throws IOException {
        Cell higherCell;
        if (this.closed) {
            return false;
        }
        Cell cell = higherCell = this.segment.isEmpty() ? null : this.segment.last();
        if (higherCell == null) {
            return false;
        }
        Cell firstCellOnLastRow = PrivateCellUtil.createFirstOnRow(higherCell);
        if (this.seek(firstCellOnLastRow)) {
            return true;
        }
        return this.seekToPreviousRow(higherCell);
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.getSegment().decScannerCount();
        this.closed = true;
    }

    @Override
    public boolean shouldUseScanner(Scan scan, HStore store, long oldestUnexpiredTS) {
        return this.getSegment().shouldSeek(scan.getColumnFamilyTimeRange().getOrDefault(store.getColumnFamilyDescriptor().getName(), scan.getTimeRange()), oldestUnexpiredTS);
    }

    @Override
    public boolean requestSeek(Cell c, boolean forward, boolean useBloom) throws IOException {
        return NonLazyKeyValueScanner.doRealSeek(this, c, forward);
    }

    @Override
    public boolean realSeekDone() {
        return true;
    }

    @Override
    public void enforceSeek() throws IOException {
        throw new NotImplementedException("enforceSeek cannot be called on a SegmentScanner");
    }

    @Override
    public boolean isFileScanner() {
        return false;
    }

    @Override
    public Path getFilePath() {
        return null;
    }

    @Override
    public Cell getNextIndexedKey() {
        return null;
    }

    @Override
    public void shipped() throws IOException {
    }

    public String toString() {
        String res = "Store segment scanner of type " + this.getClass().getName() + "; ";
        res = res + "Scanner order " + this.getScannerOrder() + "; ";
        res = res + this.getSegment().toString();
        return res;
    }

    private Segment getSegment() {
        return this.segment;
    }

    protected void updateCurrent() {
        Cell next = null;
        try {
            while (this.iter.hasNext()) {
                next = this.iter.next();
                if (next.getSequenceId() <= this.readPoint) {
                    this.current = next;
                    return;
                }
                if (!this.stopSkippingKVsIfNextRow || this.segment.compareRows(next, this.stopSkippingKVsRow) <= 0) continue;
                this.current = null;
                return;
            }
            this.current = null;
        }
        finally {
            if (next != null) {
                this.last = next;
            }
        }
    }

    private Cell getHighest(Cell first, Cell second) {
        if (first == null && second == null) {
            return null;
        }
        if (first != null && second != null) {
            int compare = this.segment.compare(first, second);
            return compare > 0 ? first : second;
        }
        return first != null ? first : second;
    }
}

