/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.regionserver;

import io.hops.hudi.org.apache.hadoop.hbase.Cell;
import io.hops.hudi.org.apache.hadoop.hbase.monitoring.MonitoredTask;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.CellSink;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.FlushLifeCycleTracker;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.HStore;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.InternalScanner;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.MemStoreSnapshot;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.ScanInfo;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.ScanType;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.ScannerContext;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.StoreFileWriter;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.StoreScanner;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.throttle.ThroughputControlUtil;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.throttle.ThroughputController;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
abstract class StoreFlusher {
    protected Configuration conf;
    protected HStore store;

    public StoreFlusher(Configuration conf, HStore store) {
        this.conf = conf;
        this.store = store;
    }

    public abstract List<Path> flushSnapshot(MemStoreSnapshot var1, long var2, MonitoredTask var4, ThroughputController var5, FlushLifeCycleTracker var6) throws IOException;

    protected void finalizeWriter(StoreFileWriter writer, long cacheFlushSeqNum, MonitoredTask status) throws IOException {
        status.setStatus("Flushing " + this.store + ": appending metadata");
        writer.appendMetadata(cacheFlushSeqNum, false);
        status.setStatus("Flushing " + this.store + ": closing flushed file");
        writer.close();
    }

    protected final InternalScanner createScanner(List<KeyValueScanner> snapshotScanners, FlushLifeCycleTracker tracker) throws IOException {
        ScanInfo scanInfo = this.store.getCoprocessorHost() != null ? this.store.getCoprocessorHost().preFlushScannerOpen(this.store, tracker) : this.store.getScanInfo();
        long smallestReadPoint = this.store.getSmallestReadPoint();
        StoreScanner scanner = new StoreScanner(this.store, scanInfo, snapshotScanners, ScanType.COMPACT_RETAIN_DELETES, smallestReadPoint, Long.MIN_VALUE);
        if (this.store.getCoprocessorHost() != null) {
            try {
                return this.store.getCoprocessorHost().preFlush(this.store, scanner, tracker);
            }
            catch (IOException ioe) {
                scanner.close();
                throw ioe;
            }
        }
        return scanner;
    }

    protected void performFlush(InternalScanner scanner, CellSink sink, ThroughputController throughputController) throws IOException {
        boolean control;
        int compactionKVMax = this.conf.getInt("hbase.hstore.compaction.kv.max", 10);
        ScannerContext scannerContext = ScannerContext.newBuilder().setBatchLimit(compactionKVMax).build();
        ArrayList<Cell> kvs = new ArrayList<Cell>();
        String flushName = ThroughputControlUtil.getNameForThrottling(this.store, "flush");
        boolean bl = control = throughputController != null && !this.store.getRegionInfo().getTable().isSystemTable();
        if (control) {
            throughputController.start(flushName);
        }
        try {
            boolean hasMore;
            do {
                hasMore = scanner.next(kvs, scannerContext);
                if (kvs.isEmpty()) continue;
                for (Cell c : kvs) {
                    sink.append(c);
                    if (!control) continue;
                    throughputController.control(flushName, c.getSerializedSize());
                }
                kvs.clear();
            } while (hasMore);
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException("Interrupted while control throughput of flushing " + flushName);
        }
        finally {
            if (control) {
                throughputController.finish(flushName);
            }
        }
    }
}

