/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.replication;

import io.hops.hudi.org.apache.hadoop.hbase.replication.ReplicationEndpoint;
import io.hops.hudi.org.apache.hadoop.hbase.replication.WALEntryFilter;
import io.hops.hudi.org.apache.hadoop.hbase.wal.WAL;
import io.hops.hudi.org.apache.hadoop.hbase.wal.WALEdit;
import io.hops.hudi.org.apache.hadoop.hbase.wal.WALKeyImpl;
import java.util.UUID;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.LimitedPrivate(value={"Replication"})
@InterfaceStability.Evolving
public class ClusterMarkingEntryFilter
implements WALEntryFilter {
    private UUID clusterId;
    private UUID peerClusterId;
    private ReplicationEndpoint replicationEndpoint;

    public ClusterMarkingEntryFilter(UUID clusterId, UUID peerClusterId, ReplicationEndpoint replicationEndpoint) {
        this.clusterId = clusterId;
        this.peerClusterId = peerClusterId;
        this.replicationEndpoint = replicationEndpoint;
    }

    @Override
    public WAL.Entry filter(WAL.Entry entry) {
        if (this.replicationEndpoint.canReplicateToSameCluster() || !entry.getKey().getClusterIds().contains(this.peerClusterId)) {
            WALEdit edit = entry.getEdit();
            WALKeyImpl logKey = entry.getKey();
            if (edit != null && !edit.isEmpty()) {
                logKey.addClusterId(this.clusterId);
                return entry;
            }
        }
        return null;
    }
}

