/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.security.token;

import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import com.google.protobuf.Service;
import io.hops.hudi.org.apache.hadoop.hbase.CoprocessorEnvironment;
import io.hops.hudi.org.apache.hadoop.hbase.coprocessor.CoreCoprocessor;
import io.hops.hudi.org.apache.hadoop.hbase.coprocessor.HasRegionServerServices;
import io.hops.hudi.org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import io.hops.hudi.org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import io.hops.hudi.org.apache.hadoop.hbase.ipc.CoprocessorRpcUtils;
import io.hops.hudi.org.apache.hadoop.hbase.ipc.RpcServer;
import io.hops.hudi.org.apache.hadoop.hbase.ipc.RpcServerInterface;
import io.hops.hudi.org.apache.hadoop.hbase.protobuf.generated.AuthenticationProtos;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.RegionServerServices;
import io.hops.hudi.org.apache.hadoop.hbase.security.AccessDeniedException;
import io.hops.hudi.org.apache.hadoop.hbase.security.User;
import io.hops.hudi.org.apache.hadoop.hbase.security.token.AuthenticationTokenIdentifier;
import io.hops.hudi.org.apache.hadoop.hbase.security.token.AuthenticationTokenSecretManager;
import io.hops.hudi.org.apache.hadoop.hbase.security.token.ClientTokenUtil;
import java.io.IOException;
import java.util.Collections;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CoreCoprocessor
@InterfaceAudience.Private
public class TokenProvider
implements AuthenticationProtos.AuthenticationService.Interface,
RegionCoprocessor {
    private static final Logger LOG = LoggerFactory.getLogger(TokenProvider.class);
    private AuthenticationTokenSecretManager secretManager;

    @Override
    public void start(CoprocessorEnvironment env) {
        RegionCoprocessorEnvironment regionEnv;
        RegionServerServices rss;
        RpcServerInterface server;
        SecretManager<? extends TokenIdentifier> mgr;
        if (env instanceof RegionCoprocessorEnvironment && (mgr = ((RpcServer)(server = (rss = ((HasRegionServerServices)((Object)(regionEnv = (RegionCoprocessorEnvironment)env))).getRegionServerServices()).getRpcServer())).getSecretManager()) instanceof AuthenticationTokenSecretManager) {
            this.secretManager = (AuthenticationTokenSecretManager)mgr;
        }
    }

    @Override
    public void stop(CoprocessorEnvironment env) throws IOException {
    }

    private boolean isAllowedDelegationTokenOp(UserGroupInformation ugi) throws IOException {
        UserGroupInformation.AuthenticationMethod authMethod = ugi.getAuthenticationMethod();
        if (authMethod == UserGroupInformation.AuthenticationMethod.PROXY) {
            authMethod = ugi.getRealUser().getAuthenticationMethod();
        }
        return authMethod == UserGroupInformation.AuthenticationMethod.KERBEROS || authMethod == UserGroupInformation.AuthenticationMethod.KERBEROS_SSL || authMethod == UserGroupInformation.AuthenticationMethod.CERTIFICATE;
    }

    @Override
    public Iterable<Service> getServices() {
        return Collections.singleton(AuthenticationProtos.AuthenticationService.newReflectiveService(this));
    }

    @Override
    public void getAuthenticationToken(RpcController controller, AuthenticationProtos.GetAuthenticationTokenRequest request, RpcCallback<AuthenticationProtos.GetAuthenticationTokenResponse> done) {
        AuthenticationProtos.GetAuthenticationTokenResponse.Builder response = AuthenticationProtos.GetAuthenticationTokenResponse.newBuilder();
        try {
            if (this.secretManager == null) {
                throw new IOException("No secret manager configured for token authentication");
            }
            User currentUser = RpcServer.getRequestUser().orElseThrow(() -> new AccessDeniedException("No authenticated user for request!"));
            UserGroupInformation ugi = currentUser.getUGI();
            if (!this.isAllowedDelegationTokenOp(ugi)) {
                LOG.warn("Token generation denied for user=" + currentUser.getName() + ", authMethod=" + ugi.getAuthenticationMethod());
                throw new AccessDeniedException("Token generation only allowed for Kerberos authenticated clients");
            }
            Token<AuthenticationTokenIdentifier> token = this.secretManager.generateToken(currentUser.getName());
            response.setToken(ClientTokenUtil.toToken(token)).build();
        }
        catch (IOException ioe) {
            CoprocessorRpcUtils.setControllerException(controller, ioe);
        }
        done.run((Object)response.build());
    }

    @Override
    public void whoAmI(RpcController controller, AuthenticationProtos.WhoAmIRequest request, RpcCallback<AuthenticationProtos.WhoAmIResponse> done) {
        AuthenticationProtos.WhoAmIResponse.Builder response = AuthenticationProtos.WhoAmIResponse.newBuilder();
        RpcServer.getRequestUser().ifPresent(requestUser -> {
            response.setUsername(requestUser.getShortName());
            UserGroupInformation.AuthenticationMethod method = requestUser.getUGI().getAuthenticationMethod();
            if (method != null) {
                response.setAuthMethod(method.name());
            }
        });
        done.run((Object)response.build());
    }
}

