/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.trace;

import io.hops.hudi.org.apache.hadoop.hbase.trace.HBaseHTraceConfiguration;
import io.hops.hudi.org.apache.hadoop.hbase.trace.TraceUtil;
import io.hops.hudi.org.apache.htrace.core.SpanReceiver;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class SpanReceiverHost {
    public static final String SPAN_RECEIVERS_CONF_KEY = "hbase.trace.spanreceiver.classes";
    private static final Logger LOG = LoggerFactory.getLogger(SpanReceiverHost.class);
    private Collection<SpanReceiver> receivers = new HashSet<SpanReceiver>();
    private Configuration conf;
    private boolean closed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SpanReceiverHost getInstance(Configuration conf) {
        Object object = SingletonHolder.INSTANCE.lock;
        synchronized (object) {
            if (SingletonHolder.INSTANCE.host != null) {
                return SingletonHolder.INSTANCE.host;
            }
            SpanReceiverHost host2 = new SpanReceiverHost(conf);
            host2.loadSpanReceivers();
            SingletonHolder.INSTANCE.host = host2;
            return SingletonHolder.INSTANCE.host;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Configuration getConfiguration() {
        Object object = SingletonHolder.INSTANCE.lock;
        synchronized (object) {
            if (SingletonHolder.INSTANCE.host == null || SingletonHolder.INSTANCE.host.conf == null) {
                return null;
            }
            return SingletonHolder.INSTANCE.host.conf;
        }
    }

    SpanReceiverHost(Configuration conf) {
        this.conf = conf;
    }

    public void loadSpanReceivers() {
        String[] receiverNames = this.conf.getStrings(SPAN_RECEIVERS_CONF_KEY);
        if (receiverNames == null || receiverNames.length == 0) {
            return;
        }
        SpanReceiver.Builder builder = new SpanReceiver.Builder(new HBaseHTraceConfiguration(this.conf));
        for (String className : receiverNames) {
            SpanReceiver receiver = builder.className(className = className.trim()).build();
            if (receiver == null) continue;
            this.receivers.add(receiver);
            LOG.info("SpanReceiver {} was loaded successfully.", (Object)className);
        }
        for (SpanReceiver rcvr : this.receivers) {
            TraceUtil.addReceiver(rcvr);
        }
    }

    public synchronized void closeReceivers() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        for (SpanReceiver rcvr : this.receivers) {
            try {
                rcvr.close();
            }
            catch (IOException e) {
                LOG.warn("Unable to close SpanReceiver correctly: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private static enum SingletonHolder {
        INSTANCE;

        final transient Object lock = new Object();
        transient SpanReceiverHost host = null;
    }
}

