/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.util;

import io.hops.hudi.org.apache.hadoop.hbase.nio.ByteBuff;
import io.hops.hudi.org.apache.hadoop.hbase.util.ByteBufferAllocator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.BiConsumer;
import org.apache.hadoop.util.StringUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ByteBufferArray {
    private static final Logger LOG = LoggerFactory.getLogger(ByteBufferArray.class);
    public static final int DEFAULT_BUFFER_SIZE = 0x400000;
    private final int bufferSize;
    private final int bufferCount;
    final ByteBuffer[] buffers;
    private static final BiConsumer<ByteBuffer, ByteBuff> WRITER = (dst, src) -> {
        int off = src.position();
        int len = dst.remaining();
        src.get((ByteBuffer)dst, off, len);
        src.position(off + len);
    };
    private static final BiConsumer<ByteBuffer, ByteBuff> READER = (src, dst) -> {
        int off = dst.position();
        int len = src.remaining();
        int srcOff = src.position();
        dst.put(off, ByteBuff.wrap(src), srcOff, len);
        src.position(srcOff + len);
        dst.position(off + len);
    };

    public ByteBufferArray(long capacity, ByteBufferAllocator allocator) throws IOException {
        this(ByteBufferArray.getBufferSize(capacity), ByteBufferArray.getBufferCount(capacity), Runtime.getRuntime().availableProcessors(), capacity, allocator);
    }

    ByteBufferArray(int bufferSize, int bufferCount, int threadCount, long capacity, ByteBufferAllocator alloc) throws IOException {
        this.bufferSize = bufferSize;
        this.bufferCount = bufferCount;
        LOG.info("Allocating buffers total={}, sizePerBuffer={}, count={}", new Object[]{StringUtils.byteDesc((long)capacity), StringUtils.byteDesc((long)bufferSize), bufferCount});
        this.buffers = new ByteBuffer[bufferCount];
        this.createBuffers(threadCount, alloc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createBuffers(int threadCount, ByteBufferAllocator alloc) throws IOException {
        ExecutorService pool = Executors.newFixedThreadPool(threadCount);
        int perThreadCount = this.bufferCount / threadCount;
        int reminder = this.bufferCount % threadCount;
        try {
            ArrayList<Future<ByteBuffer[]>> futures = new ArrayList<Future<ByteBuffer[]>>(threadCount);
            for (int i = 0; i < threadCount; ++i) {
                int chunkSize = perThreadCount + (i == threadCount - 1 ? reminder : 0);
                futures.add(pool.submit(() -> {
                    ByteBuffer[] chunk = new ByteBuffer[chunkSize];
                    for (int k = 0; k < chunkSize; ++k) {
                        chunk[k] = alloc.allocate(this.bufferSize);
                    }
                    return chunk;
                }));
            }
            int bufferIndex = 0;
            try {
                for (Future future : futures) {
                    for (ByteBuffer b : (ByteBuffer[])future.get()) {
                        this.buffers[bufferIndex++] = b;
                    }
                }
                assert (bufferIndex == this.bufferCount);
            }
            catch (Exception e) {
                LOG.error("Buffer creation interrupted", (Throwable)e);
                throw new IOException(e);
            }
        }
        finally {
            pool.shutdownNow();
        }
    }

    static int getBufferSize(long capacity) {
        int bufferSize = 0x400000;
        if ((long)bufferSize > capacity / 16L) {
            bufferSize = (int)ByteBufferArray.roundUp(capacity / 16L, 32768L);
        }
        return bufferSize;
    }

    private static int getBufferCount(long capacity) {
        int bufferSize = ByteBufferArray.getBufferSize(capacity);
        return (int)(ByteBufferArray.roundUp(capacity, bufferSize) / (long)bufferSize);
    }

    private static long roundUp(long n, long to) {
        return (n + to - 1L) / to * to;
    }

    public int read(long offset, ByteBuff dst) {
        return this.internalTransfer(offset, dst, READER);
    }

    public int write(long offset, ByteBuff src) {
        return this.internalTransfer(offset, src, WRITER);
    }

    private int internalTransfer(long offset, ByteBuff b, BiConsumer<ByteBuffer, ByteBuff> transfer) {
        int expectedTransferLen = b.remaining();
        if (expectedTransferLen == 0) {
            return 0;
        }
        BufferIterator it = new BufferIterator(offset, expectedTransferLen);
        while (it.hasNext()) {
            ByteBuffer a = it.next();
            transfer.accept(a, b);
            assert (!a.hasRemaining());
        }
        assert (expectedTransferLen == it.getSum()) : "Expected transfer length (=" + expectedTransferLen + ") don't match the actual transfer length(=" + it.getSum() + ")";
        return expectedTransferLen;
    }

    public ByteBuffer[] asSubByteBuffers(long offset, int len) {
        BufferIterator it = new BufferIterator(offset, len);
        ByteBuffer[] mbb = new ByteBuffer[it.getBufferCount()];
        for (int i = 0; i < mbb.length; ++i) {
            assert (it.hasNext());
            mbb[i] = it.next();
        }
        assert (it.getSum() == len);
        return mbb;
    }

    private class BufferIterator
    implements Iterator<ByteBuffer> {
        private final int len;
        private int startBuffer;
        private int startOffset;
        private int endBuffer;
        private int endOffset;
        private int curIndex;
        private int sum = 0;

        private int index(long pos) {
            return (int)(pos / (long)ByteBufferArray.this.bufferSize);
        }

        private int offset(long pos) {
            return (int)(pos % (long)ByteBufferArray.this.bufferSize);
        }

        public BufferIterator(long offset, int len) {
            assert (len >= 0 && offset >= 0L);
            this.len = len;
            this.startBuffer = this.index(offset);
            this.startOffset = this.offset(offset);
            this.endBuffer = this.index(offset + (long)len);
            this.endOffset = this.offset(offset + (long)len);
            if (this.startBuffer < this.endBuffer && this.endOffset == 0) {
                --this.endBuffer;
                this.endOffset = ByteBufferArray.this.bufferSize;
            }
            assert (this.startBuffer >= 0 && this.startBuffer < ByteBufferArray.this.bufferCount);
            assert (this.endBuffer >= 0 && this.endBuffer < ByteBufferArray.this.bufferCount);
            this.curIndex = this.startBuffer;
        }

        @Override
        public boolean hasNext() {
            return this.curIndex <= this.endBuffer;
        }

        @Override
        public ByteBuffer next() {
            ByteBuffer bb = ByteBufferArray.this.buffers[this.curIndex].duplicate();
            if (this.curIndex == this.startBuffer) {
                bb.position(this.startOffset).limit(Math.min(ByteBufferArray.this.bufferSize, this.startOffset + this.len));
            } else if (this.curIndex == this.endBuffer) {
                bb.position(0).limit(this.endOffset);
            } else {
                bb.position(0).limit(ByteBufferArray.this.bufferSize);
            }
            ++this.curIndex;
            this.sum += bb.remaining();
            return bb.slice();
        }

        int getSum() {
            return this.sum;
        }

        int getBufferCount() {
            return this.endBuffer - this.startBuffer + 1;
        }
    }
}

