/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.Writable;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class Writables {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytes(Writable w) throws IOException {
        if (w == null) {
            throw new IllegalArgumentException("Writable cannot be null");
        }
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        try (DataOutputStream out = new DataOutputStream(byteStream);){
            w.write((DataOutput)out);
            out.close();
            out = null;
            byte[] byArray = byteStream.toByteArray();
            return byArray;
        }
    }

    public static byte[] getBytes(Writable ... ws) throws IOException {
        ArrayList<byte[]> bytes = new ArrayList<byte[]>(ws.length);
        int size = 0;
        for (Writable w : ws) {
            byte[] b = Writables.getBytes(w);
            size += b.length;
            bytes.add(b);
        }
        byte[] result = new byte[size];
        int offset = 0;
        for (byte[] b : bytes) {
            System.arraycopy(b, 0, result, offset, b.length);
            offset += b.length;
        }
        return result;
    }

    public static Writable getWritable(byte[] bytes, Writable w) throws IOException {
        return Writables.getWritable(bytes, 0, bytes.length, w);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Writable getWritable(byte[] bytes, int offset, int length, Writable w) throws IOException {
        if (bytes == null || length <= 0) {
            throw new IllegalArgumentException("Can't build a writable with empty bytes array");
        }
        if (w == null) {
            throw new IllegalArgumentException("Writable cannot be null");
        }
        try (DataInputBuffer in = new DataInputBuffer();){
            in.reset(bytes, offset, length);
            w.readFields((DataInput)in);
            Writable writable = w;
            return writable;
        }
    }

    public static Writable copyWritable(Writable src, Writable tgt) throws IOException {
        return Writables.copyWritable(Writables.getBytes(src), tgt);
    }

    public static Writable copyWritable(byte[] bytes, Writable tgt) throws IOException {
        try (DataInputStream dis = new DataInputStream(new ByteArrayInputStream(bytes));){
            tgt.readFields((DataInput)dis);
        }
        return tgt;
    }
}

