/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.http.message;

import io.hops.hudi.org.apache.http.ProtocolVersion;
import io.hops.hudi.org.apache.http.RequestLine;
import io.hops.hudi.org.apache.http.annotation.Immutable;
import io.hops.hudi.org.apache.http.message.BasicLineFormatter;
import io.hops.hudi.org.apache.http.util.Args;
import java.io.Serializable;

@Immutable
public class BasicRequestLine
implements RequestLine,
Cloneable,
Serializable {
    private static final long serialVersionUID = 2810581718468737193L;
    private final ProtocolVersion protoversion;
    private final String method;
    private final String uri;

    public BasicRequestLine(String method, String uri2, ProtocolVersion version) {
        this.method = Args.notNull(method, "Method");
        this.uri = Args.notNull(uri2, "URI");
        this.protoversion = Args.notNull(version, "Version");
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public ProtocolVersion getProtocolVersion() {
        return this.protoversion;
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    public String toString() {
        return BasicLineFormatter.INSTANCE.formatRequestLine(null, this).toString();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

