/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.jetty.websocket.api;

import io.hops.hudi.org.apache.jetty.websocket.api.MessageTooLargeException;
import io.hops.hudi.org.apache.jetty.websocket.api.WebSocketBehavior;

public class WebSocketPolicy {
    private static final int KB = 1024;
    private int maxTextMessageSize = 65536;
    private int maxTextMessageBufferSize = 32768;
    private int maxBinaryMessageSize = 65536;
    private int maxBinaryMessageBufferSize = 32768;
    private long asyncWriteTimeout = 60000L;
    private long idleTimeout = 300000L;
    private int inputBufferSize = 4096;
    private final WebSocketBehavior behavior;

    public static WebSocketPolicy newClientPolicy() {
        return new WebSocketPolicy(WebSocketBehavior.CLIENT);
    }

    public static WebSocketPolicy newServerPolicy() {
        return new WebSocketPolicy(WebSocketBehavior.SERVER);
    }

    public WebSocketPolicy(WebSocketBehavior behavior) {
        this.behavior = behavior;
    }

    private void assertLessThan(String name, long size, String otherName, long otherSize) {
        if (size > otherSize) {
            throw new IllegalArgumentException(String.format("%s [%d] must be less than %s [%d]", name, size, otherName, otherSize));
        }
    }

    private void assertGreaterThan(String name, long size, long minSize) {
        if (size < minSize) {
            throw new IllegalArgumentException(String.format("%s [%d] must be a greater than or equal to " + minSize, name, size));
        }
    }

    public void assertValidBinaryMessageSize(int requestedSize) {
        if (this.maxBinaryMessageSize > 0 && requestedSize > this.maxBinaryMessageSize) {
            throw new MessageTooLargeException("Binary message size [" + requestedSize + "] exceeds maximum size [" + this.maxBinaryMessageSize + "]");
        }
    }

    public void assertValidTextMessageSize(int requestedSize) {
        if (this.maxTextMessageSize > 0 && requestedSize > this.maxTextMessageSize) {
            throw new MessageTooLargeException("Text message size [" + requestedSize + "] exceeds maximum size [" + this.maxTextMessageSize + "]");
        }
    }

    public WebSocketPolicy clonePolicy() {
        WebSocketPolicy clone = new WebSocketPolicy(this.behavior);
        clone.idleTimeout = this.getIdleTimeout();
        clone.maxTextMessageSize = this.getMaxTextMessageSize();
        clone.maxTextMessageBufferSize = this.getMaxTextMessageBufferSize();
        clone.maxBinaryMessageSize = this.getMaxBinaryMessageSize();
        clone.maxBinaryMessageBufferSize = this.getMaxBinaryMessageBufferSize();
        clone.inputBufferSize = this.getInputBufferSize();
        clone.asyncWriteTimeout = this.getAsyncWriteTimeout();
        return clone;
    }

    @Deprecated
    public WebSocketPolicy clonePolicy(WebSocketBehavior behavior) {
        return this.delegateAs(behavior);
    }

    public WebSocketPolicy delegateAs(WebSocketBehavior behavior) {
        if (behavior == this.behavior) {
            return this;
        }
        return new Delegated(this, behavior);
    }

    @Deprecated
    public long getAsyncWriteTimeout() {
        return this.asyncWriteTimeout;
    }

    public WebSocketBehavior getBehavior() {
        return this.behavior;
    }

    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public int getInputBufferSize() {
        return this.inputBufferSize;
    }

    public int getMaxBinaryMessageBufferSize() {
        return this.maxBinaryMessageBufferSize;
    }

    public int getMaxBinaryMessageSize() {
        return this.maxBinaryMessageSize;
    }

    public int getMaxTextMessageBufferSize() {
        return this.maxTextMessageBufferSize;
    }

    public int getMaxTextMessageSize() {
        return this.maxTextMessageSize;
    }

    public void setAsyncWriteTimeout(long ms) {
        this.assertLessThan("AsyncWriteTimeout", ms, "IdleTimeout", this.idleTimeout);
        this.asyncWriteTimeout = ms;
    }

    public void setIdleTimeout(long ms) {
        this.assertGreaterThan("IdleTimeout", ms, 0L);
        this.idleTimeout = ms;
    }

    public void setInputBufferSize(int size) {
        this.assertGreaterThan("InputBufferSize", size, 1L);
        this.inputBufferSize = size;
    }

    public void setMaxBinaryMessageBufferSize(int size) {
        this.assertGreaterThan("MaxBinaryMessageBufferSize", size, 1L);
        this.maxBinaryMessageBufferSize = size;
    }

    public void setMaxBinaryMessageSize(int size) {
        this.assertGreaterThan("MaxBinaryMessageSize", size, -1L);
        this.maxBinaryMessageSize = size;
    }

    public void setMaxTextMessageBufferSize(int size) {
        this.assertGreaterThan("MaxTextMessageBufferSize", size, 1L);
        this.maxTextMessageBufferSize = size;
    }

    public void setMaxTextMessageSize(int size) {
        this.assertGreaterThan("MaxTextMessageSize", size, -1L);
        this.maxTextMessageSize = size;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append("@").append(Integer.toHexString(this.hashCode()));
        builder.append("[behavior=").append((Object)this.getBehavior());
        builder.append(",maxTextMessageSize=").append(this.getMaxTextMessageSize());
        builder.append(",maxTextMessageBufferSize=").append(this.getMaxTextMessageBufferSize());
        builder.append(",maxBinaryMessageSize=").append(this.getMaxBinaryMessageSize());
        builder.append(",maxBinaryMessageBufferSize=").append(this.getMaxTextMessageBufferSize());
        builder.append(",asyncWriteTimeout=").append(this.getAsyncWriteTimeout());
        builder.append(",idleTimeout=").append(this.getIdleTimeout());
        builder.append(",inputBufferSize=").append(this.getInputBufferSize());
        builder.append("]");
        return builder.toString();
    }

    private class Delegated
    extends WebSocketPolicy {
        private final WebSocketPolicy delegated;

        public Delegated(WebSocketPolicy policy, WebSocketBehavior behavior) {
            super(behavior);
            this.delegated = policy;
        }

        @Override
        public void assertValidBinaryMessageSize(int requestedSize) {
            this.delegated.assertValidBinaryMessageSize(requestedSize);
        }

        @Override
        public void assertValidTextMessageSize(int requestedSize) {
            this.delegated.assertValidTextMessageSize(requestedSize);
        }

        @Override
        public WebSocketPolicy clonePolicy() {
            return this.delegated.clonePolicy();
        }

        @Override
        public WebSocketPolicy clonePolicy(WebSocketBehavior behavior) {
            return this.delegated.clonePolicy(behavior);
        }

        @Override
        public WebSocketPolicy delegateAs(WebSocketBehavior behavior) {
            return this.delegated.delegateAs(behavior);
        }

        @Override
        public long getAsyncWriteTimeout() {
            return this.delegated.getAsyncWriteTimeout();
        }

        @Override
        public long getIdleTimeout() {
            return this.delegated.getIdleTimeout();
        }

        @Override
        public int getInputBufferSize() {
            return this.delegated.getInputBufferSize();
        }

        @Override
        public int getMaxBinaryMessageBufferSize() {
            return this.delegated.getMaxBinaryMessageBufferSize();
        }

        @Override
        public int getMaxBinaryMessageSize() {
            return this.delegated.getMaxBinaryMessageSize();
        }

        @Override
        public int getMaxTextMessageBufferSize() {
            return this.delegated.getMaxTextMessageBufferSize();
        }

        @Override
        public int getMaxTextMessageSize() {
            return this.delegated.getMaxTextMessageSize();
        }

        @Override
        public void setAsyncWriteTimeout(long ms) {
            this.delegated.setAsyncWriteTimeout(ms);
        }

        @Override
        public void setIdleTimeout(long ms) {
            this.delegated.setIdleTimeout(ms);
        }

        @Override
        public void setInputBufferSize(int size) {
            this.delegated.setInputBufferSize(size);
        }

        @Override
        public void setMaxBinaryMessageBufferSize(int size) {
            this.delegated.setMaxBinaryMessageBufferSize(size);
        }

        @Override
        public void setMaxBinaryMessageSize(int size) {
            this.delegated.setMaxBinaryMessageSize(size);
        }

        @Override
        public void setMaxTextMessageBufferSize(int size) {
            this.delegated.setMaxTextMessageBufferSize(size);
        }

        @Override
        public void setMaxTextMessageSize(int size) {
            this.delegated.setMaxTextMessageSize(size);
        }
    }
}

