/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import io.hops.hudi.org.apache.spark.sql.avro.HoodieAvroDeserializer;
import io.hops.hudi.org.apache.spark.sql.avro.HoodieAvroSchemaConverters;
import io.hops.hudi.org.apache.spark.sql.avro.HoodieAvroSerializer;
import java.io.Serializable;
import org.apache.avro.JsonProperties;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.HoodieSparkUtils$;
import org.apache.hudi.avro.AvroSchemaUtils;
import org.apache.hudi.client.utils.SparkRowSerDe;
import org.apache.hudi.internal.schema.HoodieSchemaException;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class AvroConversionUtils$ {
    public static AvroConversionUtils$ MODULE$;

    static {
        new AvroConversionUtils$();
    }

    public Function1<GenericRecord, Option<InternalRow>> createAvroToInternalRowConverter(Schema rootAvroType, StructType rootCatalystType) {
        HoodieAvroDeserializer deserializer = HoodieSparkUtils$.MODULE$.sparkAdapter().createAvroDeserializer(rootAvroType, (DataType)rootCatalystType);
        return (Function1 & Serializable & scala.Serializable)record -> deserializer.deserialize(record).map((Function1 & Serializable & scala.Serializable)x$1 -> (InternalRow)x$1);
    }

    public Function1<InternalRow, GenericRecord> createInternalRowToAvroConverter(StructType rootCatalystType, Schema rootAvroType, boolean nullable) {
        HoodieAvroSerializer serializer = HoodieSparkUtils$.MODULE$.sparkAdapter().createAvroSerializer((DataType)rootCatalystType, rootAvroType, nullable);
        return (Function1 & Serializable & scala.Serializable)row -> (GenericRecord)serializer.serialize(row);
    }

    @Deprecated
    public Function1<GenericRecord, Row> createConverterToRow(Schema sourceAvroSchema, StructType targetSqlType) {
        SparkRowSerDe serde = HoodieSparkUtils$.MODULE$.sparkAdapter().createSparkRowSerDe(targetSqlType);
        Function1<GenericRecord, Option<InternalRow>> converter = this.createAvroToInternalRowConverter(sourceAvroSchema, targetSqlType);
        return (Function1 & Serializable & scala.Serializable)avro -> (Row)((Option)converter.apply(avro)).map((Function1 & Serializable & scala.Serializable)internalRow -> serde.deserializeRow((InternalRow)internalRow)).get();
    }

    @Deprecated
    public Function1<Row, GenericRecord> createConverterToAvro(StructType sourceSqlType, String structName, String recordNamespace) {
        SparkRowSerDe serde = HoodieSparkUtils$.MODULE$.sparkAdapter().createSparkRowSerDe(sourceSqlType);
        Schema avroSchema = this.convertStructTypeToAvroSchema((DataType)sourceSqlType, structName, recordNamespace);
        Schema schema = AvroSchemaUtils.resolveNullableSchema(avroSchema);
        Schema schema2 = avroSchema;
        boolean nullable = schema == null ? schema2 != null : !schema.equals(schema2);
        Function1<InternalRow, GenericRecord> converter = this.createInternalRowToAvroConverter(sourceSqlType, avroSchema, nullable);
        return (Function1 & Serializable & scala.Serializable)row -> (GenericRecord)converter.apply((Object)serde.serializeRow((Row)row));
    }

    public Dataset<Row> createDataFrame(RDD<GenericRecord> rdd, String schemaStr, SparkSession ss) {
        return rdd.isEmpty() ? ss.emptyDataFrame() : ss.createDataFrame(rdd.mapPartitions((Function1 & Serializable & scala.Serializable)records -> {
            Iterator iterator2;
            if (records.isEmpty()) {
                iterator2 = package$.MODULE$.Iterator().empty();
            } else {
                Schema schema = new Schema.Parser().parse(schemaStr);
                StructType dataType = MODULE$.convertAvroSchemaToStructType(schema);
                Function1<GenericRecord, Row> converter = MODULE$.createConverterToRow(schema, dataType);
                iterator2 = records.map((Function1 & Serializable & scala.Serializable)r -> (Row)converter.apply(r));
            }
            return iterator2;
        }, rdd.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Row.class)), this.convertAvroSchemaToStructType(new Schema.Parser().parse(schemaStr)));
    }

    public Schema convertStructTypeToAvroSchema(DataType structType, String qualifiedName) {
        String[] parts = new StringOps(Predef$.MODULE$.augmentString(qualifiedName)).split('.');
        Tuple2 tuple2 = new Tuple2((Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])parts)).init())).mkString("."), new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])parts)).last());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String namespace = (String)tuple2._1();
        String name = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)namespace, (Object)name);
        Tuple2 tuple23 = tuple22;
        String namespace2 = (String)tuple23._1();
        String name2 = (String)tuple23._2();
        return this.convertStructTypeToAvroSchema(structType, name2, namespace2);
    }

    public Schema convertStructTypeToAvroSchema(DataType structType, String structName, String recordNamespace) {
        Schema schema;
        try {
            HoodieAvroSchemaConverters schemaConverters = HoodieSparkUtils$.MODULE$.sparkAdapter().getAvroSchemaConverters();
            Schema avroSchema = schemaConverters.toAvroType(structType, false, structName, recordNamespace);
            schema = this.getAvroSchemaWithDefaults(avroSchema, structType);
        }
        catch (Exception e) {
            throw new HoodieSchemaException(new StringBuilder(46).append("Failed to convert struct type to avro schema: ").append(structType).toString(), e);
        }
        return schema;
    }

    public StructType convertAvroSchemaToStructType(Schema avroSchema) {
        StructType structType;
        try {
            HoodieAvroSchemaConverters schemaConverters = HoodieSparkUtils$.MODULE$.sparkAdapter().getAvroSchemaConverters();
            Tuple2<DataType, Object> tuple2 = schemaConverters.toSqlType(avroSchema);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            DataType dataType = (DataType)tuple2._1();
            StructType structType2 = (StructType)dataType;
            structType = structType2;
        }
        catch (Exception e) {
            throw new HoodieSchemaException(new StringBuilder(46).append("Failed to convert avro schema to struct type: ").append(avroSchema).toString(), e);
        }
        return structType;
    }

    public Schema getAvroSchemaWithDefaults(Schema schema, DataType dataType) {
        Schema schema2;
        Schema.Type type = schema.getType();
        if (Schema.Type.RECORD.equals(type)) {
            StructType structType = (StructType)dataType;
            StructField[] structFields = structType.fields();
            List modifiedFields = ((TraversableOnce)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(schema.getFields()).map((Function1 & Serializable & scala.Serializable)field -> {
                Schema.Field field2;
                int i = structType.fieldIndex(field.name());
                String comment = structFields[i].metadata().contains("comment") ? structFields[i].metadata().getString("comment") : field.doc();
                Schema newSchema = MODULE$.getAvroSchemaWithDefaults(field.schema(), structFields[i].dataType());
                Schema.Type type = field.schema().getType();
                if (Schema.Type.UNION.equals(type)) {
                    Schema.Field field3;
                    java.util.List innerFields = newSchema.getTypes();
                    boolean containsNullSchema = BoxesRunTime.unboxToBoolean((Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(innerFields).foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)false), (Function2 & Serializable & scala.Serializable)(nullFieldEncountered, schema) -> BoxesRunTime.boxToBoolean((boolean)AvroConversionUtils$.$anonfun$getAvroSchemaWithDefaults$2(BoxesRunTime.unboxToBoolean((Object)nullFieldEncountered), schema))));
                    if (containsNullSchema) {
                        Schema restructuredNewSchema = Schema.createUnion((java.util.List)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)new .colon.colon((Object)Schema.create((Schema.Type)Schema.Type.NULL), (List)Nil$.MODULE$).$plus$plus((GenTraversableOnce)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(innerFields).filter((Function1 & Serializable & scala.Serializable)innerSchema -> BoxesRunTime.boxToBoolean((boolean)AvroConversionUtils$.$anonfun$getAvroSchemaWithDefaults$3(innerSchema))), List$.MODULE$.canBuildFrom())));
                        field3 = new Schema.Field(field.name(), restructuredNewSchema, comment, (Object)JsonProperties.NULL_VALUE);
                    } else {
                        field3 = new Schema.Field(field.name(), newSchema, comment, field.defaultVal());
                    }
                    field2 = field3;
                } else {
                    field2 = new Schema.Field(field.name(), newSchema, comment, field.defaultVal());
                }
                return field2;
            }, Buffer$.MODULE$.canBuildFrom())).toList();
            schema2 = Schema.createRecord((String)schema.getName(), (String)schema.getDoc(), (String)schema.getNamespace(), (boolean)schema.isError(), (java.util.List)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)modifiedFields));
        } else {
            schema2 = Schema.Type.UNION.equals(type) ? Schema.createUnion((java.util.List)JavaConversions$.MODULE$.deprecated$u0020bufferAsJavaList((Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(schema.getTypes()).map((Function1 & Serializable & scala.Serializable)innerSchema -> MODULE$.getAvroSchemaWithDefaults((Schema)innerSchema, dataType), Buffer$.MODULE$.canBuildFrom()))) : (Schema.Type.MAP.equals(type) ? Schema.createMap((Schema)this.getAvroSchemaWithDefaults(schema.getValueType(), ((MapType)dataType).valueType())) : (Schema.Type.ARRAY.equals(type) ? Schema.createArray((Schema)this.getAvroSchemaWithDefaults(schema.getElementType(), ((ArrayType)dataType).elementType())) : schema));
        }
        return schema2;
    }

    @Deprecated
    public Tuple2<String, String> getAvroRecordNameAndNamespace(String tableName) {
        String qualifiedName = AvroSchemaUtils.getAvroRecordQualifiedName(tableName);
        String[] nameParts = new StringOps(Predef$.MODULE$.augmentString(qualifiedName)).split('.');
        return new Tuple2(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])nameParts)).last(), (Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])nameParts)).init())).mkString("."));
    }

    public static final /* synthetic */ boolean $anonfun$getAvroSchemaWithDefaults$2(boolean nullFieldEncountered, Schema schema) {
        Schema.Type type = schema.getType();
        Schema.Type type2 = Schema.Type.NULL;
        return nullFieldEncountered | !(type != null ? !type.equals(type2) : type2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getAvroSchemaWithDefaults$3(Schema innerSchema) {
        Schema.Type type = innerSchema.getType();
        Schema.Type type2 = Schema.Type.NULL;
        return type == null ? type2 != null : !type.equals(type2);
    }

    private AvroConversionUtils$() {
        MODULE$ = this;
    }
}

