/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Properties;
import org.apache.hudi.AutoRecordKeyGenerationUtils$;
import org.apache.hudi.DataSourceOptionsHelper$;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.DFSPropertiesConfiguration;
import org.apache.hudi.common.config.HoodieCommonConfig;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.hive.HiveSyncConfigHolder;
import org.apache.hudi.keygen.NonpartitionedKeyGenerator;
import org.apache.hudi.keygen.SimpleKeyGenerator;
import org.apache.hudi.sync.common.HoodieSyncConfig;
import org.apache.hudi.util.SparkKeyGenUtils$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.hudi.command.MergeIntoKeyGenerator;
import org.apache.spark.sql.hudi.command.SqlKeyGenerator;
import org.apache.spark.sql.hudi.command.SqlKeyGenerator$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map$;
import scala.collection.mutable.MapLike;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;

public final class HoodieWriterUtils$ {
    public static HoodieWriterUtils$ MODULE$;
    private final Logger log;
    private final scala.collection.immutable.Map<ConfigProperty<String>, ConfigProperty<? extends Object>> sparkDatasourceConfigsToTableConfigsMap;

    static {
        new HoodieWriterUtils$();
    }

    private Logger log() {
        return this.log;
    }

    public scala.collection.immutable.Map<String, String> parametersWithWriteDefaults(scala.collection.immutable.Map<String, String> parameters) {
        scala.collection.mutable.Map globalProps = (scala.collection.mutable.Map)JavaConverters$.MODULE$.propertiesAsScalaMapConverter((Properties)DFSPropertiesConfiguration.getGlobalProps()).asScala();
        TypedProperties props = TypedProperties.fromMap(JavaConversions$.MODULE$.mapAsJavaMap(parameters));
        HoodieConfig hoodieConfig = new HoodieConfig(props);
        hoodieConfig.setDefaultValue(DataSourceWriteOptions$.MODULE$.OPERATION());
        hoodieConfig.setDefaultValue(DataSourceWriteOptions$.MODULE$.TABLE_TYPE());
        hoodieConfig.setDefaultValue(DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD());
        hoodieConfig.setDefaultValue(DataSourceWriteOptions$.MODULE$.PAYLOAD_CLASS_NAME());
        hoodieConfig.setDefaultValue(DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CLASS_NAME());
        hoodieConfig.setDefaultValue(HoodieMetadataConfig.ENABLE);
        hoodieConfig.setDefaultValue(DataSourceWriteOptions$.MODULE$.COMMIT_METADATA_KEYPREFIX());
        hoodieConfig.setDefaultValue(DataSourceWriteOptions$.MODULE$.INSERT_DROP_DUPS());
        hoodieConfig.setDefaultValue(DataSourceWriteOptions$.MODULE$.STREAMING_RETRY_CNT());
        hoodieConfig.setDefaultValue(DataSourceWriteOptions$.MODULE$.STREAMING_RETRY_INTERVAL_MS());
        hoodieConfig.setDefaultValue(DataSourceWriteOptions$.MODULE$.STREAMING_IGNORE_FAILED_BATCH());
        hoodieConfig.setDefaultValue(DataSourceWriteOptions$.MODULE$.META_SYNC_CLIENT_TOOL_CLASS_NAME());
        hoodieConfig.setDefaultValue(HiveSyncConfigHolder.HIVE_SYNC_ENABLED);
        hoodieConfig.setDefaultValue(HoodieSyncConfig.META_SYNC_ENABLED);
        hoodieConfig.setDefaultValue(HoodieSyncConfig.META_SYNC_DATABASE_NAME);
        hoodieConfig.setDefaultValue(HoodieSyncConfig.META_SYNC_TABLE_NAME);
        hoodieConfig.setDefaultValue(HoodieSyncConfig.META_SYNC_BASE_FILE_FORMAT);
        hoodieConfig.setDefaultValue(HiveSyncConfigHolder.HIVE_USER);
        hoodieConfig.setDefaultValue(HiveSyncConfigHolder.HIVE_PASS);
        hoodieConfig.setDefaultValue(HiveSyncConfigHolder.HIVE_URL);
        hoodieConfig.setDefaultValue(HoodieSyncConfig.META_SYNC_PARTITION_FIELDS);
        hoodieConfig.setDefaultValue(HoodieSyncConfig.META_SYNC_PARTITION_EXTRACTOR_CLASS);
        hoodieConfig.setDefaultValue(DataSourceWriteOptions$.MODULE$.HIVE_STYLE_PARTITIONING());
        hoodieConfig.setDefaultValue(HiveSyncConfigHolder.HIVE_USE_JDBC);
        hoodieConfig.setDefaultValue(HiveSyncConfigHolder.HIVE_CREATE_MANAGED_TABLE);
        hoodieConfig.setDefaultValue(HiveSyncConfigHolder.HIVE_SYNC_AS_DATA_SOURCE_TABLE);
        hoodieConfig.setDefaultValue(DataSourceWriteOptions$.MODULE$.ASYNC_COMPACT_ENABLE());
        hoodieConfig.setDefaultValue(DataSourceWriteOptions$.MODULE$.INLINE_CLUSTERING_ENABLE());
        hoodieConfig.setDefaultValue(DataSourceWriteOptions$.MODULE$.ASYNC_CLUSTERING_ENABLE());
        hoodieConfig.setDefaultValue(DataSourceWriteOptions$.MODULE$.ENABLE_ROW_WRITER());
        hoodieConfig.setDefaultValue(DataSourceWriteOptions$.MODULE$.RECONCILE_SCHEMA());
        hoodieConfig.setDefaultValue(DataSourceWriteOptions$.MODULE$.MAKE_NEW_COLUMNS_NULLABLE());
        hoodieConfig.setDefaultValue(DataSourceWriteOptions$.MODULE$.DROP_PARTITION_COLUMNS());
        hoodieConfig.setDefaultValue(DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CONSISTENT_LOGICAL_TIMESTAMP_ENABLED());
        return ((scala.collection.immutable.MapLike)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)).$plus$plus((GenTraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter((Properties)hoodieConfig.getProps()).asScala()).$plus$plus((GenTraversableOnce)globalProps).$plus$plus(DataSourceOptionsHelper$.MODULE$.translateConfigurations(parameters));
    }

    public boolean canDoPreppedWrites(HoodieConfig hoodieConfig, scala.collection.immutable.Map<String, String> parameters, WriteOperationType operation, Dataset<Row> df) {
        boolean isPrepped;
        block0: {
            block1: {
                isPrepped = false;
                if (!AutoRecordKeyGenerationUtils$.MODULE$.shouldAutoGenerateRecordKeys(parameters) || !((String)parameters.getOrElse((Object)DataSourceWriteOptions$.MODULE$.SPARK_SQL_WRITES_PREPPED_KEY(), (Function0 & Serializable & scala.Serializable)() -> "false")).equals("false") || !((String)parameters.getOrElse((Object)"_hoodie.spark.sql.merge.into.prepped", (Function0 & Serializable & scala.Serializable)() -> "false")).equals("false") || !new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.schema().fieldNames())).contains((Object)HoodieRecord.RECORD_KEY_METADATA_FIELD)) break block0;
                WriteOperationType writeOperationType = operation;
                WriteOperationType writeOperationType2 = WriteOperationType.UPSERT;
                if (writeOperationType != null ? !((Object)((Object)writeOperationType)).equals((Object)writeOperationType2) : writeOperationType2 != null) break block1;
                this.log().warn("Changing operation type to UPSERT PREPPED for pk less table upserts ");
                isPrepped = true;
                break block0;
            }
            WriteOperationType writeOperationType = operation;
            WriteOperationType writeOperationType3 = WriteOperationType.DELETE;
            if (writeOperationType != null ? !((Object)((Object)writeOperationType)).equals((Object)writeOperationType3) : writeOperationType3 != null) break block0;
            this.log().warn("Changing operation type to DELETE PREPPED for pk less table deletes ");
            isPrepped = true;
        }
        return isPrepped;
    }

    public scala.collection.immutable.Map<String, String> getParamsWithAlternatives(scala.collection.immutable.Map<String, String> parameters) {
        scala.collection.mutable.Map globalProps = (scala.collection.mutable.Map)JavaConverters$.MODULE$.propertiesAsScalaMapConverter((Properties)DFSPropertiesConfiguration.getGlobalProps()).asScala();
        TypedProperties props = TypedProperties.fromMap(JavaConversions$.MODULE$.mapAsJavaMap(parameters));
        HoodieConfig hoodieConfig = new HoodieConfig(props);
        return ((scala.collection.immutable.MapLike)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)).$plus$plus((GenTraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter((Properties)hoodieConfig.getProps()).asScala()).$plus$plus((GenTraversableOnce)globalProps).$plus$plus(DataSourceOptionsHelper$.MODULE$.translateConfigurations(parameters));
    }

    public String getPartitionColumns(scala.collection.immutable.Map<String, String> parameters) {
        return SparkKeyGenUtils$.MODULE$.getPartitionColumns(TypedProperties.fromMap(JavaConversions$.MODULE$.mapAsJavaMap(parameters)));
    }

    public HoodieConfig convertMapToHoodieConfig(scala.collection.immutable.Map<String, String> parameters) {
        TypedProperties properties = TypedProperties.fromMap(JavaConversions$.MODULE$.mapAsJavaMap(parameters));
        return new HoodieConfig(properties);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public String getOriginKeyGenerator(scala.collection.immutable.Map<String, String> parameters) {
        void var2_2;
        String string;
        block3: {
            block2: {
                String kg = (String)parameters.getOrElse((Object)DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CLASS_NAME().key(), (Function0 & Serializable & scala.Serializable)() -> null);
                String string2 = SqlKeyGenerator.class.getCanonicalName();
                String string3 = kg;
                if (!(string2 == null ? string3 != null : !string2.equals(string3))) break block2;
                String string4 = MergeIntoKeyGenerator.class.getCanonicalName();
                String string5 = kg;
                if (string4 != null ? !string4.equals(string5) : string5 != null) break block3;
            }
            string = (String)parameters.getOrElse((Object)SqlKeyGenerator$.MODULE$.ORIGINAL_KEYGEN_CLASS_NAME(), (Function0 & Serializable & scala.Serializable)() -> null);
            return string;
        }
        string = var2_2;
        return string;
    }

    public void validateTableConfig(SparkSession spark, scala.collection.immutable.Map<String, String> params, HoodieConfig tableConfig) {
        this.validateTableConfig(spark, params, tableConfig, false);
    }

    /*
     * Unable to fully structure code
     */
    public void validateTableConfig(SparkSession spark, scala.collection.immutable.Map<String, String> params, HoodieConfig tableConfig, boolean isOverWriteMode) {
        block10: {
            block13: {
                block11: {
                    block12: {
                        if (isOverWriteMode) break block10;
                        resolver = spark.sessionState().conf().resolver();
                        diffConfigs = package$.MODULE$.StringBuilder().newBuilder();
                        params.foreach((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$validateTableConfig$1(org.apache.hudi.common.config.HoodieConfig scala.Function2 scala.collection.mutable.StringBuilder scala.Tuple2 ), (Lscala/Tuple2;)Ljava/lang/Object;)((HoodieConfig)tableConfig, (Function2)resolver, (StringBuilder)diffConfigs));
                        if (tableConfig == null) break block11;
                        datasourceRecordKey = (String)params.getOrElse((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key(), (Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$validateTableConfig$2(), ()Lscala/runtime/Null$;)());
                        tableConfigRecordKey = tableConfig.getString(HoodieTableConfig.RECORDKEY_FIELDS);
                        if (datasourceRecordKey == null || tableConfigRecordKey == null) break block12;
                        v0 = datasourceRecordKey;
                        var9_9 = tableConfigRecordKey;
                        if (v0 != null ? v0.equals(var9_9) == false : var9_9 != null) ** GOTO lbl-1000
                    }
                    if (datasourceRecordKey != null && new StringOps(Predef$.MODULE$.augmentString(datasourceRecordKey)).nonEmpty() && tableConfigRecordKey == null) lbl-1000:
                    // 2 sources

                    {
                        v1 = diffConfigs.append(new java.lang.StringBuilder(13).append("RecordKey:\t").append(datasourceRecordKey).append("\t").append(tableConfigRecordKey).append("\n").toString());
                    } else {
                        v1 = BoxedUnit.UNIT;
                    }
                    datasourcePreCombineKey = (String)params.getOrElse((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key(), (Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$validateTableConfig$3(), ()Lscala/runtime/Null$;)());
                    tableConfigPreCombineKey = tableConfig.getString(HoodieTableConfig.PRECOMBINE_FIELD);
                    if (datasourcePreCombineKey == null || tableConfigPreCombineKey == null) ** GOTO lbl-1000
                    v2 = datasourcePreCombineKey;
                    var12_12 = tableConfigPreCombineKey;
                    if (v2 == null ? var12_12 != null : v2.equals(var12_12) == false) {
                        v3 = diffConfigs.append(new java.lang.StringBuilder(17).append("PreCombineKey:\t").append(datasourcePreCombineKey).append("\t").append(tableConfigPreCombineKey).append("\n").toString());
                    } else lbl-1000:
                    // 2 sources

                    {
                        v3 = BoxedUnit.UNIT;
                    }
                    datasourceKeyGen = this.getOriginKeyGenerator(params);
                    tableConfigKeyGen = tableConfig.getString(HoodieTableConfig.KEY_GENERATOR_CLASS_NAME);
                    if (datasourceKeyGen == null || tableConfigKeyGen == null) ** GOTO lbl-1000
                    v4 = datasourceKeyGen;
                    var15_15 = tableConfigKeyGen;
                    if (v4 == null ? var15_15 != null : v4.equals(var15_15) == false) {
                        v5 = diffConfigs.append(new java.lang.StringBuilder(16).append("KeyGenerator:\t").append(datasourceKeyGen).append("\t").append(tableConfigKeyGen).append("\n").toString());
                    } else lbl-1000:
                    // 2 sources

                    {
                        v5 = BoxedUnit.UNIT;
                    }
                    datasourcePartitionFields = (String)params.getOrElse((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key(), (Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$validateTableConfig$4(), ()Lscala/runtime/Null$;)());
                    tableConfigPartitionFields = tableConfig.getString(HoodieTableConfig.PARTITION_FIELDS);
                    if (datasourcePartitionFields == null || tableConfigPartitionFields == null) ** GOTO lbl-1000
                    v6 = datasourcePartitionFields;
                    var18_18 = tableConfigPartitionFields;
                    if (v6 == null ? var18_18 != null : v6.equals(var18_18) == false) {
                        v7 = diffConfigs.append(new java.lang.StringBuilder(17).append("PartitionPath:\t").append(datasourcePartitionFields).append("\t").append(tableConfigPartitionFields).append("\n").toString());
                    } else lbl-1000:
                    // 2 sources

                    {
                        v7 = BoxedUnit.UNIT;
                    }
                    break block13;
                }
                v7 = BoxedUnit.UNIT;
            }
            if (diffConfigs.nonEmpty()) {
                diffConfigs.insert(0, "\nConfig conflict(key\tcurrent value\texisting value):\n");
                throw new HoodieException(diffConfigs.toString().trim());
            }
        }
        if (params.get((Object)DataSourceWriteOptions$.MODULE$.OPERATION().key()).contains((Object)DataSourceWriteOptions$.MODULE$.BOOTSTRAP_OPERATION_OPT_VAL()) && new StringOps(Predef$.MODULE$.augmentString((String)params.getOrElse((Object)HoodieCommonConfig.SCHEMA_EVOLUTION_ENABLE.key(), (Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$validateTableConfig$5(), ()Ljava/lang/String;)()))).toBoolean()) {
            throw new HoodieException(String.format("now schema evolution cannot support bootstrap table, pls set %s to false", new Object[]{HoodieCommonConfig.SCHEMA_EVOLUTION_ENABLE.key()}));
        }
    }

    public void validateKeyGeneratorConfig(String datasourceKeyGen, HoodieConfig tableConfig) {
        Object object;
        StringBuilder diffConfigs = package$.MODULE$.StringBuilder().newBuilder();
        if (tableConfig != null) {
            String tableConfigKeyGen = tableConfig.getString(HoodieTableConfig.KEY_GENERATOR_CLASS_NAME);
            if (tableConfigKeyGen != null && datasourceKeyGen != null) {
                boolean nonPartitionedTableConfig = tableConfigKeyGen.equals(NonpartitionedKeyGenerator.class.getCanonicalName());
                boolean simpleKeyDataSourceConfig = datasourceKeyGen.equals(SimpleKeyGenerator.class.getCanonicalName());
                object = nonPartitionedTableConfig && simpleKeyDataSourceConfig ? diffConfigs.append(new java.lang.StringBuilder(16).append("KeyGenerator:\t").append(datasourceKeyGen).append("\t").append(tableConfigKeyGen).append("\n").toString()) : BoxedUnit.UNIT;
            } else {
                object = BoxedUnit.UNIT;
            }
        } else {
            object = BoxedUnit.UNIT;
        }
        if (diffConfigs.nonEmpty()) {
            diffConfigs.insert(0, "\nConfig conflict(key\tcurrent value\texisting value):\n");
            throw new HoodieException(diffConfigs.toString().trim());
        }
    }

    private String getStringFromTableConfigWithAlternatives(HoodieConfig tableConfig, String key) {
        return tableConfig == null ? null : (DataSourceOptionsHelper$.MODULE$.allAlternatives().contains((Object)key) ? tableConfig.getString((String)DataSourceOptionsHelper$.MODULE$.allAlternatives().apply((Object)key)) : tableConfig.getString(key));
    }

    public scala.collection.immutable.Map<ConfigProperty<String>, ConfigProperty<? extends Object>> sparkDatasourceConfigsToTableConfigsMap() {
        return this.sparkDatasourceConfigsToTableConfigsMap;
    }

    public scala.collection.immutable.Map<String, String> mappingSparkDatasourceConfigsToTableConfigs(scala.collection.immutable.Map<String, String> options) {
        scala.collection.mutable.Map includingTableConfigs = ((MapLike)Map$.MODULE$.apply((Seq)Nil$.MODULE$)).$plus$plus(options);
        this.sparkDatasourceConfigsToTableConfigsMap().foreach((Function1 & Serializable & scala.Serializable)kv -> {
            BoxedUnit boxedUnit;
            if (JavaConversions$.MODULE$.mapAsJavaMap((Map)options).containsKey(((ConfigProperty)kv._1()).key())) {
                includingTableConfigs.update((Object)((ConfigProperty)kv._2()).key(), options.apply((Object)((ConfigProperty)kv._1()).key()));
                boxedUnit = includingTableConfigs.remove((Object)((ConfigProperty)kv._1()).key());
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return boxedUnit;
        });
        return includingTableConfigs.toMap(Predef$.MODULE$.$conforms());
    }

    public static final /* synthetic */ Object $anonfun$validateTableConfig$1(HoodieConfig tableConfig$1, Function2 resolver$1, StringBuilder diffConfigs$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String key = (String)tuple2._1();
        String value = (String)tuple2._2();
        String existingValue = MODULE$.getStringFromTableConfigWithAlternatives(tableConfig$1, key);
        BoxedUnit boxedUnit = existingValue != null && !BoxesRunTime.unboxToBoolean((Object)resolver$1.apply((Object)existingValue, (Object)value)) ? diffConfigs$1.append(new java.lang.StringBuilder(4).append(key).append(":\t").append(value).append("\t").append(tableConfig$1.getString(key)).append("\n").toString()) : BoxedUnit.UNIT;
        return boxedUnit;
    }

    public static final /* synthetic */ Null$ $anonfun$validateTableConfig$2() {
        return null;
    }

    public static final /* synthetic */ Null$ $anonfun$validateTableConfig$3() {
        return null;
    }

    public static final /* synthetic */ Null$ $anonfun$validateTableConfig$4() {
        return null;
    }

    public static final /* synthetic */ String $anonfun$validateTableConfig$5() {
        return "false";
    }

    private HoodieWriterUtils$() {
        MODULE$ = this;
        this.log = LoggerFactory.getLogger(this.getClass());
        this.sparkDatasourceConfigsToTableConfigsMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(DataSourceWriteOptions$.MODULE$.TABLE_NAME()), HoodieTableConfig.NAME), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(DataSourceWriteOptions$.MODULE$.TABLE_TYPE()), HoodieTableConfig.TYPE), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD()), HoodieTableConfig.PRECOMBINE_FIELD), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD()), HoodieTableConfig.PARTITION_FIELDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD()), HoodieTableConfig.RECORDKEY_FIELDS), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(DataSourceWriteOptions$.MODULE$.PAYLOAD_CLASS_NAME()), HoodieTableConfig.PAYLOAD_CLASS_NAME), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(DataSourceWriteOptions$.MODULE$.RECORD_MERGER_STRATEGY()), HoodieTableConfig.RECORD_MERGER_STRATEGY)}));
    }
}

