/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.avro.model;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;
import org.apache.hudi.avro.model.HoodieCompactionOperation;
import org.apache.hudi.avro.model.HoodieCompactionStrategy;

@AvroGenerated
public class HoodieCompactionPlan
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = 4753308669015009652L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"HoodieCompactionPlan\",\"namespace\":\"org.apache.hudi.avro.model\",\"fields\":[{\"name\":\"operations\",\"type\":[\"null\",{\"type\":\"array\",\"items\":{\"type\":\"record\",\"name\":\"HoodieCompactionOperation\",\"fields\":[{\"name\":\"baseInstantTime\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}]},{\"name\":\"deltaFilePaths\",\"type\":[\"null\",{\"type\":\"array\",\"items\":{\"type\":\"string\",\"avro.java.string\":\"String\"}}],\"default\":null},{\"name\":\"dataFilePath\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"default\":null},{\"name\":\"fileId\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}]},{\"name\":\"partitionPath\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"default\":null},{\"name\":\"metrics\",\"type\":[\"null\",{\"type\":\"map\",\"values\":\"double\",\"avro.java.string\":\"String\"}],\"default\":null},{\"name\":\"bootstrapFilePath\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"default\":null}]}}],\"default\":null},{\"name\":\"extraMetadata\",\"type\":[\"null\",{\"type\":\"map\",\"values\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"avro.java.string\":\"String\"}],\"default\":null},{\"name\":\"version\",\"type\":[\"int\",\"null\"],\"default\":1},{\"name\":\"strategy\",\"type\":[\"null\",{\"type\":\"record\",\"name\":\"HoodieCompactionStrategy\",\"fields\":[{\"name\":\"compactorClassName\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The class name that is provided here should extend CompactionExecutionStrategy abstract class, idea is that the plan generator will also provide the execution strategy to use.\",\"default\":null},{\"name\":\"strategyParams\",\"type\":[\"null\",{\"type\":\"map\",\"values\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"avro.java.string\":\"String\"}],\"doc\":\"These parameters play a key role in determining which action type it is i.e. compaction or logcompaction and it will also include configs that determine how compaction needs to be executed.\",\"default\":null},{\"name\":\"version\",\"type\":[\"int\",\"null\"],\"default\":1}]}],\"default\":null},{\"name\":\"preserveHoodieMetadata\",\"type\":[\"boolean\",\"null\"],\"default\":false}]}");
    private static SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<HoodieCompactionPlan> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<HoodieCompactionPlan> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    @Deprecated
    public List<HoodieCompactionOperation> operations;
    @Deprecated
    public Map<String, String> extraMetadata;
    @Deprecated
    public Integer version;
    @Deprecated
    public HoodieCompactionStrategy strategy;
    @Deprecated
    public Boolean preserveHoodieMetadata;
    private static final DatumWriter<HoodieCompactionPlan> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<HoodieCompactionPlan> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageDecoder<HoodieCompactionPlan> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<HoodieCompactionPlan> createDecoder(SchemaStore resolver2) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver2);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static HoodieCompactionPlan fromByteBuffer(ByteBuffer b) throws IOException {
        return (HoodieCompactionPlan)((Object)DECODER.decode(b));
    }

    public HoodieCompactionPlan() {
    }

    public HoodieCompactionPlan(List<HoodieCompactionOperation> operations, Map<String, String> extraMetadata, Integer version, HoodieCompactionStrategy strategy, Boolean preserveHoodieMetadata) {
        this.operations = operations;
        this.extraMetadata = extraMetadata;
        this.version = version;
        this.strategy = strategy;
        this.preserveHoodieMetadata = preserveHoodieMetadata;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.operations;
            }
            case 1: {
                return this.extraMetadata;
            }
            case 2: {
                return this.version;
            }
            case 3: {
                return this.strategy;
            }
            case 4: {
                return this.preserveHoodieMetadata;
            }
        }
        throw new AvroRuntimeException("Bad index");
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.operations = (List)value$;
                break;
            }
            case 1: {
                this.extraMetadata = (Map)value$;
                break;
            }
            case 2: {
                this.version = (Integer)value$;
                break;
            }
            case 3: {
                this.strategy = (HoodieCompactionStrategy)((Object)value$);
                break;
            }
            case 4: {
                this.preserveHoodieMetadata = (Boolean)value$;
                break;
            }
            default: {
                throw new AvroRuntimeException("Bad index");
            }
        }
    }

    public List<HoodieCompactionOperation> getOperations() {
        return this.operations;
    }

    public void setOperations(List<HoodieCompactionOperation> value) {
        this.operations = value;
    }

    public Map<String, String> getExtraMetadata() {
        return this.extraMetadata;
    }

    public void setExtraMetadata(Map<String, String> value) {
        this.extraMetadata = value;
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer value) {
        this.version = value;
    }

    public HoodieCompactionStrategy getStrategy() {
        return this.strategy;
    }

    public void setStrategy(HoodieCompactionStrategy value) {
        this.strategy = value;
    }

    public Boolean getPreserveHoodieMetadata() {
        return this.preserveHoodieMetadata;
    }

    public void setPreserveHoodieMetadata(Boolean value) {
        this.preserveHoodieMetadata = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        return new Builder(other);
    }

    public static Builder newBuilder(HoodieCompactionPlan other) {
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    public static class Builder
    extends SpecificRecordBuilderBase<HoodieCompactionPlan>
    implements RecordBuilder<HoodieCompactionPlan> {
        private List<HoodieCompactionOperation> operations;
        private Map<String, String> extraMetadata;
        private Integer version;
        private HoodieCompactionStrategy strategy;
        private HoodieCompactionStrategy.Builder strategyBuilder;
        private Boolean preserveHoodieMetadata;

        private Builder() {
            super(SCHEMA$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], other.operations)) {
                this.operations = (List)this.data().deepCopy(this.fields()[0].schema(), other.operations);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], other.extraMetadata)) {
                this.extraMetadata = (Map)this.data().deepCopy(this.fields()[1].schema(), other.extraMetadata);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.version)) {
                this.version = (Integer)this.data().deepCopy(this.fields()[2].schema(), (Object)other.version);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)((Object)other.strategy))) {
                this.strategy = (HoodieCompactionStrategy)((Object)this.data().deepCopy(this.fields()[3].schema(), (Object)other.strategy));
                this.fieldSetFlags()[3] = true;
            }
            if (other.hasStrategyBuilder()) {
                this.strategyBuilder = HoodieCompactionStrategy.newBuilder(other.getStrategyBuilder());
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.preserveHoodieMetadata)) {
                this.preserveHoodieMetadata = (Boolean)this.data().deepCopy(this.fields()[4].schema(), (Object)other.preserveHoodieMetadata);
                this.fieldSetFlags()[4] = true;
            }
        }

        private Builder(HoodieCompactionPlan other) {
            super(SCHEMA$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], other.operations)) {
                this.operations = (List)this.data().deepCopy(this.fields()[0].schema(), other.operations);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], other.extraMetadata)) {
                this.extraMetadata = (Map)this.data().deepCopy(this.fields()[1].schema(), other.extraMetadata);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.version)) {
                this.version = (Integer)this.data().deepCopy(this.fields()[2].schema(), (Object)other.version);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)((Object)other.strategy))) {
                this.strategy = (HoodieCompactionStrategy)((Object)this.data().deepCopy(this.fields()[3].schema(), (Object)other.strategy));
                this.fieldSetFlags()[3] = true;
            }
            this.strategyBuilder = null;
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.preserveHoodieMetadata)) {
                this.preserveHoodieMetadata = (Boolean)this.data().deepCopy(this.fields()[4].schema(), (Object)other.preserveHoodieMetadata);
                this.fieldSetFlags()[4] = true;
            }
        }

        public List<HoodieCompactionOperation> getOperations() {
            return this.operations;
        }

        public Builder setOperations(List<HoodieCompactionOperation> value) {
            this.validate(this.fields()[0], value);
            this.operations = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasOperations() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearOperations() {
            this.operations = null;
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public Map<String, String> getExtraMetadata() {
            return this.extraMetadata;
        }

        public Builder setExtraMetadata(Map<String, String> value) {
            this.validate(this.fields()[1], value);
            this.extraMetadata = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasExtraMetadata() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearExtraMetadata() {
            this.extraMetadata = null;
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public Integer getVersion() {
            return this.version;
        }

        public Builder setVersion(Integer value) {
            this.validate(this.fields()[2], value);
            this.version = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasVersion() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearVersion() {
            this.version = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public HoodieCompactionStrategy getStrategy() {
            return this.strategy;
        }

        public Builder setStrategy(HoodieCompactionStrategy value) {
            this.validate(this.fields()[3], (Object)value);
            this.strategyBuilder = null;
            this.strategy = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasStrategy() {
            return this.fieldSetFlags()[3];
        }

        public HoodieCompactionStrategy.Builder getStrategyBuilder() {
            if (this.strategyBuilder == null) {
                if (this.hasStrategy()) {
                    this.setStrategyBuilder(HoodieCompactionStrategy.newBuilder(this.strategy));
                } else {
                    this.setStrategyBuilder(HoodieCompactionStrategy.newBuilder());
                }
            }
            return this.strategyBuilder;
        }

        public Builder setStrategyBuilder(HoodieCompactionStrategy.Builder value) {
            this.clearStrategy();
            this.strategyBuilder = value;
            return this;
        }

        public boolean hasStrategyBuilder() {
            return this.strategyBuilder != null;
        }

        public Builder clearStrategy() {
            this.strategy = null;
            this.strategyBuilder = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public Boolean getPreserveHoodieMetadata() {
            return this.preserveHoodieMetadata;
        }

        public Builder setPreserveHoodieMetadata(Boolean value) {
            this.validate(this.fields()[4], value);
            this.preserveHoodieMetadata = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasPreserveHoodieMetadata() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearPreserveHoodieMetadata() {
            this.preserveHoodieMetadata = null;
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public HoodieCompactionPlan build() {
            try {
                HoodieCompactionPlan record = new HoodieCompactionPlan();
                record.operations = this.fieldSetFlags()[0] ? this.operations : (List)this.defaultValue(this.fields()[0]);
                record.extraMetadata = this.fieldSetFlags()[1] ? this.extraMetadata : (Map)this.defaultValue(this.fields()[1]);
                Integer n = record.version = this.fieldSetFlags()[2] ? this.version : (Integer)this.defaultValue(this.fields()[2]);
                record.strategy = this.strategyBuilder != null ? this.strategyBuilder.build() : (this.fieldSetFlags()[3] ? this.strategy : (HoodieCompactionStrategy)((Object)this.defaultValue(this.fields()[3])));
                record.preserveHoodieMetadata = this.fieldSetFlags()[4] ? this.preserveHoodieMetadata : (Boolean)this.defaultValue(this.fields()[4]);
                return record;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

