/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.callback.client.http;

import io.hops.hudi.org.apache.http.client.config.RequestConfig;
import io.hops.hudi.org.apache.http.client.methods.CloseableHttpResponse;
import io.hops.hudi.org.apache.http.client.methods.HttpPost;
import io.hops.hudi.org.apache.http.entity.ContentType;
import io.hops.hudi.org.apache.http.entity.StringEntity;
import io.hops.hudi.org.apache.http.impl.client.CloseableHttpClient;
import io.hops.hudi.org.apache.http.impl.client.HttpClientBuilder;
import java.io.Closeable;
import java.io.IOException;
import org.apache.hudi.config.HoodieWriteCommitCallbackConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieWriteCommitHttpCallbackClient
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieWriteCommitHttpCallbackClient.class);
    public static final String HEADER_KEY_API_KEY = "HUDI-CALLBACK-KEY";
    private final String apiKey;
    private final String url;
    private final CloseableHttpClient client;
    private HoodieWriteConfig writeConfig;

    public HoodieWriteCommitHttpCallbackClient(HoodieWriteConfig config) {
        this.writeConfig = config;
        this.apiKey = this.getApiKey();
        this.url = this.getUrl();
        this.client = this.getClient();
    }

    public HoodieWriteCommitHttpCallbackClient(String apiKey, String url2, CloseableHttpClient client) {
        this.apiKey = apiKey;
        this.url = url2;
        this.client = client;
    }

    public void send(String callbackMsg) {
        HttpPost request = new HttpPost(this.url);
        request.setHeader(HEADER_KEY_API_KEY, this.apiKey);
        request.setHeader("Content-Type", ContentType.APPLICATION_JSON.toString());
        request.setEntity(new StringEntity(callbackMsg, ContentType.APPLICATION_JSON));
        try (CloseableHttpResponse response = this.client.execute(request);){
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode >= 300) {
                LOG.warn(String.format("Failed to send callback message. Response was %s", response));
            } else {
                LOG.info(String.format("Sent Callback data to %s successfully !", this.url));
            }
        }
        catch (IOException e) {
            LOG.warn("Failed to send callback.", (Throwable)e);
        }
    }

    private String getApiKey() {
        return this.writeConfig.getString(HoodieWriteCommitCallbackConfig.CALLBACK_HTTP_API_KEY_VALUE);
    }

    private String getUrl() {
        return this.writeConfig.getString(HoodieWriteCommitCallbackConfig.CALLBACK_HTTP_URL);
    }

    private CloseableHttpClient getClient() {
        int timeoutSeconds = this.getHttpTimeoutSeconds() * 1000;
        return HttpClientBuilder.create().setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(timeoutSeconds).setConnectionRequestTimeout(timeoutSeconds).setSocketTimeout(timeoutSeconds).build()).build();
    }

    private Integer getHttpTimeoutSeconds() {
        return this.writeConfig.getInt(HoodieWriteCommitCallbackConfig.CALLBACK_HTTP_TIMEOUT_IN_SECONDS);
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }
}

