/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client;

import io.hops.hudi.com.codahale.metrics.Timer;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hudi.callback.HoodieClientInitCallback;
import org.apache.hudi.client.embedded.EmbeddedTimelineServerHelper;
import org.apache.hudi.client.embedded.EmbeddedTimelineService;
import org.apache.hudi.client.heartbeat.HoodieHeartbeatClient;
import org.apache.hudi.client.transaction.TransactionManager;
import org.apache.hudi.client.utils.TransactionUtils;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.versioning.TimelineLayoutVersion;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieCommitException;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.exception.HoodieWriteConflictException;
import org.apache.hudi.metrics.HoodieMetrics;
import org.apache.hudi.table.HoodieTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseHoodieClient
implements Serializable,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(BaseHoodieClient.class);
    protected final transient FileSystem fs;
    protected final transient HoodieEngineContext context;
    protected final transient Configuration hadoopConf;
    protected final transient HoodieMetrics metrics;
    protected final HoodieWriteConfig config;
    protected final String basePath;
    protected final HoodieHeartbeatClient heartbeatClient;
    protected final TransactionManager txnManager;
    private transient Option<EmbeddedTimelineService> timelineServer;
    private final boolean shouldStopTimelineServer;

    protected BaseHoodieClient(HoodieEngineContext context, HoodieWriteConfig clientConfig) {
        this(context, clientConfig, Option.empty());
    }

    protected BaseHoodieClient(HoodieEngineContext context, HoodieWriteConfig clientConfig, Option<EmbeddedTimelineService> timelineServer) {
        this.hadoopConf = context.getHadoopConf().get();
        this.fs = FSUtils.getFs(clientConfig.getBasePath(), this.hadoopConf);
        this.context = context;
        this.basePath = clientConfig.getBasePath();
        this.config = clientConfig;
        this.timelineServer = timelineServer;
        this.shouldStopTimelineServer = !timelineServer.isPresent();
        this.heartbeatClient = new HoodieHeartbeatClient(this.fs, this.basePath, clientConfig.getHoodieClientHeartbeatIntervalInMs(), clientConfig.getHoodieClientHeartbeatTolerableMisses());
        this.metrics = new HoodieMetrics(this.config);
        this.txnManager = new TransactionManager(this.config, this.fs);
        this.startEmbeddedServerView();
        this.initWrapperFSMetrics();
        this.runClientInitCallbacks();
    }

    @Override
    public void close() {
        this.stopEmbeddedServerView(true);
        this.context.setJobStatus("", "");
        this.heartbeatClient.close();
        this.txnManager.close();
    }

    private synchronized void stopEmbeddedServerView(boolean resetViewStorageConfig) {
        if (this.timelineServer.isPresent() && this.shouldStopTimelineServer) {
            LOG.info("Stopping Timeline service !!");
            this.timelineServer.get().stop();
        }
        this.timelineServer = Option.empty();
        if (resetViewStorageConfig) {
            this.config.resetViewStorageConfig();
        }
    }

    private synchronized void startEmbeddedServerView() {
        if (this.config.isEmbeddedTimelineServerEnabled()) {
            if (!this.timelineServer.isPresent()) {
                try {
                    this.timelineServer = EmbeddedTimelineServerHelper.createEmbeddedTimelineService(this.context, this.config);
                }
                catch (IOException e) {
                    LOG.warn("Unable to start timeline service. Proceeding as if embedded server is disabled", (Throwable)e);
                    this.stopEmbeddedServerView(false);
                }
            } else {
                LOG.info("Timeline Server already running. Not restarting the service");
            }
        } else {
            LOG.info("Embedded Timeline Server is disabled. Not starting timeline service");
        }
    }

    private void runClientInitCallbacks() {
        String callbackClassNames = this.config.getClientInitCallbackClassNames();
        if (StringUtils.isNullOrEmpty(callbackClassNames)) {
            return;
        }
        Arrays.stream(callbackClassNames.split(",")).forEach(callbackClass -> {
            Object callback = ReflectionUtils.loadClass(callbackClass);
            if (!(callback instanceof HoodieClientInitCallback)) {
                throw new HoodieException(callbackClass + " is not a subclass of " + HoodieClientInitCallback.class.getName());
            }
            ((HoodieClientInitCallback)callback).call(this);
        });
    }

    public HoodieWriteConfig getConfig() {
        return this.config;
    }

    public HoodieEngineContext getEngineContext() {
        return this.context;
    }

    protected void initWrapperFSMetrics() {
    }

    protected HoodieTableMetaClient createMetaClient(boolean loadActiveTimelineOnLoad) {
        return HoodieTableMetaClient.builder().setConf(this.hadoopConf).setBasePath(this.config.getBasePath()).setLoadActiveTimelineOnLoad(loadActiveTimelineOnLoad).setConsistencyGuardConfig(this.config.getConsistencyGuardConfig()).setLayoutVersion(Option.of(new TimelineLayoutVersion(this.config.getTimelineLayoutVersion()))).setFileSystemRetryConfig(this.config.getFileSystemRetryConfig()).setMetaserverConfig(this.config.getProps()).build();
    }

    public Option<EmbeddedTimelineService> getTimelineServer() {
        return this.timelineServer;
    }

    public HoodieHeartbeatClient getHeartbeatClient() {
        return this.heartbeatClient;
    }

    protected void resolveWriteConflict(HoodieTable table, HoodieCommitMetadata metadata, Set<String> pendingInflightAndRequestedInstants) {
        Timer.Context conflictResolutionTimer = this.metrics.getConflictResolutionCtx();
        try {
            TransactionUtils.resolveWriteConflictIfAny(table, this.txnManager.getCurrentTransactionOwner(), Option.of(metadata), this.config, this.txnManager.getLastCompletedTransactionOwner(), false, pendingInflightAndRequestedInstants);
            this.metrics.emitConflictResolutionSuccessful();
        }
        catch (HoodieWriteConflictException e) {
            this.metrics.emitConflictResolutionFailed();
            throw e;
        }
        finally {
            if (conflictResolutionTimer != null) {
                conflictResolutionTimer.stop();
            }
        }
    }

    protected void finalizeWrite(HoodieTable table, String instantTime, List<HoodieWriteStat> stats) {
        try {
            Timer.Context finalizeCtx = this.metrics.getFinalizeCtx();
            table.finalizeWrite(this.context, instantTime, stats);
            if (finalizeCtx != null) {
                Option<Long> durationInMs = Option.of(this.metrics.getDurationInMs(finalizeCtx.stop()));
                durationInMs.ifPresent(duration -> {
                    LOG.info("Finalize write elapsed time (milliseconds): " + duration);
                    this.metrics.updateFinalizeWriteMetrics((long)duration, stats.size());
                });
            }
        }
        catch (HoodieIOException ioe) {
            throw new HoodieCommitException("Failed to complete commit " + instantTime + " due to finalize errors.", ioe);
        }
    }
}

