/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.commit;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hudi.DataSourceUtils;
import org.apache.hudi.DataSourceWriteOptions;
import org.apache.hudi.HoodieDatasetBulkInsertHelper;
import org.apache.hudi.client.HoodieWriteResult;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.util.CommitUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.data.HoodieJavaRDD;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.execution.bulkinsert.BucketIndexBulkInsertPartitionerWithRows;
import org.apache.hudi.execution.bulkinsert.BulkInsertInternalPartitionerWithRowsFactory;
import org.apache.hudi.execution.bulkinsert.ConsistentBucketIndexBulkInsertPartitionerWithRows;
import org.apache.hudi.execution.bulkinsert.NonSortPartitionerWithRows;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.table.BulkInsertPartitioner;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.HoodieWriteMetadata;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;

public abstract class BaseDatasetBulkInsertCommitActionExecutor
implements Serializable {
    protected final transient HoodieWriteConfig writeConfig;
    protected final transient SparkRDDWriteClient writeClient;
    protected final String instantTime;
    protected HoodieTable table;

    public BaseDatasetBulkInsertCommitActionExecutor(HoodieWriteConfig config, SparkRDDWriteClient writeClient, String instantTime) {
        this.writeConfig = config;
        this.writeClient = writeClient;
        this.instantTime = instantTime;
    }

    protected void preExecute() {
        this.table.validateInsertSchema();
        this.writeClient.startCommitWithTime(this.instantTime, this.getCommitActionType());
        this.writeClient.preWrite(this.instantTime, this.getWriteOperationType(), this.table.getMetaClient());
    }

    protected abstract Option<HoodieData<WriteStatus>> doExecute(Dataset<Row> var1, boolean var2);

    protected void afterExecute(HoodieWriteMetadata<JavaRDD<WriteStatus>> result) {
        this.writeClient.postWrite(result, this.instantTime, this.table);
    }

    private HoodieWriteMetadata<JavaRDD<WriteStatus>> buildHoodieWriteMetadata(Option<HoodieData<WriteStatus>> writeStatuses) {
        return writeStatuses.map(statuses -> {
            HoodieWriteMetadata hoodieWriteMetadata = new HoodieWriteMetadata();
            hoodieWriteMetadata.setWriteStatuses(HoodieJavaRDD.getJavaRDD(statuses));
            hoodieWriteMetadata.setPartitionToReplaceFileIds(this.getPartitionToReplacedFileIds((HoodieData<WriteStatus>)statuses));
            return hoodieWriteMetadata;
        }).orElse(new HoodieWriteMetadata());
    }

    public final HoodieWriteResult execute(Dataset<Row> records, boolean isTablePartitioned) {
        if (this.writeConfig.getBoolean(DataSourceWriteOptions.INSERT_DROP_DUPS()).booleanValue()) {
            throw new HoodieException("Dropping duplicates with bulk_insert in row writer path is not supported yet");
        }
        boolean populateMetaFields = this.writeConfig.getBoolean(HoodieTableConfig.POPULATE_META_FIELDS);
        this.table = this.writeClient.initTable(this.getWriteOperationType(), Option.ofNullable(this.instantTime));
        BulkInsertPartitioner<Dataset<Row>> bulkInsertPartitionerRows = this.getPartitioner(populateMetaFields, isTablePartitioned);
        boolean shouldDropPartitionColumns = this.writeConfig.getBoolean(DataSourceWriteOptions.DROP_PARTITION_COLUMNS());
        Dataset<Row> hoodieDF = HoodieDatasetBulkInsertHelper.prepareForBulkInsert(records, this.writeConfig, bulkInsertPartitionerRows, shouldDropPartitionColumns, this.instantTime);
        this.preExecute();
        HoodieWriteMetadata<JavaRDD<WriteStatus>> result = this.buildHoodieWriteMetadata(this.doExecute(hoodieDF, bulkInsertPartitionerRows.arePartitionRecordsSorted()));
        this.afterExecute(result);
        return new HoodieWriteResult(result.getWriteStatuses(), result.getPartitionToReplaceFileIds());
    }

    public abstract WriteOperationType getWriteOperationType();

    public String getCommitActionType() {
        return CommitUtils.getCommitActionType(this.getWriteOperationType(), this.writeClient.getConfig().getTableType());
    }

    protected BulkInsertPartitioner<Dataset<Row>> getPartitioner(boolean populateMetaFields, boolean isTablePartitioned) {
        if (populateMetaFields) {
            if (this.writeConfig.getIndexType() == HoodieIndex.IndexType.BUCKET) {
                if (this.writeConfig.getBucketIndexEngineType() == HoodieIndex.BucketIndexEngineType.SIMPLE) {
                    return new BucketIndexBulkInsertPartitionerWithRows(this.writeConfig.getBucketIndexHashFieldWithDefault(), this.writeConfig.getBucketIndexNumBuckets());
                }
                return new ConsistentBucketIndexBulkInsertPartitionerWithRows(this.table, true);
            }
            return DataSourceUtils.createUserDefinedBulkInsertPartitionerWithRows(this.writeConfig).orElseGet(() -> BulkInsertInternalPartitionerWithRowsFactory.get(this.writeConfig, isTablePartitioned));
        }
        return new NonSortPartitionerWithRows();
    }

    protected Map<String, List<String>> getPartitionToReplacedFileIds(HoodieData<WriteStatus> writeStatuses) {
        return Collections.emptyMap();
    }
}

