/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.commit;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.commit.DatasetBulkInsertOverwriteCommitActionExecutor;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.data.HoodieJavaPairRDD;

public class DatasetBulkInsertOverwriteTableCommitActionExecutor
extends DatasetBulkInsertOverwriteCommitActionExecutor {
    public DatasetBulkInsertOverwriteTableCommitActionExecutor(HoodieWriteConfig config, SparkRDDWriteClient writeClient, String instantTime) {
        super(config, writeClient, instantTime);
    }

    @Override
    public WriteOperationType getWriteOperationType() {
        return WriteOperationType.INSERT_OVERWRITE_TABLE;
    }

    @Override
    protected Map<String, List<String>> getPartitionToReplacedFileIds(HoodieData<WriteStatus> writeStatuses) {
        HoodieEngineContext context = this.writeClient.getEngineContext();
        List<String> partitionPaths = FSUtils.getAllPartitionPaths(context, this.writeConfig.getMetadataConfig(), this.table.getMetaClient().getBasePathV2().toString());
        if (partitionPaths == null || partitionPaths.isEmpty()) {
            return Collections.emptyMap();
        }
        context.setJobStatus(this.getClass().getSimpleName(), "Getting ExistingFileIds of all partitions");
        return HoodieJavaPairRDD.getJavaPairRDD(context.parallelize(partitionPaths, partitionPaths.size()).mapToPair(partitionPath -> Pair.of(partitionPath, this.getAllExistingFileIds((String)partitionPath)))).collectAsMap();
    }
}

