/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.io.Serializable;
import java.util.Objects;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.hadoop.CachingPath;

public class BaseFile
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient FileStatus fileStatus;
    private final String fullPath;
    protected final String fileName;
    private long fileLen;

    public BaseFile(BaseFile dataFile) {
        this(dataFile.fileStatus, dataFile.fullPath, dataFile.getFileName(), dataFile.getFileLen());
    }

    public BaseFile(FileStatus fileStatus) {
        this(fileStatus, fileStatus.getPath().toString(), fileStatus.getPath().getName(), fileStatus.getLen());
    }

    public BaseFile(String filePath) {
        this(null, filePath, BaseFile.getFileName(filePath), -1L);
    }

    private BaseFile(FileStatus fileStatus, String fullPath, String fileName, long fileLen) {
        this.fileStatus = fileStatus;
        this.fullPath = fullPath;
        this.fileLen = fileLen;
        this.fileName = fileName;
    }

    public String getPath() {
        return this.fullPath;
    }

    public Path getHadoopPath() {
        if (this.fileStatus != null) {
            return this.fileStatus.getPath();
        }
        return new CachingPath(this.fullPath);
    }

    public String getFileName() {
        return this.fileName;
    }

    public FileStatus getFileStatus() {
        return this.fileStatus;
    }

    public long getFileSize() {
        return this.fileLen;
    }

    public void setFileLen(long fileLen) {
        this.fileLen = fileLen;
    }

    public long getFileLen() {
        return this.fileLen;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseFile dataFile = (BaseFile)o;
        return Objects.equals(this.fullPath, dataFile.fullPath);
    }

    public int hashCode() {
        return Objects.hash(this.fullPath);
    }

    public String toString() {
        return "BaseFile{fullPath=" + this.fullPath + ", fileLen=" + this.fileLen + '}';
    }

    private static String getFileName(String fullPath) {
        return new Path(fullPath).getName();
    }
}

