/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.hudi.common.model.ConsistentHashingNode;
import org.apache.hudi.common.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public class HoodieConsistentHashingMetadata
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieConsistentHashingMetadata.class);
    public static final int HASH_VALUE_MASK = Integer.MAX_VALUE;
    public static final String HASHING_METADATA_FILE_SUFFIX = ".hashing_meta";
    public static final String HASHING_METADATA_COMMIT_FILE_SUFFIX = ".commit";
    private final short version;
    private final String partitionPath;
    private final String instant;
    private final int numBuckets;
    private final int seqNo;
    private final List<ConsistentHashingNode> nodes;
    @JsonIgnore
    protected List<ConsistentHashingNode> childrenNodes = new ArrayList<ConsistentHashingNode>();
    @JsonIgnore
    private boolean firstCreated;

    @JsonCreator
    public HoodieConsistentHashingMetadata(@JsonProperty(value="version") short version, @JsonProperty(value="partitionPath") String partitionPath, @JsonProperty(value="instant") String instant, @JsonProperty(value="numBuckets") int numBuckets, @JsonProperty(value="seqNo") int seqNo, @JsonProperty(value="nodes") List<ConsistentHashingNode> nodes) {
        this.version = version;
        this.partitionPath = partitionPath;
        this.instant = instant;
        this.numBuckets = numBuckets;
        this.seqNo = seqNo;
        this.nodes = nodes;
        this.firstCreated = false;
    }

    public HoodieConsistentHashingMetadata(String partitionPath, int numBuckets) {
        this(0, partitionPath, "00000000000000", numBuckets, 0, HoodieConsistentHashingMetadata.constructDefaultHashingNodes(partitionPath, numBuckets));
        this.firstCreated = true;
    }

    private static List<ConsistentHashingNode> constructDefaultHashingNodes(String partitionPath, int numBuckets) {
        long step = (Integer.MAX_VALUE + (long)numBuckets - 1L) / (long)numBuckets;
        long bucketStart = 0L;
        ArrayList<ConsistentHashingNode> nodes = new ArrayList<ConsistentHashingNode>(numBuckets);
        for (int idx = 1; idx < numBuckets + 1; ++idx) {
            long bucketEnd = Math.min(step * (long)idx, Integer.MAX_VALUE);
            String fileId = HoodieConsistentHashingMetadata.generateUUID(partitionPath, bucketStart, bucketEnd);
            nodes.add(new ConsistentHashingNode((int)bucketEnd, fileId));
            bucketStart = bucketEnd;
        }
        return nodes;
    }

    private static String generateUUID(String partitionPath, long bucketStart, long bucketEnd) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(16);
        byteBuffer.putLong(bucketStart);
        byteBuffer.putLong(bucketEnd);
        byte[] longBytes = byteBuffer.array();
        byte[] partitionPathBytes = partitionPath.getBytes(StandardCharsets.UTF_8);
        byte[] combinedBytes = new byte[longBytes.length + partitionPathBytes.length];
        System.arraycopy(longBytes, 0, combinedBytes, 0, longBytes.length);
        System.arraycopy(partitionPathBytes, 0, combinedBytes, longBytes.length, partitionPathBytes.length);
        return UUID.nameUUIDFromBytes(combinedBytes).toString();
    }

    public short getVersion() {
        return this.version;
    }

    public String getPartitionPath() {
        return this.partitionPath;
    }

    public String getInstant() {
        return this.instant;
    }

    public int getNumBuckets() {
        return this.numBuckets;
    }

    public int getSeqNo() {
        return this.seqNo;
    }

    public boolean isFirstCreated() {
        return this.firstCreated;
    }

    public List<ConsistentHashingNode> getNodes() {
        return this.nodes;
    }

    public List<ConsistentHashingNode> getChildrenNodes() {
        return this.childrenNodes;
    }

    public void setChildrenNodes(List<ConsistentHashingNode> childrenNodes) {
        this.childrenNodes = childrenNodes;
    }

    public String getFilename() {
        return this.instant + HASHING_METADATA_FILE_SUFFIX;
    }

    public byte[] toBytes() throws IOException {
        return this.toJsonString().getBytes(StandardCharsets.UTF_8);
    }

    public static HoodieConsistentHashingMetadata fromBytes(byte[] bytes) throws IOException {
        try {
            return HoodieConsistentHashingMetadata.fromJsonString(new String(bytes, StandardCharsets.UTF_8), HoodieConsistentHashingMetadata.class);
        }
        catch (Exception e) {
            throw new IOException("unable to read hashing metadata", e);
        }
    }

    private String toJsonString() throws IOException {
        return JsonUtils.getObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)this);
    }

    protected static <T> T fromJsonString(String jsonStr, Class<T> clazz) throws Exception {
        if (jsonStr == null || jsonStr.isEmpty()) {
            return clazz.newInstance();
        }
        return (T)JsonUtils.getObjectMapper().readValue(jsonStr, clazz);
    }

    public static String getTimestampFromFile(String filename) {
        return filename.split("\\.")[0];
    }
}

