/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoSerializable;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.Serializable;
import javax.annotation.Nullable;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.VisibleForTesting;

public class HoodieRecordDelegate
implements Serializable,
KryoSerializable {
    private HoodieKey hoodieKey;
    private Option<HoodieRecordLocation> currentLocation;
    private Option<HoodieRecordLocation> newLocation;

    private HoodieRecordDelegate(HoodieKey hoodieKey, @Nullable HoodieRecordLocation currentLocation, @Nullable HoodieRecordLocation newLocation) {
        this.hoodieKey = hoodieKey;
        this.currentLocation = Option.ofNullable(currentLocation);
        this.newLocation = Option.ofNullable(newLocation);
    }

    public static HoodieRecordDelegate create(String recordKey, String partitionPath) {
        return new HoodieRecordDelegate(new HoodieKey(recordKey, partitionPath), null, null);
    }

    public static HoodieRecordDelegate create(String recordKey, String partitionPath, HoodieRecordLocation currentLocation) {
        return new HoodieRecordDelegate(new HoodieKey(recordKey, partitionPath), currentLocation, null);
    }

    public static HoodieRecordDelegate create(String recordKey, String partitionPath, HoodieRecordLocation currentLocation, HoodieRecordLocation newLocation) {
        return new HoodieRecordDelegate(new HoodieKey(recordKey, partitionPath), currentLocation, newLocation);
    }

    public static HoodieRecordDelegate create(HoodieKey key) {
        return new HoodieRecordDelegate(key, null, null);
    }

    public static HoodieRecordDelegate create(HoodieKey key, HoodieRecordLocation currentLocation) {
        return new HoodieRecordDelegate(key, currentLocation, null);
    }

    public static HoodieRecordDelegate create(HoodieKey key, HoodieRecordLocation currentLocation, HoodieRecordLocation newLocation) {
        return new HoodieRecordDelegate(key, currentLocation, newLocation);
    }

    public static HoodieRecordDelegate fromHoodieRecord(HoodieRecord record) {
        return new HoodieRecordDelegate(record.getKey(), record.getCurrentLocation(), record.getNewLocation());
    }

    public static HoodieRecordDelegate fromHoodieRecord(HoodieRecord record, @Nullable HoodieRecordLocation newLocationOverride) {
        return new HoodieRecordDelegate(record.getKey(), record.getCurrentLocation(), newLocationOverride);
    }

    public String getRecordKey() {
        return this.hoodieKey.getRecordKey();
    }

    public String getPartitionPath() {
        return this.hoodieKey.getPartitionPath();
    }

    public HoodieKey getHoodieKey() {
        return this.hoodieKey;
    }

    public Option<HoodieRecordLocation> getCurrentLocation() {
        return this.currentLocation;
    }

    public Option<HoodieRecordLocation> getNewLocation() {
        return this.newLocation;
    }

    public String toString() {
        return "HoodieRecordDelegate{hoodieKey=" + this.hoodieKey + ", currentLocation=" + this.currentLocation + ", newLocation=" + this.newLocation + '}';
    }

    @VisibleForTesting
    public final void write(Kryo kryo, Output output) {
        kryo.writeObjectOrNull(output, (Object)this.hoodieKey, HoodieKey.class);
        kryo.writeClassAndObject(output, this.currentLocation.isPresent() ? this.currentLocation.get() : null);
        kryo.writeClassAndObject(output, this.newLocation.isPresent() ? this.newLocation.get() : null);
    }

    @VisibleForTesting
    public final void read(Kryo kryo, Input input) {
        this.hoodieKey = (HoodieKey)kryo.readObjectOrNull(input, HoodieKey.class);
        this.currentLocation = Option.ofNullable((HoodieRecordLocation)kryo.readClassAndObject(input));
        this.newLocation = Option.ofNullable((HoodieRecordLocation)kryo.readClassAndObject(input));
    }
}

