/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.log.block;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.config.HoodieStorageConfig;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.fs.inline.InLineFSUtils;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.log.block.HoodieDataBlock;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.io.storage.HoodieFileReaderFactory;
import org.apache.hudi.io.storage.HoodieFileWriter;
import org.apache.hudi.io.storage.HoodieFileWriterFactory;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;

public class HoodieParquetDataBlock
extends HoodieDataBlock {
    private final Option<CompressionCodecName> compressionCodecName;
    private final Option<Double> expectedCompressionRatio;
    private final Option<Boolean> useDictionaryEncoding;

    public HoodieParquetDataBlock(FSDataInputStream inputStream, Option<byte[]> content, boolean readBlockLazily, HoodieLogBlock.HoodieLogBlockContentLocation logBlockContentLocation, Option<Schema> readerSchema, Map<HoodieLogBlock.HeaderMetadataType, String> header, Map<HoodieLogBlock.HeaderMetadataType, String> footer, String keyField) {
        super(content, inputStream, readBlockLazily, Option.of(logBlockContentLocation), readerSchema, header, footer, keyField, false);
        this.compressionCodecName = Option.empty();
        this.expectedCompressionRatio = Option.empty();
        this.useDictionaryEncoding = Option.empty();
    }

    public HoodieParquetDataBlock(List<HoodieRecord> records, Map<HoodieLogBlock.HeaderMetadataType, String> header, String keyField, CompressionCodecName compressionCodecName, double expectedCompressionRatio, boolean useDictionaryEncoding) {
        super(records, header, new HashMap<HoodieLogBlock.HeaderMetadataType, String>(), keyField);
        this.compressionCodecName = Option.of(compressionCodecName);
        this.expectedCompressionRatio = Option.of(expectedCompressionRatio);
        this.useDictionaryEncoding = Option.of(useDictionaryEncoding);
    }

    @Override
    public HoodieLogBlock.HoodieLogBlockType getBlockType() {
        return HoodieLogBlock.HoodieLogBlockType.PARQUET_DATA_BLOCK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected byte[] serializeRecords(List<HoodieRecord> records) throws IOException {
        if (records.size() == 0) {
            return new byte[0];
        }
        Schema writerSchema = new Schema.Parser().parse(super.getLogBlockHeader().get((Object)HoodieLogBlock.HeaderMetadataType.SCHEMA));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (FSDataOutputStream outputStream = new FSDataOutputStream((OutputStream)baos, null);){
            HoodieFileWriter parquetWriter = null;
            HoodieConfig config = new HoodieConfig();
            config.setValue(HoodieStorageConfig.PARQUET_COMPRESSION_CODEC_NAME.key(), this.compressionCodecName.get().name());
            config.setValue(HoodieStorageConfig.PARQUET_BLOCK_SIZE.key(), String.valueOf(0x8000000));
            config.setValue(HoodieStorageConfig.PARQUET_PAGE_SIZE.key(), String.valueOf(0x100000));
            config.setValue(HoodieStorageConfig.PARQUET_MAX_FILE_SIZE.key(), String.valueOf(0x40000000));
            config.setValue(HoodieStorageConfig.PARQUET_COMPRESSION_RATIO_FRACTION.key(), String.valueOf(this.expectedCompressionRatio.get()));
            config.setValue(HoodieStorageConfig.PARQUET_DICTIONARY_ENABLED, String.valueOf(this.useDictionaryEncoding.get()));
            HoodieRecord.HoodieRecordType recordType = records.iterator().next().getRecordType();
            try {
                parquetWriter = HoodieFileWriterFactory.getFileWriter(HoodieFileFormat.PARQUET, outputStream, new Configuration(), config, writerSchema, recordType);
                for (HoodieRecord record : records) {
                    String recordKey = this.getRecordKey(record).orElse(null);
                    parquetWriter.write(recordKey, record, writerSchema);
                }
                outputStream.flush();
            }
            finally {
                if (parquetWriter != null) {
                    parquetWriter.close();
                }
            }
        }
        return baos.toByteArray();
    }

    @Override
    protected <T> ClosableIterator<HoodieRecord<T>> readRecordsFromBlockPayload(HoodieRecord.HoodieRecordType type) throws IOException {
        HoodieLogBlock.HoodieLogBlockContentLocation blockContentLoc = this.getBlockContentLocation().get();
        Configuration inlineConf = FSUtils.buildInlineConf(blockContentLoc.getHadoopConf());
        Path inlineLogFilePath = InLineFSUtils.getInlineFilePath(blockContentLoc.getLogFile().getPath(), blockContentLoc.getLogFile().getPath().toUri().getScheme(), blockContentLoc.getContentPositionInLogFile(), blockContentLoc.getBlockSize());
        Schema writerSchema = new Schema.Parser().parse(this.getLogBlockHeader().get((Object)HoodieLogBlock.HeaderMetadataType.SCHEMA));
        ClosableIterator iterator2 = HoodieFileReaderFactory.getReaderFactory(type).getFileReader(inlineConf, inlineLogFilePath, HoodieFileFormat.PARQUET).getRecordIterator(writerSchema, this.readerSchema);
        return iterator2;
    }

    @Override
    protected <T> ClosableIterator<HoodieRecord<T>> deserializeRecords(byte[] content, HoodieRecord.HoodieRecordType type) throws IOException {
        throw new UnsupportedOperationException("Should not be invoked");
    }
}

