/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index.bucket;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.ConsistentHashingNode;
import org.apache.hudi.common.model.HoodieConsistentHashingMetadata;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieIndexException;
import org.apache.hudi.index.bucket.BucketIndexLocationMapper;
import org.apache.hudi.index.bucket.ConsistentBucketIdentifier;
import org.apache.hudi.index.bucket.ConsistentBucketIndexUtils;
import org.apache.hudi.index.bucket.HoodieBucketIndex;
import org.apache.hudi.table.HoodieTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieConsistentBucketIndex
extends HoodieBucketIndex {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieConsistentBucketIndex.class);

    public HoodieConsistentBucketIndex(HoodieWriteConfig config) {
        super(config);
    }

    @Override
    public HoodieData<WriteStatus> updateLocation(HoodieData<WriteStatus> writeStatuses, HoodieEngineContext context, HoodieTable hoodieTable) throws HoodieIndexException {
        throw new HoodieIndexException("Consistent hashing index does not support update location without the instant parameter");
    }

    @Override
    public boolean rollbackCommit(String instantTime) {
        return true;
    }

    @Override
    protected BucketIndexLocationMapper getLocationMapper(HoodieTable table, List<String> partitionPath) {
        return new ConsistentBucketIndexLocationMapper(table, partitionPath);
    }

    public class ConsistentBucketIndexLocationMapper
    implements BucketIndexLocationMapper {
        private final Map<String, ConsistentBucketIdentifier> partitionToIdentifier;

        public ConsistentBucketIndexLocationMapper(HoodieTable table, List<String> partitions) {
            this.partitionToIdentifier = partitions.stream().collect(Collectors.toMap(p -> p, p -> {
                HoodieConsistentHashingMetadata metadata = ConsistentBucketIndexUtils.loadOrCreateMetadata(table, p, HoodieConsistentBucketIndex.this.getNumBuckets());
                return new ConsistentBucketIdentifier(metadata);
            }));
        }

        @Override
        public Option<HoodieRecordLocation> getRecordLocation(HoodieKey key) {
            String partitionPath = key.getPartitionPath();
            ConsistentHashingNode node = this.partitionToIdentifier.get(partitionPath).getBucket(key, HoodieConsistentBucketIndex.this.indexKeyFields);
            if (!StringUtils.isNullOrEmpty(node.getFileIdPrefix())) {
                return Option.of(new HoodieRecordLocation(null, FSUtils.createNewFileId(node.getFileIdPrefix(), 0)));
            }
            LOG.error("Consistent hashing node has no file group, partition: {}, meta: {}, record_key: {}", new Object[]{partitionPath, this.partitionToIdentifier.get(partitionPath).getMetadata().getFilename(), key.toString()});
            throw new HoodieIndexException("Failed to getBucket as hashing node has no file group");
        }
    }
}

