/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage;

import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.config.HoodieStorageConfig;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.io.storage.HoodieFileWriter;
import org.apache.hudi.io.storage.HoodieFileWriterFactory;
import org.apache.hudi.io.storage.HoodieSparkParquetStreamWriter;
import org.apache.hudi.io.storage.HoodieSparkParquetWriter;
import org.apache.hudi.io.storage.row.HoodieRowParquetConfig;
import org.apache.hudi.io.storage.row.HoodieRowParquetWriteSupport;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.spark.sql.HoodieInternalRowUtils;

public class HoodieSparkFileWriterFactory
extends HoodieFileWriterFactory {
    @Override
    protected HoodieFileWriter newParquetFileWriter(String instantTime, Path path, Configuration conf, HoodieConfig config, Schema schema, TaskContextSupplier taskContextSupplier) throws IOException {
        boolean populateMetaFields = config.getBooleanOrDefault(HoodieTableConfig.POPULATE_META_FIELDS);
        boolean enableBloomFilter = populateMetaFields;
        Option<BloomFilter> filter = enableBloomFilter ? Option.of(this.createBloomFilter(config)) : Option.empty();
        String compressionCodecName = config.getStringOrDefault(HoodieStorageConfig.PARQUET_COMPRESSION_CODEC_NAME);
        if (compressionCodecName.isEmpty()) {
            compressionCodecName = null;
        }
        HoodieRowParquetWriteSupport writeSupport = new HoodieRowParquetWriteSupport(conf, HoodieInternalRowUtils.getCachedSchema(schema), filter, HoodieStorageConfig.newBuilder().fromProperties(config.getProps()).build());
        HoodieRowParquetConfig parquetConfig = new HoodieRowParquetConfig(writeSupport, CompressionCodecName.fromConf((String)compressionCodecName), (int)config.getIntOrDefault(HoodieStorageConfig.PARQUET_BLOCK_SIZE), (int)config.getIntOrDefault(HoodieStorageConfig.PARQUET_PAGE_SIZE), (long)config.getLongOrDefault(HoodieStorageConfig.PARQUET_MAX_FILE_SIZE), conf, (double)config.getDoubleOrDefault(HoodieStorageConfig.PARQUET_COMPRESSION_RATIO_FRACTION), config.getBooleanOrDefault(HoodieStorageConfig.PARQUET_DICTIONARY_ENABLED));
        parquetConfig.getHadoopConf().addResource(writeSupport.getHadoopConf());
        return new HoodieSparkParquetWriter(path, parquetConfig, instantTime, taskContextSupplier, populateMetaFields);
    }

    @Override
    protected HoodieFileWriter newParquetFileWriter(FSDataOutputStream outputStream, Configuration conf, HoodieConfig config, Schema schema) throws IOException {
        boolean enableBloomFilter = false;
        Option<BloomFilter> filter = enableBloomFilter ? Option.of(this.createBloomFilter(config)) : Option.empty();
        HoodieRowParquetWriteSupport writeSupport = new HoodieRowParquetWriteSupport(conf, HoodieInternalRowUtils.getCachedSchema(schema), filter, HoodieStorageConfig.newBuilder().fromProperties(config.getProps()).build());
        String compressionCodecName = config.getStringOrDefault(HoodieStorageConfig.PARQUET_COMPRESSION_CODEC_NAME);
        if (compressionCodecName.isEmpty()) {
            compressionCodecName = null;
        }
        HoodieRowParquetConfig parquetConfig = new HoodieRowParquetConfig(writeSupport, CompressionCodecName.fromConf((String)compressionCodecName), (int)config.getInt(HoodieStorageConfig.PARQUET_BLOCK_SIZE), (int)config.getInt(HoodieStorageConfig.PARQUET_PAGE_SIZE), (long)config.getLong(HoodieStorageConfig.PARQUET_MAX_FILE_SIZE), writeSupport.getHadoopConf(), (double)config.getDouble(HoodieStorageConfig.PARQUET_COMPRESSION_RATIO_FRACTION), config.getBooleanOrDefault(HoodieStorageConfig.PARQUET_DICTIONARY_ENABLED));
        parquetConfig.getHadoopConf().addResource(writeSupport.getHadoopConf());
        return new HoodieSparkParquetStreamWriter(outputStream, parquetConfig);
    }

    @Override
    protected HoodieFileWriter newHFileFileWriter(String instantTime, Path path, Configuration conf, HoodieConfig config, Schema schema, TaskContextSupplier taskContextSupplier) throws IOException {
        throw new HoodieIOException("Not support write to HFile");
    }

    @Override
    protected HoodieFileWriter newOrcFileWriter(String instantTime, Path path, Configuration conf, HoodieConfig config, Schema schema, TaskContextSupplier taskContextSupplier) throws IOException {
        throw new HoodieIOException("Not support write to Orc file");
    }
}

