/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.keygen;

import java.util.List;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.keygen.BuiltinKeyGenerator;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;

public class AutoRecordGenWrapperKeyGenerator
extends BuiltinKeyGenerator {
    private final BuiltinKeyGenerator builtinKeyGenerator;
    private final int partitionId;
    private final String instantTime;
    private int rowId;

    public AutoRecordGenWrapperKeyGenerator(TypedProperties config, BuiltinKeyGenerator builtinKeyGenerator) {
        super(config);
        this.builtinKeyGenerator = builtinKeyGenerator;
        this.rowId = 0;
        this.partitionId = config.getInteger("_hoodie.record.key.gen.partition.id");
        this.instantTime = config.getString("_hoodie.record.key.gen.instant.time");
    }

    @Override
    public String getRecordKey(GenericRecord record) {
        return HoodieRecord.generateSequenceId(this.instantTime, this.partitionId, this.rowId++);
    }

    @Override
    public String getPartitionPath(GenericRecord record) {
        return this.builtinKeyGenerator.getPartitionPath(record);
    }

    @Override
    public String getRecordKey(Row row) {
        return HoodieRecord.generateSequenceId(this.instantTime, this.partitionId, this.rowId++);
    }

    @Override
    public UTF8String getRecordKey(InternalRow internalRow, StructType schema) {
        return UTF8String.fromString((String)HoodieRecord.generateSequenceId(this.instantTime, this.partitionId, this.rowId++));
    }

    @Override
    public String getPartitionPath(Row row) {
        return this.builtinKeyGenerator.getPartitionPath(row);
    }

    @Override
    public UTF8String getPartitionPath(InternalRow internalRow, StructType schema) {
        return this.builtinKeyGenerator.getPartitionPath(internalRow, schema);
    }

    @Override
    public List<String> getRecordKeyFieldNames() {
        return this.builtinKeyGenerator.getRecordKeyFieldNames();
    }

    @Override
    public List<String> getPartitionPathFields() {
        return this.builtinKeyGenerator.getPartitionPathFields();
    }

    @Override
    public boolean isConsistentLogicalTimestampEnabled() {
        return this.builtinKeyGenerator.isConsistentLogicalTimestampEnabled();
    }
}

