/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metadata;

import java.util.Properties;
import org.apache.hudi.avro.model.HoodieMetadataRecord;
import org.apache.hudi.client.FailOnFirstErrorWriteStatus;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.config.HoodieStorageConfig;
import org.apache.hudi.common.fs.ConsistencyGuardConfig;
import org.apache.hudi.common.model.HoodieCleaningPolicy;
import org.apache.hudi.common.model.HoodieFailedWritesCleaningPolicy;
import org.apache.hudi.common.model.WriteConcurrencyMode;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.marker.MarkerType;
import org.apache.hudi.common.table.timeline.versioning.TimelineLayoutVersion;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.config.HoodieArchivalConfig;
import org.apache.hudi.config.HoodieCleanConfig;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.config.metrics.HoodieMetricsConfig;
import org.apache.hudi.config.metrics.HoodieMetricsGraphiteConfig;
import org.apache.hudi.config.metrics.HoodieMetricsJmxConfig;
import org.apache.hudi.config.metrics.HoodieMetricsPrometheusConfig;
import org.apache.hudi.exception.HoodieMetadataException;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.metadata.HoodieTableMetadataKeyGenerator;
import org.apache.hudi.table.action.compact.strategy.UnBoundedCompactionStrategy;

public class HoodieMetadataWriteUtils {
    public static final String RECORD_KEY_FIELD_NAME = "key";
    private static final int MDT_DEFAULT_PARALLELISM = 512;
    private static final long MDT_MAX_HFILE_SIZE_BYTES = 0x280000000L;

    public static HoodieWriteConfig createMetadataWriteConfig(HoodieWriteConfig writeConfig, HoodieFailedWritesCleaningPolicy failedWritesCleaningPolicy) {
        HoodieWriteConfig metadataWriteConfig;
        String tableName = writeConfig.getTableName() + "_metadata";
        long maxLogFileSizeBytes = writeConfig.getMetadataConfig().getMaxLogFileSize();
        HoodieWriteConfig.Builder builder = HoodieWriteConfig.newBuilder().withEngineType(writeConfig.getEngineType()).withTimelineLayoutVersion(TimelineLayoutVersion.CURR_VERSION).withConsistencyGuardConfig(ConsistencyGuardConfig.newBuilder().withConsistencyCheckEnabled(writeConfig.getConsistencyGuardConfig().isConsistencyCheckEnabled()).withInitialConsistencyCheckIntervalMs(writeConfig.getConsistencyGuardConfig().getInitialConsistencyCheckIntervalMs()).withMaxConsistencyCheckIntervalMs(writeConfig.getConsistencyGuardConfig().getMaxConsistencyCheckIntervalMs()).withMaxConsistencyChecks(writeConfig.getConsistencyGuardConfig().getMaxConsistencyChecks()).build()).withWriteConcurrencyMode(WriteConcurrencyMode.SINGLE_WRITER).withMetadataConfig(HoodieMetadataConfig.newBuilder().enable(false).withFileListingParallelism(writeConfig.getFileListingParallelism()).build()).withAutoCommit(true).withAvroSchemaValidate(false).withEmbeddedTimelineServerEnabled(false).withMarkersType(MarkerType.DIRECT.name()).withRollbackUsingMarkers(false).withPath(HoodieTableMetadata.getMetadataTableBasePath(writeConfig.getBasePath())).withSchema(HoodieMetadataRecord.getClassSchema().toString()).forTable(tableName).withCleanConfig(HoodieCleanConfig.newBuilder().withAsyncClean(false).withAutoClean(false).withCleanerParallelism(512).withCleanerPolicy(HoodieCleaningPolicy.KEEP_LATEST_COMMITS).withFailedWritesCleaningPolicy(failedWritesCleaningPolicy).retainCommits(20).build()).withArchivalConfig(HoodieArchivalConfig.newBuilder().archiveCommitsWith(writeConfig.getMinCommitsToKeep() + 1, writeConfig.getMaxCommitsToKeep() + 1).withAutoArchive(false).build()).withCompactionConfig(HoodieCompactionConfig.newBuilder().withInlineCompaction(false).withMaxNumDeltaCommitsBeforeCompaction(writeConfig.getMetadataCompactDeltaCommitMax()).withEnableOptimizedLogBlocksScan(String.valueOf(writeConfig.enableOptimizedLogBlocksScan())).withCompactionStrategy(new UnBoundedCompactionStrategy()).withLogCompactionEnabled(writeConfig.isLogCompactionEnabledOnMetadata()).withLogCompactionBlocksThreshold(writeConfig.getMetadataLogCompactBlocksThreshold()).build()).withStorageConfig(HoodieStorageConfig.newBuilder().hfileMaxFileSize(0x280000000L).logFileMaxSize(maxLogFileSizeBytes).logFileDataBlockMaxSize(maxLogFileSizeBytes).build()).withRollbackParallelism(512).withFinalizeWriteParallelism(512).withKeyGenerator(HoodieTableMetadataKeyGenerator.class.getCanonicalName()).withPopulateMetaFields(false).withWriteStatusClass(FailOnFirstErrorWriteStatus.class).withReleaseResourceEnabled(writeConfig.areReleaseResourceEnabled());
        Properties properties = new Properties();
        properties.put(HoodieTableConfig.RECORDKEY_FIELDS.key(), RECORD_KEY_FIELD_NAME);
        properties.put("hoodie.datasource.write.recordkey.field", RECORD_KEY_FIELD_NAME);
        builder.withProperties(properties);
        if (writeConfig.isMetricsOn()) {
            Properties commonProperties = new Properties();
            commonProperties.put(HoodieWriteConfig.TBL_NAME.key(), tableName);
            builder.withMetricsConfig(HoodieMetricsConfig.newBuilder().fromProperties(commonProperties).withReporterType(writeConfig.getMetricsReporterType().toString()).withExecutorMetrics(writeConfig.isExecutorMetricsEnabled()).on(true).build());
            switch (writeConfig.getMetricsReporterType()) {
                case GRAPHITE: {
                    builder.withMetricsGraphiteConfig(HoodieMetricsGraphiteConfig.newBuilder().onGraphitePort(writeConfig.getGraphiteServerPort()).toGraphiteHost(writeConfig.getGraphiteServerHost()).usePrefix(writeConfig.getGraphiteMetricPrefix()).build());
                    break;
                }
                case JMX: {
                    builder.withMetricsJmxConfig(HoodieMetricsJmxConfig.newBuilder().onJmxPort(writeConfig.getJmxPort()).toJmxHost(writeConfig.getJmxHost()).build());
                    break;
                }
                case PROMETHEUS_PUSHGATEWAY: {
                    HoodieMetricsPrometheusConfig prometheusConfig = HoodieMetricsPrometheusConfig.newBuilder().withPushgatewayJobname(writeConfig.getPushGatewayJobName()).withPushgatewayRandomJobnameSuffix(writeConfig.getPushGatewayRandomJobNameSuffix()).withPushgatewayLabels(writeConfig.getPushGatewayLabels()).withPushgatewayReportPeriodInSeconds(String.valueOf(writeConfig.getPushGatewayReportPeriodSeconds())).withPushgatewayHostName(writeConfig.getPushGatewayHost()).withPushgatewayPortNum(writeConfig.getPushGatewayPort()).build();
                    builder.withProperties(prometheusConfig.getProps());
                    break;
                }
                case DATADOG: 
                case PROMETHEUS: 
                case CONSOLE: 
                case INMEMORY: 
                case CLOUDWATCH: {
                    break;
                }
                default: {
                    throw new HoodieMetadataException("Unsupported Metrics Reporter type " + (Object)((Object)writeConfig.getMetricsReporterType()));
                }
            }
        }
        ValidationUtils.checkArgument(!(metadataWriteConfig = builder.build()).isAutoClean(), "Cleaning is controlled internally for Metadata table.");
        ValidationUtils.checkArgument(!metadataWriteConfig.inlineCompactionEnabled(), "Compaction is controlled internally for metadata table.");
        ValidationUtils.checkArgument((boolean)metadataWriteConfig.shouldAutoCommit(), "Auto commit is required for Metadata Table");
        ValidationUtils.checkArgument(metadataWriteConfig.getWriteStatusClassName().equals(FailOnFirstErrorWriteStatus.class.getName()), "MDT should use " + FailOnFirstErrorWriteStatus.class.getName());
        ValidationUtils.checkArgument(!metadataWriteConfig.isMetadataTableEnabled(), "File listing cannot be used for Metadata Table");
        return metadataWriteConfig;
    }
}

