/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metrics;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hudi.common.metrics.Registry;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.util.AccumulatorV2;

public class DistributedRegistry
extends AccumulatorV2<Map<String, Long>, Map<String, Long>>
implements Registry,
Serializable {
    private String name;
    ConcurrentHashMap<String, Long> counters = new ConcurrentHashMap();

    public DistributedRegistry(String name) {
        this.name = name;
    }

    public void register(JavaSparkContext jsc) {
        if (!this.isRegistered()) {
            jsc.sc().register((AccumulatorV2)this);
        }
    }

    @Override
    public void clear() {
        this.counters.clear();
    }

    @Override
    public void increment(String name) {
        this.counters.merge(name, 1L, Long::sum);
    }

    @Override
    public void add(String name, long value) {
        this.counters.merge(name, value, Long::sum);
    }

    @Override
    public void set(String name, long value) {
        this.counters.merge(name, value, (oldValue, newValue) -> newValue);
    }

    @Override
    public Map<String, Long> getAllCounts(boolean prefixWithRegistryName) {
        HashMap<String, Long> countersMap = new HashMap<String, Long>();
        this.counters.forEach((k, v) -> {
            String key = prefixWithRegistryName ? this.name + "." + k : k;
            countersMap.put(key, (Long)v);
        });
        return countersMap;
    }

    public void add(Map<String, Long> arg) {
        arg.forEach(this::add);
    }

    public AccumulatorV2<Map<String, Long>, Map<String, Long>> copy() {
        DistributedRegistry registry = new DistributedRegistry(this.name);
        this.counters.forEach(registry::add);
        return registry;
    }

    public boolean isZero() {
        return this.counters.isEmpty();
    }

    public void merge(AccumulatorV2<Map<String, Long>, Map<String, Long>> acc) {
        ((Map)acc.value()).forEach(this::add);
    }

    public void reset() {
        this.counters.clear();
    }

    public Map<String, Long> value() {
        return this.counters;
    }
}

