/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.spark3.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.time.ZoneId;
import org.apache.hudi.HoodieSparkUtils;
import org.apache.spark.sql.catalyst.plans.logical.InsertIntoStatement;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.util.DateFormatter;
import scala.Option;
import scala.collection.Seq;
import scala.collection.immutable.Map;

public class ReflectUtil {
    public static InsertIntoStatement createInsertInto(LogicalPlan table, Map<String, Option<String>> partition, Seq<String> userSpecifiedCols, LogicalPlan query, boolean overwrite, boolean ifPartitionNotExists) {
        try {
            if (HoodieSparkUtils.isSpark3_0()) {
                Constructor constructor = InsertIntoStatement.class.getConstructor(LogicalPlan.class, Map.class, LogicalPlan.class, Boolean.TYPE, Boolean.TYPE);
                return (InsertIntoStatement)constructor.newInstance(table, partition, query, overwrite, ifPartitionNotExists);
            }
            Constructor constructor = InsertIntoStatement.class.getConstructor(LogicalPlan.class, Map.class, Seq.class, LogicalPlan.class, Boolean.TYPE, Boolean.TYPE);
            return (InsertIntoStatement)constructor.newInstance(table, partition, userSpecifiedCols, query, overwrite, ifPartitionNotExists);
        }
        catch (Exception e) {
            throw new RuntimeException("Error in create InsertIntoStatement", e);
        }
    }

    public static DateFormatter getDateFormatter(ZoneId zoneId) {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            if (HoodieSparkUtils.gteqSpark3_2()) {
                Class<?> clazz = loader.loadClass(DateFormatter.class.getName());
                Method applyMethod = clazz.getDeclaredMethod("apply", new Class[0]);
                applyMethod.setAccessible(true);
                return (DateFormatter)applyMethod.invoke(null, new Object[0]);
            }
            Class<?> clazz = loader.loadClass(DateFormatter.class.getName());
            Method applyMethod = clazz.getDeclaredMethod("apply", ZoneId.class);
            applyMethod.setAccessible(true);
            return (DateFormatter)applyMethod.invoke(null, zoneId);
        }
        catch (Exception e) {
            throw new RuntimeException("Error in apply DateFormatter", e);
        }
    }
}

