/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action;

import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.avro.model.HoodieCleanMetadata;
import org.apache.hudi.avro.model.HoodieRestoreMetadata;
import org.apache.hudi.avro.model.HoodieRollbackMetadata;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.metadata.HoodieTableMetadataWriter;
import org.apache.hudi.table.HoodieTable;

public abstract class BaseActionExecutor<T, I, K, O, R>
implements Serializable {
    protected final transient HoodieEngineContext context;
    protected final transient Configuration hadoopConf;
    protected final HoodieWriteConfig config;
    protected final HoodieTable<T, I, K, O> table;
    protected final String instantTime;

    public BaseActionExecutor(HoodieEngineContext context, HoodieWriteConfig config, HoodieTable<T, I, K, O> table, String instantTime) {
        this.context = context;
        this.hadoopConf = context.getHadoopConf().get();
        this.config = config;
        this.table = table;
        this.instantTime = instantTime;
    }

    public abstract R execute();

    protected final void writeTableMetadata(HoodieCommitMetadata metadata, HoodieData<WriteStatus> writeStatus, String actionType) {
        Option<HoodieTableMetadataWriter> metadataWriterOpt = this.table.getMetadataWriter(this.instantTime);
        if (metadataWriterOpt.isPresent()) {
            try (HoodieTableMetadataWriter metadataWriter = metadataWriterOpt.get();){
                metadataWriter.update(metadata, writeStatus, this.instantTime);
            }
            catch (Exception e) {
                if (e instanceof HoodieException) {
                    throw (HoodieException)e;
                }
                throw new HoodieException("Failed to update metadata", e);
            }
        }
    }

    protected final void writeTableMetadata(HoodieCleanMetadata metadata, String instantTime) {
        Option<HoodieTableMetadataWriter> metadataWriterOpt = this.table.getMetadataWriter(instantTime);
        if (metadataWriterOpt.isPresent()) {
            try (HoodieTableMetadataWriter metadataWriter = metadataWriterOpt.get();){
                metadataWriter.update(metadata, instantTime);
            }
            catch (Exception e) {
                if (e instanceof HoodieException) {
                    throw (HoodieException)e;
                }
                throw new HoodieException("Failed to apply clean commit to metadata", e);
            }
        }
    }

    protected final void writeTableMetadata(HoodieRollbackMetadata metadata) {
        Option<HoodieTableMetadataWriter> metadataWriterOpt = this.table.getMetadataWriter(this.instantTime);
        if (metadataWriterOpt.isPresent()) {
            try (HoodieTableMetadataWriter metadataWriter = metadataWriterOpt.get();){
                metadataWriter.update(metadata, this.instantTime);
            }
            catch (Exception e) {
                if (e instanceof HoodieException) {
                    throw (HoodieException)e;
                }
                throw new HoodieException("Failed to apply rollbacks in metadata", e);
            }
        }
    }

    protected final void writeTableMetadata(HoodieRestoreMetadata metadata) {
        Option<HoodieTableMetadataWriter> metadataWriterOpt = this.table.getMetadataWriter(this.instantTime);
        if (metadataWriterOpt.isPresent()) {
            try (HoodieTableMetadataWriter metadataWriter = metadataWriterOpt.get();){
                metadataWriter.update(metadata, this.instantTime);
            }
            catch (Exception e) {
                if (e instanceof HoodieException) {
                    throw (HoodieException)e;
                }
                throw new HoodieException("Failed to apply restore to metadata", e);
            }
        }
    }
}

