/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.Serializable;
import org.apache.spark.sql.HoodieUnsafeRowUtils;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction1;

public final class HoodieUnsafeRowUtils$ {
    public static HoodieUnsafeRowUtils$ MODULE$;

    static {
        new HoodieUnsafeRowUtils$();
    }

    public Object getNestedRowValue(Row row, HoodieUnsafeRowUtils.NestedFieldPath nestedFieldPath) {
        Object object;
        Object object2 = new Object();
        try {
            ObjectRef curRow = ObjectRef.create((Object)row);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])nestedFieldPath.parts())).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)idx -> {
                Tuple2<Object, StructField> tuple2 = nestedFieldPath.parts()[idx];
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                int ord = tuple2._1$mcI$sp();
                StructField f = (StructField)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)ord), (Object)f);
                Tuple2 tuple23 = tuple22;
                int ord2 = tuple23._1$mcI$sp();
                StructField f2 = (StructField)tuple23._2();
                if (((Row)curRow$1.elem).isNullAt(ord2)) {
                    if (f2.nullable()) {
                        throw new NonLocalReturnControl(object2, null);
                    }
                    throw new IllegalArgumentException(new StringBuilder(65).append("Found null value for the field that is declared as non-nullable: ").append(f2).toString());
                }
                if (idx == nestedFieldPath.parts().length - 1) {
                    throw new NonLocalReturnControl(object2, ((Row)curRow$1.elem).get(ord2));
                }
                DataType dataType = f2.dataType();
                if (!(dataType instanceof StructType)) {
                    throw new IllegalArgumentException(new StringBuilder(56).append("Invalid nested-field path: expected StructType, but was ").append(dataType).toString());
                }
                Row row = ((Row)curRow$1.elem).getStruct(ord2);
                curRow$1.elem = row;
            });
            object = BoxedUnit.UNIT;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object2) {
                object = ex.value();
            }
            throw ex;
        }
        return object;
    }

    public Object getNestedInternalRowValue(InternalRow row, HoodieUnsafeRowUtils.NestedFieldPath nestedFieldPath) {
        if (nestedFieldPath.parts().length == 0) {
            throw new IllegalArgumentException("Nested field-path could not be empty");
        }
        InternalRow curRow = row;
        for (int idx = 0; idx < nestedFieldPath.parts().length; ++idx) {
            Tuple2<Object, StructField> tuple2 = nestedFieldPath.parts()[idx];
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            int ord = tuple2._1$mcI$sp();
            StructField f = (StructField)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)ord), (Object)f);
            Tuple2 tuple23 = tuple22;
            int ord2 = tuple23._1$mcI$sp();
            StructField f2 = (StructField)tuple23._2();
            if (curRow.isNullAt(ord2)) {
                if (f2.nullable()) {
                    return null;
                }
                throw new IllegalArgumentException(new StringBuilder(65).append("Found null value for the field that is declared as non-nullable: ").append(f2).toString());
            }
            if (idx == nestedFieldPath.parts().length - 1) {
                return curRow.get(ord2, f2.dataType());
            }
            DataType dataType = f2.dataType();
            if (!(dataType instanceof StructType)) {
                throw new IllegalArgumentException(new StringBuilder(56).append("Invalid nested-field path: expected StructType, but was ").append(dataType).toString());
            }
            StructType structType = (StructType)dataType;
            InternalRow internalRow = curRow.getStruct(ord2, structType.fields().length);
            curRow = internalRow;
        }
        return BoxedUnit.UNIT;
    }

    public Option<HoodieUnsafeRowUtils.NestedFieldPath> composeNestedFieldPath(StructType schema, String nestedFieldRef) {
        String[] fieldRefParts = new StringOps(Predef$.MODULE$.augmentString(nestedFieldRef)).split('.');
        ArrayBuffer ordSeq = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        StructType curSchema = schema;
        for (int idx = 0; idx < fieldRefParts.length; ++idx) {
            BoxedUnit boxedUnit;
            String fieldRefPart = fieldRefParts[idx];
            Option option = curSchema.getFieldIndex(fieldRefPart);
            if (option instanceof Some) {
                Some some = (Some)option;
                int ord = BoxesRunTime.unboxToInt((Object)some.value());
                StructField field = curSchema.apply(ord);
                ordSeq.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)ord), (Object)field)}));
                if (idx < fieldRefParts.length - 1) {
                    StructType structType;
                    DataType dataType = field.dataType();
                    if (!(dataType instanceof StructType)) {
                        return None$.MODULE$;
                    }
                    StructType structType2 = structType = (StructType)dataType;
                    curSchema = structType2;
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                if (None$.MODULE$.equals(option)) {
                    return None$.MODULE$;
                }
                throw new MatchError((Object)option);
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        }
        return new Some((Object)new HoodieUnsafeRowUtils.NestedFieldPath((Tuple2[])ordSeq.toArray(ClassTag$.MODULE$.apply(Tuple2.class))));
    }

    private HoodieUnsafeRowUtils$() {
        MODULE$ = this;
    }
}

