/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi;

import org.apache.hudi.ColumnStatsIndexSupport$;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.spark.sql.catalyst.expressions.And;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.EqualTo;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GreaterThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.LessThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.SubqueryExpression$;
import org.apache.spark.sql.functions$;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;

public final class ColumnStatsExpressionUtils$ {
    public static ColumnStatsExpressionUtils$ MODULE$;

    static {
        new ColumnStatsExpressionUtils$();
    }

    public Expression genColMinValueExpr(String colName) {
        return functions$.MODULE$.col(ColumnStatsIndexSupport$.MODULE$.getMinColumnNameFor(colName)).expr();
    }

    public Expression genColMaxValueExpr(String colName) {
        return functions$.MODULE$.col(ColumnStatsIndexSupport$.MODULE$.getMaxColumnNameFor(colName)).expr();
    }

    public Expression genColNumNullsExpr(String colName) {
        return functions$.MODULE$.col(ColumnStatsIndexSupport$.MODULE$.getNullCountColumnNameFor(colName)).expr();
    }

    public Expression genColValueCountExpr() {
        return functions$.MODULE$.col(ColumnStatsIndexSupport$.MODULE$.getValueCountColumnNameFor()).expr();
    }

    public Expression genColumnValuesEqualToExpression(String colName, Expression value, Function1<Expression, Expression> targetExprBuilder) {
        Expression minValueExpr = (Expression)targetExprBuilder.apply((Object)this.genColMinValueExpr(colName));
        Expression maxValueExpr = (Expression)targetExprBuilder.apply((Object)this.genColMaxValueExpr(colName));
        return new And((Expression)new LessThanOrEqual(minValueExpr, value), (Expression)new GreaterThanOrEqual(maxValueExpr, value));
    }

    public Function1<Expression, Expression> genColumnValuesEqualToExpression$default$3() {
        return (Function1 & java.io.Serializable & Serializable)x -> (Expression)Predef$.MODULE$.identity(x);
    }

    public Expression genColumnOnlyValuesEqualToExpression(String colName, Expression value, Function1<Expression, Expression> targetExprBuilder) {
        Expression minValueExpr = (Expression)targetExprBuilder.apply((Object)this.genColMinValueExpr(colName));
        Expression maxValueExpr = (Expression)targetExprBuilder.apply((Object)this.genColMaxValueExpr(colName));
        return new And((Expression)new EqualTo(minValueExpr, value), (Expression)new EqualTo(maxValueExpr, value));
    }

    public Function1<Expression, Expression> genColumnOnlyValuesEqualToExpression$default$3() {
        return (Function1 & java.io.Serializable & Serializable)x -> (Expression)Predef$.MODULE$.identity(x);
    }

    public Expression swapAttributeRefInExpr(Expression sourceExpr, AttributeReference from, Expression to) {
        ValidationUtils.checkState(sourceExpr.references().size() == 1);
        return (Expression)sourceExpr.transformDown((PartialFunction)new Serializable(from, to){
            public static final long serialVersionUID = 0L;
            private final AttributeReference from$1;
            private final Expression to$1;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                AttributeReference attributeReference;
                A1 A1 = x1;
                Object object = A1 instanceof AttributeReference && (attributeReference = (AttributeReference)A1).sameRef(this.from$1) ? this.to$1 : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Expression x1) {
                AttributeReference attributeReference;
                Expression expression = x1;
                boolean bl = expression instanceof AttributeReference && (attributeReference = (AttributeReference)expression).sameRef(this.from$1);
                return bl;
            }
            {
                this.from$1 = from$1;
                this.to$1 = to$1;
            }
        });
    }

    public boolean isValueExpression(Expression expr) {
        return expr.references().isEmpty() && !SubqueryExpression$.MODULE$.hasSubquery(expr);
    }

    private ColumnStatsExpressionUtils$() {
        MODULE$ = this;
    }
}

