/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi;

import java.io.Serializable;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.exception.HoodieException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.hudi.DeDupeType$;
import org.apache.spark.sql.hudi.SparkHelper;
import org.apache.spark.sql.hudi.SparkHelpers$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;

@ScalaSignature(bytes="\u0006\u0001\u0005%c\u0001B\t\u0013\u0001uA\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I!\n\u0005\ta\u0001\u0011\t\u0011)A\u0005K!A\u0011\u0007\u0001B\u0001B\u0003%Q\u0005\u0003\u00053\u0001\t\u0005\t\u0015!\u00034\u0011!9\u0004A!A!\u0002\u0013A\u0004\u0002C \u0001\u0005\u0003\u0005\u000b\u0011\u0002!\t\u000b%\u0003A\u0011\u0001&\t\u000fI\u0003!\u0019!C\u0001'\"1q\u000b\u0001Q\u0001\nQCq\u0001\u0017\u0001C\u0002\u0013\u0005\u0011\f\u0003\u0004a\u0001\u0001\u0006IA\u0017\u0005\u0006C\u0002!\tA\u0019\u0005\u0006i\u0002!I!\u001e\u0005\b\u0003\u0007\u0001A\u0011BA\u0003\u0011\u001d\ti\u0002\u0001C\u0001\u0003?A\u0011\"!\r\u0001#\u0003%\t!a\r\u0003\u001d\u0011+G-\u001e9f'B\f'o\u001b&pE*\u00111\u0003F\u0001\u0005QV$\u0017N\u0003\u0002\u0016-\u0005\u00191/\u001d7\u000b\u0005]A\u0012!B:qCJ\\'BA\r\u001b\u0003\u0019\t\u0007/Y2iK*\t1$A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001=A\u0011qDI\u0007\u0002A)\t\u0011%A\u0003tG\u0006d\u0017-\u0003\u0002$A\t1\u0011I\\=SK\u001a\f\u0001BY1tKB\u000bG\u000f\u001b\t\u0003M5r!aJ\u0016\u0011\u0005!\u0002S\"A\u0015\u000b\u0005)b\u0012A\u0002\u001fs_>$h(\u0003\u0002-A\u00051\u0001K]3eK\u001aL!AL\u0018\u0003\rM#(/\u001b8h\u0015\ta\u0003%A\fekBd\u0017nY1uK\u0012\u0004\u0016M\u001d;ji&|g\u000eU1uQ\u0006\u0001\"/\u001a9bSJ|U\u000f\u001e9viB\u000bG\u000f[\u0001\u000bgFd7i\u001c8uKb$\bC\u0001\u001b6\u001b\u0005!\u0012B\u0001\u001c\u0015\u0005)\u0019\u0016\u000bT\"p]R,\u0007\u0010^\u0001\u0003MN\u0004\"!O\u001f\u000e\u0003iR!aN\u001e\u000b\u0005qB\u0012A\u00025bI>|\u0007/\u0003\u0002?u\tQa)\u001b7f'f\u001cH/Z7\u0002\u0015\u0011,G-\u001e9f)f\u0004X\r\u0005\u0002B\u000b:\u0011!iQ\u0007\u0002%%\u0011AIE\u0001\u000b\t\u0016$U\u000f]3UsB,\u0017B\u0001$H\u0005\u00151\u0016\r\\;f\u0013\tA\u0005EA\u0006F]VlWM]1uS>t\u0017A\u0002\u001fj]&$h\bF\u0004L\u00196su\nU)\u0011\u0005\t\u0003\u0001\"\u0002\u0013\b\u0001\u0004)\u0003\"\u0002\u0019\b\u0001\u0004)\u0003\"B\u0019\b\u0001\u0004)\u0003\"\u0002\u001a\b\u0001\u0004\u0019\u0004\"B\u001c\b\u0001\u0004A\u0004\"B \b\u0001\u0004\u0001\u0015aC:qCJ\\\u0007*\u001a7qKJ,\u0012\u0001\u0016\t\u0003\u0005VK!A\u0016\n\u0003\u0017M\u0003\u0018M]6IK2\u0004XM]\u0001\rgB\f'o\u001b%fYB,'\u000fI\u0001\u0004\u0019>;U#\u0001.\u0011\u0005msV\"\u0001/\u000b\u0005uS\u0012!B:mMRR\u0017BA0]\u0005\u0019aunZ4fe\u0006!AjT$!\u000319W\r\u001e#va\u0016\\U-\u001f#G)\t\u0019'\u000f\u0005\u0002e_:\u0011Q-\u001c\b\u0003M2t!aZ6\u000f\u0005!TgB\u0001\u0015j\u0013\u0005Y\u0012BA\r\u001b\u0013\t9\u0002$\u0003\u0002\u0016-%\u0011a\u000eF\u0001\ba\u0006\u001c7.Y4f\u0013\t\u0001\u0018OA\u0005ECR\fgI]1nK*\u0011a\u000e\u0006\u0005\u0006g2\u0001\r!J\u0001\bi\ndg*Y7f\u0003A\u0001H.\u00198EkBd\u0017nY1uK\u001aK\u0007\u0010F\u0001w!\u00119H0\n@\u000e\u0003aT!!\u001f>\u0002\u000f5,H/\u00192mK*\u00111\u0010I\u0001\u000bG>dG.Z2uS>t\u0017BA?y\u0005\u001dA\u0015m\u001d5NCB\u00042a^@&\u0013\r\t\t\u0001\u001f\u0002\b\u0011\u0006\u001c\bnU3u\u000359W\r\u001e#fIV\u0004X\r\u00157b]R\u0019a/a\u0002\t\u000f\u0005%a\u00021\u0001\u0002\f\u00059A-\u001e9f\u001b\u0006\u0004\bC\u0002\u0014\u0002\u000e\u0015\n\t\"C\u0002\u0002\u0010=\u00121!T1q!\u00159\u00181CA\f\u0013\r\t)\u0002\u001f\u0002\u0007\u0005V4g-\u001a:\u0011\u0007Q\nI\"C\u0002\u0002\u001cQ\u00111AU8x\u000351\u0017\u000e\u001f#va2L7-\u0019;fgR!\u0011\u0011EA\u0014!\ry\u00121E\u0005\u0004\u0003K\u0001#\u0001B+oSRD\u0011\"!\u000b\u0010!\u0003\u0005\r!a\u000b\u0002\r\u0011\u0014\u0018PU;o!\ry\u0012QF\u0005\u0004\u0003_\u0001#a\u0002\"p_2,\u0017M\\\u0001\u0018M&DH)\u001e9mS\u000e\fG/Z:%I\u00164\u0017-\u001e7uIE*\"!!\u000e+\t\u0005-\u0012qG\u0016\u0003\u0003s\u0001B!a\u000f\u0002F5\u0011\u0011Q\b\u0006\u0005\u0003\u007f\t\t%A\u0005v]\u000eDWmY6fI*\u0019\u00111\t\u0011\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002H\u0005u\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class DedupeSparkJob {
    private final String basePath;
    private final String duplicatedPartitionPath;
    private final String repairOutputPath;
    private final SQLContext sqlContext;
    private final FileSystem fs;
    private final Enumeration.Value dedupeType;
    private final SparkHelper sparkHelper;
    private final Logger LOG;

    public SparkHelper sparkHelper() {
        return this.sparkHelper;
    }

    public Logger LOG() {
        return this.LOG;
    }

    public Dataset<Row> getDupeKeyDF(String tblName) {
        String dupeSql = new StringBuilder(120).append("\n      select  `").append(HoodieRecord.RECORD_KEY_METADATA_FIELD).append("` as dupe_key,\n      count(*) as dupe_cnt\n      from ").append(tblName).append("\n      group by `").append(HoodieRecord.RECORD_KEY_METADATA_FIELD).append("`\n      having dupe_cnt > 1\n      ").toString();
        return this.sqlContext.sql(dupeSql);
    }

    private HashMap<String, HashSet<String>> planDuplicateFix() {
        String tmpTableName = new StringBuilder(5).append("htbl_").append(System.currentTimeMillis()).toString();
        String dedupeTblName = new StringBuilder(9).append(tmpTableName).append("_dupeKeys").toString();
        HoodieTableMetaClient metadata = HoodieTableMetaClient.builder().setConf(this.fs.getConf()).setBasePath(this.basePath).build();
        FileStatus[] allFiles = this.fs.listStatus(new Path(new StringBuilder(1).append(this.basePath).append("/").append(this.duplicatedPartitionPath).toString()));
        HoodieTableFileSystemView fsView = new HoodieTableFileSystemView(metadata, metadata.getActiveTimeline().getCommitsTimeline().filterCompletedInstants(), allFiles);
        java.util.List latestFiles = fsView.getLatestBaseFiles().collect(Collectors.toList());
        Buffer filteredStatuses = (Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(latestFiles).map((Function1 & Serializable & scala.Serializable)f -> f.getPath(), Buffer$.MODULE$.canBuildFrom());
        this.LOG().info(new StringBuilder(37).append(" List of files under partition: ").append(BoxedUnit.UNIT).append(" =>  ").append(filteredStatuses.mkString(" ")).toString());
        Dataset df = this.sqlContext.parquetFile((Seq)filteredStatuses);
        df.registerTempTable(tmpTableName);
        Dataset<Row> dupeKeyDF = this.getDupeKeyDF(tmpTableName);
        dupeKeyDF.registerTempTable(dedupeTblName);
        String dupeDataSql = new StringBuilder(208).append("\n        SELECT `_hoodie_record_key`, `_hoodie_partition_path`, `_hoodie_file_name`, `_hoodie_commit_time`\n        FROM ").append(tmpTableName).append(" h\n        JOIN ").append(dedupeTblName).append(" d\n        ON h.`_hoodie_record_key` = d.dupe_key\n                      ").toString();
        Map dupeMap = JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(this.sqlContext.sql(dupeDataSql).collectAsList()).groupBy((Function1 & Serializable & scala.Serializable)r -> r.getString(0));
        return this.getDedupePlan((Map<String, Buffer<Row>>)dupeMap);
    }

    /*
     * WARNING - void declaration
     */
    private HashMap<String, HashSet<String>> getDedupePlan(Map<String, Buffer<Row>> dupeMap) {
        void var2_2;
        HashMap fileToDeleteKeyMap = new HashMap();
        dupeMap.foreach((Function1 & Serializable & scala.Serializable)rt -> {
            DedupeSparkJob.$anonfun$getDedupePlan$1(this, fileToDeleteKeyMap, rt);
            return BoxedUnit.UNIT;
        });
        this.LOG().debug(new StringBuilder(32).append("fileToDeleteKeyMap size: ").append(fileToDeleteKeyMap.size()).append(", map: ").append(fileToDeleteKeyMap).toString());
        return var2_2;
    }

    public void fixDuplicates(boolean dryRun) {
        Dataset<Row> fixedDF;
        HoodieTableMetaClient metadata = HoodieTableMetaClient.builder().setConf(this.fs.getConf()).setBasePath(this.basePath).build();
        FileStatus[] allFiles = this.fs.listStatus(new Path(new StringBuilder(1).append(this.basePath).append("/").append(this.duplicatedPartitionPath).toString()));
        HoodieTableFileSystemView fsView = new HoodieTableFileSystemView(metadata, metadata.getActiveTimeline().getCommitsTimeline().filterCompletedInstants(), allFiles);
        java.util.List latestFiles = fsView.getLatestBaseFiles().collect(Collectors.toList());
        Map fileNameToPathMap = ((TraversableOnce)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(latestFiles).map((Function1 & Serializable & scala.Serializable)f -> new Tuple2((Object)f.getFileId(), (Object)new Path(f.getPath())), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        HashMap<String, HashSet<String>> dupeFixPlan = this.planDuplicateFix();
        fileNameToPathMap.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DedupeSparkJob.$anonfun$fixDuplicates$2(this, dupeFixPlan, x0$1)));
        dupeFixPlan.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)DedupeSparkJob.$anonfun$fixDuplicates$3(this, fileNameToPathMap, dupeFixPlan, x0$2)));
        Dataset df = this.sqlContext.read().parquet(new StringBuilder(10).append(this.repairOutputPath).append("/*.parquet").toString());
        df.registerTempTable("fixedTbl");
        Dataset<Row> dupeKeyDF = this.getDupeKeyDF("fixedTbl");
        long dupeCnt = dupeKeyDF.count();
        if (dupeCnt != 0L) {
            dupeKeyDF.show();
            throw new HoodieException("Still found some duplicates!!.. Inspect output");
        }
        Dataset<Row> sourceDF = this.sparkHelper().getDistinctKeyDF((List<String>)((TraversableOnce)fileNameToPathMap.map((Function1 & Serializable & scala.Serializable)t -> ((Path)t._2()).toString(), Iterable$.MODULE$.canBuildFrom())).toList());
        Dataset missedRecordKeysDF = sourceDF.except(fixedDF = this.sparkHelper().getDistinctKeyDF((List<String>)((TraversableOnce)fileNameToPathMap.map((Function1 & Serializable & scala.Serializable)t -> new StringBuilder(1).append($this.repairOutputPath).append("/").append(((Path)t._2()).getName()).toString(), Iterable$.MODULE$.canBuildFrom())).toList()));
        long missedCnt = missedRecordKeysDF.count();
        if (missedCnt != 0L) {
            missedRecordKeysDF.show();
            throw new HoodieException("Some records in source are not found in fixed files. Inspect output!!");
        }
        Predef$.MODULE$.println((Object)"No duplicates found & counts are in check!!!! ");
        fileNameToPathMap.foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Object object;
            Tuple2 tuple2 = x0$3;
            if (tuple2 != null) {
                Path filePath = (Path)tuple2._2();
                Path srcPath = new Path(new StringBuilder(1).append($this.repairOutputPath).append("/").append(filePath.getName()).toString());
                Path dstPath = new Path(new StringBuilder(2).append($this.basePath).append("/").append($this.duplicatedPartitionPath).append("/").append(filePath.getName()).toString());
                if (dryRun) {
                    this.LOG().info(new StringBuilder(35).append("[JUST KIDDING!!!] Copying from ").append(srcPath).append(" to ").append(dstPath).toString());
                    object = BoxedUnit.UNIT;
                } else {
                    this.LOG().info(new StringBuilder(31).append("[FOR REAL!!!] Copying from ").append(srcPath).append(" to ").append(dstPath).toString());
                    object = BoxesRunTime.boxToBoolean((boolean)FileUtil.copy((FileSystem)$this.fs, (Path)srcPath, (FileSystem)$this.fs, (Path)dstPath, (boolean)false, (boolean)true, (Configuration)$this.fs.getConf()));
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            BoxedUnit boxedUnit = object;
            return boxedUnit;
        });
    }

    public boolean fixDuplicates$default$1() {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$getDedupePlan$2(HashMap fileToDeleteKeyMap$1, String key$1, Row r) {
        String f;
        block0: {
            f = ((String)r.apply(2)).split("_")[0];
            if (fileToDeleteKeyMap$1.contains((Object)f)) break block0;
            fileToDeleteKeyMap$1.update((Object)f, (Object)HashSet$.MODULE$.apply((Seq)Nil$.MODULE$));
        }
        return ((HashSet)fileToDeleteKeyMap$1.apply((Object)f)).add((Object)key$1);
    }

    public static final /* synthetic */ void $anonfun$getDedupePlan$3(LongRef maxCommit$1, Row r) {
        block0: {
            long c = new StringOps(Predef$.MODULE$.augmentString((String)r.apply(3))).toLong();
            if (c <= maxCommit$1.elem) break block0;
            maxCommit$1.elem = c;
        }
    }

    public static final /* synthetic */ void $anonfun$getDedupePlan$5(LongRef maxCommit$2, Row r) {
        block0: {
            long c = new StringOps(Predef$.MODULE$.augmentString((String)r.apply(3))).toLong();
            if (c <= maxCommit$2.elem) break block0;
            maxCommit$2.elem = c;
        }
    }

    public static final /* synthetic */ boolean $anonfun$getDedupePlan$7(HashMap fileToDeleteKeyMap$1, String key$1, Row r) {
        String f;
        block0: {
            f = ((String)r.apply(2)).split("_")[0];
            if (fileToDeleteKeyMap$1.contains((Object)f)) break block0;
            fileToDeleteKeyMap$1.update((Object)f, (Object)HashSet$.MODULE$.apply((Seq)Nil$.MODULE$));
        }
        return ((HashSet)fileToDeleteKeyMap$1.apply((Object)f)).add((Object)key$1);
    }

    public static final /* synthetic */ void $anonfun$getDedupePlan$1(DedupeSparkJob $this, HashMap fileToDeleteKeyMap$1, Tuple2 rt) {
        Tuple2 tuple2 = rt;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String key = (String)tuple2._1();
        Buffer rows = (Buffer)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)key, (Object)rows);
        Tuple2 tuple23 = tuple22;
        String key2 = (String)tuple23._1();
        Buffer rows2 = (Buffer)tuple23._2();
        Enumeration.Value value = $this.dedupeType;
        Enumeration.Value value2 = DeDupeType$.MODULE$.UPDATE_TYPE();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            ((IterableLike)rows2.init()).foreach((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)DedupeSparkJob.$anonfun$getDedupePlan$2(fileToDeleteKeyMap$1, key2, r)));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            Enumeration.Value value4 = DeDupeType$.MODULE$.INSERT_TYPE();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                LongRef maxCommit = LongRef.create((long)-1L);
                rows2.foreach((Function1 & Serializable & scala.Serializable)r -> {
                    DedupeSparkJob.$anonfun$getDedupePlan$3(maxCommit, r);
                    return BoxedUnit.UNIT;
                });
                rows2.foreach((Function1 & Serializable & scala.Serializable)r -> {
                    Object object;
                    long c = new StringOps(Predef$.MODULE$.augmentString((String)r.apply(3))).toLong();
                    if (c != maxCommit$1.elem) {
                        String f = ((String)r.apply(2)).split("_")[0];
                        if (!fileToDeleteKeyMap$1.contains((Object)f)) {
                            fileToDeleteKeyMap$1.update((Object)f, (Object)HashSet$.MODULE$.apply((Seq)Nil$.MODULE$));
                        }
                        object = BoxesRunTime.boxToBoolean((boolean)((HashSet)fileToDeleteKeyMap$1.apply((Object)f)).add((Object)key2));
                    } else {
                        object = BoxedUnit.UNIT;
                    }
                    return object;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                Enumeration.Value value6 = DeDupeType$.MODULE$.UPSERT_TYPE();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    LongRef maxCommit = LongRef.create((long)-1L);
                    rows2.foreach((Function1 & Serializable & scala.Serializable)r -> {
                        DedupeSparkJob.$anonfun$getDedupePlan$5(maxCommit, r);
                        return BoxedUnit.UNIT;
                    });
                    ListBuffer rowsWithMaxCommit = new ListBuffer();
                    rows2.foreach((Function1 & Serializable & scala.Serializable)r -> {
                        Object object;
                        long c = new StringOps(Predef$.MODULE$.augmentString((String)r.apply(3))).toLong();
                        if (c != maxCommit$2.elem) {
                            String f = ((String)r.apply(2)).split("_")[0];
                            if (!fileToDeleteKeyMap$1.contains((Object)f)) {
                                fileToDeleteKeyMap$1.update((Object)f, (Object)HashSet$.MODULE$.apply((Seq)Nil$.MODULE$));
                            }
                            object = BoxesRunTime.boxToBoolean((boolean)((HashSet)fileToDeleteKeyMap$1.apply((Object)f)).add((Object)key2));
                        } else {
                            object = rowsWithMaxCommit.$plus$eq(r);
                        }
                        return object;
                    });
                    ((List)rowsWithMaxCommit.toList().init()).foreach((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)DedupeSparkJob.$anonfun$getDedupePlan$7(fileToDeleteKeyMap$1, key2, r)));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new IllegalArgumentException("Please provide valid type for deduping!");
                }
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$fixDuplicates$2(DedupeSparkJob $this, HashMap dupeFixPlan$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String fileName = (String)tuple2._1();
        Path filePath = (Path)tuple2._2();
        String badSuffix = dupeFixPlan$1.contains((Object)fileName) ? ".bad" : "";
        Path dstPath = new Path(new StringBuilder(1).append($this.repairOutputPath).append("/").append(filePath.getName()).append(badSuffix).toString());
        $this.LOG().info(new StringBuilder(17).append("Copying from ").append(filePath).append(" to ").append(dstPath).toString());
        boolean bl = FileUtil.copy((FileSystem)$this.fs, (Path)filePath, (FileSystem)$this.fs, (Path)dstPath, (boolean)false, (boolean)true, (Configuration)$this.fs.getConf());
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$fixDuplicates$3(DedupeSparkJob $this, Map fileNameToPathMap$1, HashMap dupeFixPlan$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String fileName = (String)tuple2._1();
        String instantTime = FSUtils.getCommitTime(((Path)fileNameToPathMap$1.apply((Object)fileName)).getName());
        Path badFilePath = new Path(new StringBuilder(5).append($this.repairOutputPath).append("/").append(((Path)fileNameToPathMap$1.apply((Object)fileName)).getName()).append(".bad").toString());
        Path newFilePath = new Path(new StringBuilder(1).append($this.repairOutputPath).append("/").append(((Path)fileNameToPathMap$1.apply((Object)fileName)).getName()).toString());
        $this.LOG().info(new StringBuilder(37).append(" Skipping and writing new file for : ").append(fileName).toString());
        SparkHelpers$.MODULE$.skipKeysAndWriteNewFile(instantTime, $this.fs, badFilePath, newFilePath, (Set<String>)((Set)dupeFixPlan$1.apply((Object)fileName)));
        boolean bl = $this.fs.delete(badFilePath, true);
        return bl;
    }

    public DedupeSparkJob(String basePath, String duplicatedPartitionPath, String repairOutputPath, SQLContext sqlContext, FileSystem fs, Enumeration.Value dedupeType) {
        this.basePath = basePath;
        this.duplicatedPartitionPath = duplicatedPartitionPath;
        this.repairOutputPath = repairOutputPath;
        this.sqlContext = sqlContext;
        this.fs = fs;
        this.dedupeType = dedupeType;
        this.sparkHelper = new SparkHelper(sqlContext, fs);
        this.LOG = LoggerFactory.getLogger(this.getClass());
    }
}

