/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command;

import java.nio.charset.StandardCharsets;
import org.apache.avro.Schema;
import org.apache.hudi.DataSourceUtils;
import org.apache.hudi.HoodieWriterUtils$;
import org.apache.hudi.SparkAdapterSupport;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.CommitUtils;
import org.apache.hudi.table.HoodieSparkTable;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable;
import org.apache.spark.sql.hudi.HoodieOptionConfig$;
import org.apache.spark.sql.hudi.SparkAdapter;
import org.apache.spark.sql.hudi.command.AlterHoodieTableAddColumnsCommand;
import org.apache.spark.sql.types.StructField;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Map;

public final class AlterHoodieTableAddColumnsCommand$
implements SparkAdapterSupport,
Serializable {
    public static AlterHoodieTableAddColumnsCommand$ MODULE$;
    private SparkAdapter sparkAdapter;
    private volatile boolean bitmap$0;

    static {
        new AlterHoodieTableAddColumnsCommand$();
    }

    private SparkAdapter sparkAdapter$lzycompute() {
        AlterHoodieTableAddColumnsCommand$ alterHoodieTableAddColumnsCommand$ = this;
        synchronized (alterHoodieTableAddColumnsCommand$) {
            if (!this.bitmap$0) {
                this.sparkAdapter = SparkAdapterSupport.sparkAdapter$(this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkAdapter;
    }

    @Override
    public SparkAdapter sparkAdapter() {
        return !this.bitmap$0 ? this.sparkAdapter$lzycompute() : this.sparkAdapter;
    }

    public void commitWithSchema(Schema schema, HoodieCatalogTable hoodieCatalogTable, SparkSession sparkSession) {
        Schema writeSchema = HoodieAvroUtils.removeMetadataFields(schema);
        JavaSparkContext jsc = new JavaSparkContext(sparkSession.sparkContext());
        SparkRDDWriteClient client = DataSourceUtils.createHoodieClient(jsc, writeSchema.toString(), hoodieCatalogTable.tableLocation(), hoodieCatalogTable.tableName(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(HoodieWriterUtils$.MODULE$.parametersWithWriteDefaults((Map<String, String>)HoodieOptionConfig$.MODULE$.mapSqlOptionsToDataSourceWriteConfigs(hoodieCatalogTable.catalogProperties()).$plus$plus((GenTraversableOnce)sparkSession.sqlContext().conf().getAllConfs()))).asJava());
        String commitActionType = CommitUtils.getCommitActionType(WriteOperationType.ALTER_SCHEMA, hoodieCatalogTable.tableType());
        String instantTime = HoodieActiveTimeline.createNewInstantTime();
        client.startCommitWithTime(instantTime, commitActionType);
        client.preWrite(instantTime, WriteOperationType.ALTER_SCHEMA, hoodieCatalogTable.metaClient());
        HoodieSparkTable hoodieTable = HoodieSparkTable.create(client.getConfig(), client.getEngineContext());
        HoodieActiveTimeline timeLine = hoodieTable.getActiveTimeline();
        HoodieInstant requested = new HoodieInstant(HoodieInstant.State.REQUESTED, commitActionType, instantTime);
        HoodieCommitMetadata metadata = new HoodieCommitMetadata();
        metadata.setOperationType(WriteOperationType.ALTER_SCHEMA);
        timeLine.transitionRequestedToInflight(requested, org.apache.hudi.common.util.Option.of(metadata.toJsonString().getBytes(StandardCharsets.UTF_8)));
        client.commit(instantTime, jsc.emptyRDD());
    }

    public void checkColumnNameDuplication(Seq<String> columnNames, String colType, boolean caseSensitiveAnalysis) {
        this.sparkAdapter().getSchemaUtils().checkColumnNameDuplication(columnNames, colType, caseSensitiveAnalysis);
    }

    public AlterHoodieTableAddColumnsCommand apply(TableIdentifier tableId, Seq<StructField> colsToAdd) {
        return new AlterHoodieTableAddColumnsCommand(tableId, colsToAdd);
    }

    public Option<Tuple2<TableIdentifier, Seq<StructField>>> unapply(AlterHoodieTableAddColumnsCommand x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2((Object)x$0.tableId(), x$0.colsToAdd()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private AlterHoodieTableAddColumnsCommand$() {
        MODULE$ = this;
        SparkAdapterSupport.$init$(this);
    }
}

