/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.procedures;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.hudi.HoodieCLIUtils$;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieReplaceCommitMetadata;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.exception.HoodieException;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable;
import org.apache.spark.sql.hudi.command.procedures.BaseProcedure;
import org.apache.spark.sql.hudi.command.procedures.Procedure;
import org.apache.spark.sql.hudi.command.procedures.ProcedureArgs;
import org.apache.spark.sql.hudi.command.procedures.ProcedureBuilder;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter$;
import org.apache.spark.sql.hudi.command.procedures.ShowCommitExtraMetadataProcedure$;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Mc\u0001B\n\u0015\u0001\rBQa\u000b\u0001\u0005\u00021BqA\f\u0001C\u0002\u0013%q\u0006\u0003\u0004:\u0001\u0001\u0006I\u0001\r\u0005\bu\u0001\u0011\r\u0011\"\u0003<\u0011\u0019\u0011\u0005\u0001)A\u0005y!)1\t\u0001C\u0001_!)A\t\u0001C\u0001w!)Q\t\u0001C!\r\")A\f\u0001C!;\")\u0011\r\u0001C\u0005E\")Q\u000f\u0001C\u0005m\"9\u0011Q\u0001\u0001\u0005\n\u0005\u001dqaBA\u000f)!\u0005\u0011q\u0004\u0004\u0007'QA\t!!\t\t\r-rA\u0011AA\u0015\u0011%\tYC\u0004b\u0001\n\u0003\ti\u0003\u0003\u0005\u0002>9\u0001\u000b\u0011BA\u0018\u0011\u001d\tyD\u0004C\u0001\u0003\u0003\u0012\u0001e\u00155po\u000e{W.\\5u\u000bb$(/Y'fi\u0006$\u0017\r^1Qe>\u001cW\rZ;sK*\u0011QCF\u0001\u000baJ|7-\u001a3ve\u0016\u001c(BA\f\u0019\u0003\u001d\u0019w.\\7b]\u0012T!!\u0007\u000e\u0002\t!,H-\u001b\u0006\u00037q\t1a]9m\u0015\tib$A\u0003ta\u0006\u00148N\u0003\u0002 A\u00051\u0011\r]1dQ\u0016T\u0011!I\u0001\u0004_J<7\u0001A\n\u0004\u0001\u0011B\u0003CA\u0013'\u001b\u0005!\u0012BA\u0014\u0015\u00055\u0011\u0015m]3Qe>\u001cW\rZ;sKB\u0011Q%K\u0005\u0003UQ\u0011\u0001\u0003\u0015:pG\u0016$WO]3Ck&dG-\u001a:\u0002\rqJg.\u001b;?)\u0005i\u0003CA\u0013\u0001\u0003)\u0001\u0016IU!N\u000bR+%kU\u000b\u0002aA\u0019\u0011\u0007\u000e\u001c\u000e\u0003IR\u0011aM\u0001\u0006g\u000e\fG.Y\u0005\u0003kI\u0012Q!\u0011:sCf\u0004\"!J\u001c\n\u0005a\"\"A\u0005)s_\u000e,G-\u001e:f!\u0006\u0014\u0018-\\3uKJ\f1\u0002U!S\u00036+E+\u0012*TA\u0005Yq*\u0016+Q+R{F+\u0017)F+\u0005a\u0004CA\u001fA\u001b\u0005q$BA \u001b\u0003\u0015!\u0018\u0010]3t\u0013\t\teH\u0001\u0006TiJ,8\r\u001e+za\u0016\fAbT+U!V#v\fV-Q\u000b\u0002\n!\u0002]1sC6,G/\u001a:t\u0003)yW\u000f\u001e9viRK\b/Z\u0001\u0005G\u0006dG\u000e\u0006\u0002H/B\u0019\u0001\nU*\u000f\u0005%seB\u0001&N\u001b\u0005Y%B\u0001'#\u0003\u0019a$o\\8u}%\t1'\u0003\u0002Pe\u00059\u0001/Y2lC\u001e,\u0017BA)S\u0005\r\u0019V-\u001d\u0006\u0003\u001fJ\u0002\"\u0001V+\u000e\u0003iI!A\u0016\u000e\u0003\u0007I{w\u000fC\u0003Y\u0011\u0001\u0007\u0011,\u0001\u0003be\u001e\u001c\bCA\u0013[\u0013\tYFCA\u0007Qe>\u001cW\rZ;sK\u0006\u0013xm]\u0001\u0006EVLG\u000eZ\u000b\u0002=B\u0011QeX\u0005\u0003AR\u0011\u0011\u0002\u0015:pG\u0016$WO]3\u0002/\u001d,GoQ8n[&$hi\u001c:MCN$\u0018J\\:uC:$HCA2r!\r\tDMZ\u0005\u0003KJ\u0012aa\u00149uS>t\u0007CA4p\u001b\u0005A'BA5k\u0003!!\u0018.\\3mS:,'BA6m\u0003\u0015!\u0018M\u00197f\u0015\tig.\u0001\u0004d_6lwN\u001c\u0006\u00033yI!\u0001\u001d5\u0003\u001b!{w\u000eZ5f\u0013:\u001cH/\u00198u\u0011\u0015I'\u00021\u0001s!\t97/\u0003\u0002uQ\nq\u0001j\\8eS\u0016$\u0016.\\3mS:,\u0017aE4fi\u000e{W.\\5u\r>\u0014\u0018J\\:uC:$HcA2xq\")\u0011n\u0003a\u0001e\")\u0011p\u0003a\u0001u\u0006Y\u0011N\\:uC:$H+[7f!\tYxP\u0004\u0002}{B\u0011!JM\u0005\u0003}J\na\u0001\u0015:fI\u00164\u0017\u0002BA\u0001\u0003\u0007\u0011aa\u0015;sS:<'B\u0001@3\u0003]9W\r\u001e%p_\u0012LWmQ8n[&$X*\u001a;bI\u0006$\u0018\r\u0006\u0004\u0002\n\u0005]\u0011\u0011\u0004\t\u0005c\u0011\fY\u0001\u0005\u0003\u0002\u000e\u0005MQBAA\b\u0015\r\t\t\u0002\\\u0001\u0006[>$W\r\\\u0005\u0005\u0003+\tyA\u0001\u000bI_>$\u0017.Z\"p[6LG/T3uC\u0012\fG/\u0019\u0005\u0006S2\u0001\rA\u001d\u0005\u0007\u00037a\u0001\u0019A2\u0002\u001b!|w\u000eZ5f\u0013:\u001cH/\u00198u\u0003\u0001\u001a\u0006n\\<D_6l\u0017\u000e^#yiJ\fW*\u001a;bI\u0006$\u0018\r\u0015:pG\u0016$WO]3\u0011\u0005\u0015r1c\u0001\b\u0002$A\u0019\u0011'!\n\n\u0007\u0005\u001d\"G\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0003?\tAAT!N\u000bV\u0011\u0011q\u0006\t\u0005\u0003c\tY$\u0004\u0002\u00024)!\u0011QGA\u001c\u0003\u0011a\u0017M\\4\u000b\u0005\u0005e\u0012\u0001\u00026bm\u0006LA!!\u0001\u00024\u0005)a*Q'FA\u00059!-^5mI\u0016\u0014XCAA\"!\u0015\t)%a\u0014)\u001b\t\t9E\u0003\u0003\u0002J\u0005-\u0013\u0001\u00034v]\u000e$\u0018n\u001c8\u000b\t\u00055\u0013qG\u0001\u0005kRLG.\u0003\u0003\u0002R\u0005\u001d#\u0001C*vaBd\u0017.\u001a:")
public class ShowCommitExtraMetadataProcedure
extends BaseProcedure
implements ProcedureBuilder {
    private final ProcedureParameter[] PARAMETERS = (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.required(0, "table", DataTypes.StringType), ProcedureParameter$.MODULE$.optional(1, "limit", DataTypes.IntegerType, BoxesRunTime.boxToInteger((int)100)), ProcedureParameter$.MODULE$.optional(2, "instant_time", DataTypes.StringType, ProcedureParameter$.MODULE$.optional$default$4()), ProcedureParameter$.MODULE$.optional(3, "metadata_key", DataTypes.StringType, ProcedureParameter$.MODULE$.optional$default$4())});
    private final StructType OUTPUT_TYPE = new StructType((StructField[])((Object[])new StructField[]{new StructField("instant_time", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("action", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("metadata_key", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("metadata_value", DataTypes.StringType, true, Metadata$.MODULE$.empty())}));

    public static Supplier<ProcedureBuilder> builder() {
        return ShowCommitExtraMetadataProcedure$.MODULE$.builder();
    }

    public static String NAME() {
        return ShowCommitExtraMetadataProcedure$.MODULE$.NAME();
    }

    private ProcedureParameter[] PARAMETERS() {
        return this.PARAMETERS;
    }

    private StructType OUTPUT_TYPE() {
        return this.OUTPUT_TYPE;
    }

    @Override
    public ProcedureParameter[] parameters() {
        return this.PARAMETERS();
    }

    @Override
    public StructType outputType() {
        return this.OUTPUT_TYPE();
    }

    @Override
    public Seq<Row> call(ProcedureArgs args2) {
        Option<HoodieInstant> hoodieInstantOption;
        super.checkArgs(this.PARAMETERS(), args2);
        String table = (String)this.getArgValueOrDefault(args2, this.PARAMETERS()[0]).get();
        int limit = BoxesRunTime.unboxToInt((Object)this.getArgValueOrDefault(args2, this.PARAMETERS()[1]).get());
        Option<Object> instantTime = this.getArgValueOrDefault(args2, this.PARAMETERS()[2]);
        Option<Object> metadataKey = this.getArgValueOrDefault(args2, this.PARAMETERS()[3]);
        HoodieCatalogTable hoodieCatalogTable = HoodieCLIUtils$.MODULE$.getHoodieCatalogTable(this.sparkSession(), table);
        String basePath = hoodieCatalogTable.tableLocation();
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(this.jsc().hadoopConfiguration()).setBasePath(basePath).build();
        HoodieActiveTimeline activeTimeline = metaClient.getActiveTimeline();
        HoodieTimeline timeline = activeTimeline.getCommitsTimeline().filterCompletedInstants();
        Option<HoodieInstant> option = hoodieInstantOption = instantTime.isEmpty() ? this.getCommitForLastInstant(timeline) : this.getCommitForInstant(timeline, (String)instantTime.get());
        if (hoodieInstantOption.isEmpty()) {
            throw new HoodieException(new StringBuilder(30).append("Commit ").append(instantTime).append(" not found in Commits ").append(timeline).append(".").toString());
        }
        Option<HoodieCommitMetadata> commitMetadataOptional = this.getHoodieCommitMetadata(timeline, hoodieInstantOption);
        if (commitMetadataOptional.isEmpty()) {
            throw new HoodieException(new StringBuilder(45).append("Commit ").append(instantTime).append(" not found commitMetadata in Commits ").append(timeline).append(".").toString());
        }
        HoodieCommitMetadata meta = (HoodieCommitMetadata)commitMetadataOptional.get();
        String timestamp = ((HoodieInstant)hoodieInstantOption.get()).getTimestamp();
        String action = ((HoodieInstant)hoodieInstantOption.get()).getAction();
        java.util.Map metadatas = metadataKey.isEmpty() ? meta.getExtraMetadata() : JavaConversions$.MODULE$.deprecated$u0020mutableMapAsJavaMap((Map)JavaConversions$.MODULE$.deprecated$u0020mapAsScalaMap(meta.getExtraMetadata()).filter((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)ShowCommitExtraMetadataProcedure.$anonfun$call$1(metadataKey, r))));
        ArrayList rows = new ArrayList();
        JavaConversions$.MODULE$.deprecated$u0020mapAsScalaMap(metadatas).foreach((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)rows.add(Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{timestamp, action, r._1(), r._2()})))));
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(rows.stream().limit(limit).toArray())).map((Function1 & Serializable & scala.Serializable)r -> (Row)r, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Row.class))))).toList();
    }

    @Override
    public Procedure build() {
        return new ShowCommitExtraMetadataProcedure();
    }

    private Option<HoodieInstant> getCommitForLastInstant(HoodieTimeline timeline) {
        Optional<HoodieInstant> instantOptional = timeline.getReverseOrderedInstants().findFirst();
        return instantOptional.isPresent() ? Option$.MODULE$.apply((Object)instantOptional.get()) : Option$.MODULE$.empty();
    }

    private Option<HoodieInstant> getCommitForInstant(HoodieTimeline timeline, String instantTime) {
        List<Object> instants = Arrays.asList((Object[])new HoodieInstant[]{new HoodieInstant(false, "commit", instantTime), new HoodieInstant(false, "replacecommit", instantTime), new HoodieInstant(false, "deltacommit", instantTime)});
        Option hoodieInstant = JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(instants).find((Function1 & Serializable & scala.Serializable)i -> BoxesRunTime.boxToBoolean((boolean)timeline.containsInstant(i)));
        return hoodieInstant;
    }

    private Option<HoodieCommitMetadata> getHoodieCommitMetadata(HoodieTimeline timeline, Option<HoodieInstant> hoodieInstant) {
        Option option;
        if (hoodieInstant.isDefined()) {
            String string = ((HoodieInstant)hoodieInstant.get()).getAction();
            String string2 = "replacecommit";
            option = !(string != null ? !string.equals(string2) : string2 != null) ? Option$.MODULE$.apply((Object)HoodieReplaceCommitMetadata.fromBytes(timeline.getInstantDetails((HoodieInstant)hoodieInstant.get()).get(), HoodieReplaceCommitMetadata.class)) : Option$.MODULE$.apply((Object)HoodieCommitMetadata.fromBytes(timeline.getInstantDetails((HoodieInstant)hoodieInstant.get()).get(), HoodieCommitMetadata.class));
        } else {
            option = Option$.MODULE$.empty();
        }
        return option;
    }

    public static final /* synthetic */ boolean $anonfun$call$1(Option metadataKey$1, Tuple2 r) {
        return ((String)r._1()).equals(((String)metadataKey$1.get()).trim());
    }
}

