/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.com.uber.m3.tally;

import io.hops.hudi.com.uber.m3.tally.Buckets;
import io.hops.hudi.com.uber.m3.tally.CounterImpl;
import io.hops.hudi.com.uber.m3.tally.DurationBuckets;
import io.hops.hudi.com.uber.m3.tally.Histogram;
import io.hops.hudi.com.uber.m3.tally.ImmutableBuckets;
import io.hops.hudi.com.uber.m3.tally.MetricBase;
import io.hops.hudi.com.uber.m3.tally.ScopeImpl;
import io.hops.hudi.com.uber.m3.tally.StatsReporter;
import io.hops.hudi.com.uber.m3.tally.Stopwatch;
import io.hops.hudi.com.uber.m3.tally.StopwatchRecorder;
import io.hops.hudi.com.uber.m3.util.Duration;
import io.hops.hudi.com.uber.m3.util.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class HistogramImpl
extends MetricBase
implements Histogram,
StopwatchRecorder {
    private final Type type;
    private final ImmutableMap<String, String> tags;
    private final ImmutableBuckets specification;
    private final CounterImpl[] bucketCounters;
    private final ScopeImpl scope;

    HistogramImpl(ScopeImpl scope, String fqn, ImmutableMap<String, String> tags, Buckets buckets) {
        super(fqn);
        this.scope = scope;
        this.type = buckets instanceof DurationBuckets ? Type.DURATION : Type.VALUE;
        this.tags = tags;
        this.specification = buckets;
        this.bucketCounters = new CounterImpl[buckets.asValues().length + 1];
    }

    @Override
    public void recordValue(double value) {
        int index = HistogramImpl.toBucketIndex(Collections.binarySearch(this.specification.getValueUpperBounds(), value));
        this.getOrCreateCounter(index).inc(1L);
    }

    @Override
    public void recordDuration(Duration duration) {
        int index = HistogramImpl.toBucketIndex(Collections.binarySearch(this.specification.getDurationUpperBounds(), duration));
        this.getOrCreateCounter(index).inc(1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CounterImpl getOrCreateCounter(int index) {
        if (this.bucketCounters[index] != null) {
            return this.bucketCounters[index];
        }
        List<Comparable<Double>> bucketsBounds = this.type == Type.VALUE ? this.specification.getValueUpperBounds() : this.specification.getDurationUpperBounds();
        Comparable<Double> comparable = bucketsBounds.get(Math.min(index, bucketsBounds.size() - 1));
        synchronized (comparable) {
            if (this.bucketCounters[index] != null) {
                return this.bucketCounters[index];
            }
            this.bucketCounters[index] = new HistogramBucketCounterImpl(this.scope, this.getQualifiedName(), index);
            return this.bucketCounters[index];
        }
    }

    static int toBucketIndex(int binarySearchResult) {
        if (binarySearchResult >= 0) {
            return binarySearchResult + 1;
        }
        return ~binarySearchResult;
    }

    @Override
    public Stopwatch start() {
        return new Stopwatch(System.nanoTime(), this);
    }

    ImmutableMap<String, String> getTags() {
        return this.tags;
    }

    private Duration getUpperBoundDurationForBucket(int bucketIndex) {
        return bucketIndex < this.specification.getDurationUpperBounds().size() ? this.specification.getDurationUpperBounds().get(bucketIndex) : Duration.MAX_VALUE;
    }

    private Duration getLowerBoundDurationForBucket(int bucketIndex) {
        return bucketIndex == 0 ? Duration.MIN_VALUE : this.specification.getDurationUpperBounds().get(bucketIndex - 1);
    }

    private double getUpperBoundValueForBucket(int bucketIndex) {
        return bucketIndex < this.specification.getValueUpperBounds().size() ? this.specification.getValueUpperBounds().get(bucketIndex) : Double.MAX_VALUE;
    }

    private double getLowerBoundValueForBucket(int bucketIndex) {
        return bucketIndex == 0 ? Double.MIN_VALUE : this.specification.getValueUpperBounds().get(bucketIndex - 1);
    }

    private long getCounterValue(int index) {
        return this.bucketCounters[index] != null ? this.bucketCounters[index].value() : 0L;
    }

    Map<Double, Long> snapshotValues() {
        if (this.type == Type.DURATION) {
            return null;
        }
        HashMap<Double, Long> values2 = new HashMap<Double, Long>(this.bucketCounters.length, 1.0f);
        for (int i = 0; i < this.bucketCounters.length; ++i) {
            values2.put(this.getUpperBoundValueForBucket(i), this.getCounterValue(i));
        }
        return values2;
    }

    Map<Duration, Long> snapshotDurations() {
        if (this.type == Type.VALUE) {
            return null;
        }
        HashMap<Duration, Long> durations = new HashMap<Duration, Long>(this.bucketCounters.length, 1.0f);
        for (int i = 0; i < this.bucketCounters.length; ++i) {
            durations.put(this.getUpperBoundDurationForBucket(i), this.getCounterValue(i));
        }
        return durations;
    }

    @Override
    public void recordStopwatch(long stopwatchStart) {
        this.recordDuration(Duration.between(stopwatchStart, System.nanoTime()));
    }

    class HistogramBucketCounterImpl
    extends CounterImpl {
        private final int bucketIndex;

        protected HistogramBucketCounterImpl(ScopeImpl scope, String fqn, int bucketIndex) {
            super(scope, fqn);
            this.bucketIndex = bucketIndex;
        }

        @Override
        public void report(ImmutableMap<String, String> tags, StatsReporter reporter) {
            long inc = this.value();
            if (inc == 0L) {
                return;
            }
            switch (HistogramImpl.this.type) {
                case VALUE: {
                    reporter.reportHistogramValueSamples(this.getQualifiedName(), tags, (Buckets)HistogramImpl.this.specification, HistogramImpl.this.getLowerBoundValueForBucket(this.bucketIndex), HistogramImpl.this.getUpperBoundValueForBucket(this.bucketIndex), inc);
                    break;
                }
                case DURATION: {
                    reporter.reportHistogramDurationSamples(this.getQualifiedName(), tags, (Buckets)HistogramImpl.this.specification, HistogramImpl.this.getLowerBoundDurationForBucket(this.bucketIndex), HistogramImpl.this.getUpperBoundDurationForBucket(this.bucketIndex), inc);
                }
            }
        }
    }

    static enum Type {
        VALUE,
        DURATION;

    }
}

