/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.htrace.core;

import io.hops.hudi.org.apache.htrace.core.HTraceConfiguration;
import io.hops.hudi.org.apache.htrace.core.Sampler;
import io.hops.hudi.org.apache.htrace.shaded.commons.logging.Log;
import io.hops.hudi.org.apache.htrace.shaded.commons.logging.LogFactory;
import java.util.concurrent.ThreadLocalRandom;

public class ProbabilitySampler
extends Sampler {
    private static final Log LOG = LogFactory.getLog(ProbabilitySampler.class);
    public final double threshold;
    public static final String SAMPLER_FRACTION_CONF_KEY = "sampler.fraction";

    public ProbabilitySampler(HTraceConfiguration conf) {
        this.threshold = Double.parseDouble(conf.get(SAMPLER_FRACTION_CONF_KEY));
        if (LOG.isTraceEnabled()) {
            LOG.trace("Created new ProbabilitySampler with threshold = " + this.threshold + ".");
        }
    }

    @Override
    public boolean next() {
        return ThreadLocalRandom.current().nextDouble() < this.threshold;
    }
}

