/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.http.client.protocol;

import io.hops.hudi.org.apache.http.Header;
import io.hops.hudi.org.apache.http.HeaderIterator;
import io.hops.hudi.org.apache.http.HttpException;
import io.hops.hudi.org.apache.http.HttpResponse;
import io.hops.hudi.org.apache.http.HttpResponseInterceptor;
import io.hops.hudi.org.apache.http.annotation.Contract;
import io.hops.hudi.org.apache.http.annotation.ThreadingBehavior;
import io.hops.hudi.org.apache.http.client.CookieStore;
import io.hops.hudi.org.apache.http.client.protocol.HttpClientContext;
import io.hops.hudi.org.apache.http.cookie.Cookie;
import io.hops.hudi.org.apache.http.cookie.CookieOrigin;
import io.hops.hudi.org.apache.http.cookie.CookieSpec;
import io.hops.hudi.org.apache.http.cookie.MalformedCookieException;
import io.hops.hudi.org.apache.http.protocol.HttpContext;
import io.hops.hudi.org.apache.http.util.Args;
import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class ResponseProcessCookies
implements HttpResponseInterceptor {
    private final Log log = LogFactory.getLog(this.getClass());

    @Override
    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        Args.notNull(response, "HTTP request");
        Args.notNull(context, "HTTP context");
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        CookieSpec cookieSpec = clientContext.getCookieSpec();
        if (cookieSpec == null) {
            this.log.debug((Object)"Cookie spec not specified in HTTP context");
            return;
        }
        CookieStore cookieStore2 = clientContext.getCookieStore();
        if (cookieStore2 == null) {
            this.log.debug((Object)"Cookie store not specified in HTTP context");
            return;
        }
        CookieOrigin cookieOrigin = clientContext.getCookieOrigin();
        if (cookieOrigin == null) {
            this.log.debug((Object)"Cookie origin not specified in HTTP context");
            return;
        }
        HeaderIterator it = response.headerIterator("Set-Cookie");
        this.processCookies(it, cookieSpec, cookieOrigin, cookieStore2);
        if (cookieSpec.getVersion() > 0) {
            it = response.headerIterator("Set-Cookie2");
            this.processCookies(it, cookieSpec, cookieOrigin, cookieStore2);
        }
    }

    private void processCookies(HeaderIterator iterator2, CookieSpec cookieSpec, CookieOrigin cookieOrigin, CookieStore cookieStore2) {
        while (iterator2.hasNext()) {
            Header header = iterator2.nextHeader();
            try {
                List<Cookie> cookies = cookieSpec.parse(header, cookieOrigin);
                for (Cookie cookie : cookies) {
                    try {
                        cookieSpec.validate(cookie, cookieOrigin);
                        cookieStore2.addCookie(cookie);
                        if (!this.log.isDebugEnabled()) continue;
                        this.log.debug((Object)("Cookie accepted [" + ResponseProcessCookies.formatCooke(cookie) + "]"));
                    }
                    catch (MalformedCookieException ex) {
                        if (!this.log.isWarnEnabled()) continue;
                        this.log.warn((Object)("Cookie rejected [" + ResponseProcessCookies.formatCooke(cookie) + "] " + ex.getMessage()));
                    }
                }
            }
            catch (MalformedCookieException ex) {
                if (!this.log.isWarnEnabled()) continue;
                this.log.warn((Object)("Invalid cookie header: \"" + header + "\". " + ex.getMessage()));
            }
        }
    }

    private static String formatCooke(Cookie cookie) {
        StringBuilder buf = new StringBuilder();
        buf.append(cookie.getName());
        buf.append("=\"");
        String v = cookie.getValue();
        if (v != null) {
            if (v.length() > 100) {
                v = v.substring(0, 100) + "...";
            }
            buf.append(v);
        }
        buf.append("\"");
        buf.append(", version:");
        buf.append(Integer.toString(cookie.getVersion()));
        buf.append(", domain:");
        buf.append(cookie.getDomain());
        buf.append(", path:");
        buf.append(cookie.getPath());
        buf.append(", expiry:");
        buf.append(cookie.getExpiryDate());
        return buf.toString();
    }
}

