/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.http.protocol;

import io.hops.hudi.org.apache.http.HttpEntityEnclosingRequest;
import io.hops.hudi.org.apache.http.HttpException;
import io.hops.hudi.org.apache.http.HttpRequest;
import io.hops.hudi.org.apache.http.HttpRequestInterceptor;
import io.hops.hudi.org.apache.http.annotation.Contract;
import io.hops.hudi.org.apache.http.annotation.ThreadingBehavior;
import io.hops.hudi.org.apache.http.protocol.HttpContext;
import io.hops.hudi.org.apache.http.protocol.HttpDateGenerator;
import io.hops.hudi.org.apache.http.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.SAFE)
public class RequestDate
implements HttpRequestInterceptor {
    private static final HttpDateGenerator DATE_GENERATOR = new HttpDateGenerator();

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (request instanceof HttpEntityEnclosingRequest && !request.containsHeader("Date")) {
            String httpdate = DATE_GENERATOR.getCurrentDate();
            request.setHeader("Date", httpdate);
        }
    }
}

