/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.http.protocol;

import io.hops.hudi.org.apache.http.HttpConnection;
import io.hops.hudi.org.apache.http.HttpException;
import io.hops.hudi.org.apache.http.HttpHost;
import io.hops.hudi.org.apache.http.HttpInetConnection;
import io.hops.hudi.org.apache.http.HttpRequest;
import io.hops.hudi.org.apache.http.HttpRequestInterceptor;
import io.hops.hudi.org.apache.http.HttpVersion;
import io.hops.hudi.org.apache.http.ProtocolException;
import io.hops.hudi.org.apache.http.ProtocolVersion;
import io.hops.hudi.org.apache.http.annotation.Contract;
import io.hops.hudi.org.apache.http.annotation.ThreadingBehavior;
import io.hops.hudi.org.apache.http.protocol.HttpContext;
import io.hops.hudi.org.apache.http.protocol.HttpCoreContext;
import io.hops.hudi.org.apache.http.util.Args;
import java.io.IOException;
import java.net.InetAddress;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestTargetHost
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        HttpCoreContext coreContext = HttpCoreContext.adapt(context);
        ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT") && ver.lessEquals(HttpVersion.HTTP_1_0)) {
            return;
        }
        if (!request.containsHeader("Host")) {
            HttpHost targetHost = coreContext.getTargetHost();
            if (targetHost == null) {
                HttpConnection conn = coreContext.getConnection();
                if (conn instanceof HttpInetConnection) {
                    InetAddress address = ((HttpInetConnection)conn).getRemoteAddress();
                    int port = ((HttpInetConnection)conn).getRemotePort();
                    if (address != null) {
                        targetHost = new HttpHost(address.getHostName(), port);
                    }
                }
                if (targetHost == null) {
                    if (ver.lessEquals(HttpVersion.HTTP_1_0)) {
                        return;
                    }
                    throw new ProtocolException("Target host missing");
                }
            }
            request.addHeader("Host", targetHost.toHostString());
        }
    }
}

