/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.jetty.client;

import io.hops.hudi.org.apache.jetty.client.api.Authentication;
import io.hops.hudi.org.apache.jetty.client.api.AuthenticationStore;
import io.hops.hudi.org.apache.jetty.client.util.AbstractAuthentication;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class HttpAuthenticationStore
implements AuthenticationStore {
    private final List<Authentication> authentications = new CopyOnWriteArrayList<Authentication>();
    private final Map<URI, Authentication.Result> results = new ConcurrentHashMap<URI, Authentication.Result>();

    @Override
    public void addAuthentication(Authentication authentication) {
        this.authentications.add(authentication);
    }

    @Override
    public void removeAuthentication(Authentication authentication) {
        this.authentications.remove(authentication);
    }

    @Override
    public void clearAuthentications() {
        this.authentications.clear();
    }

    @Override
    public Authentication findAuthentication(String type, URI uri2, String realm) {
        for (Authentication authentication : this.authentications) {
            if (!authentication.matches(type, uri2, realm)) continue;
            return authentication;
        }
        return null;
    }

    @Override
    public void addAuthenticationResult(Authentication.Result result) {
        URI uri2 = result.getURI();
        if (uri2 != null) {
            this.results.put(uri2, result);
        }
    }

    @Override
    public void removeAuthenticationResult(Authentication.Result result) {
        this.results.remove(result.getURI());
    }

    @Override
    public void clearAuthenticationResults() {
        this.results.clear();
    }

    @Override
    public Authentication.Result findAuthenticationResult(URI uri2) {
        for (Map.Entry<URI, Authentication.Result> entry : this.results.entrySet()) {
            if (!AbstractAuthentication.matchesURI(entry.getKey(), uri2)) continue;
            return entry.getValue();
        }
        return null;
    }

    @Override
    public boolean hasAuthenticationResults() {
        return !this.results.isEmpty();
    }
}

