/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.jetty.websocket.common;

import io.hops.hudi.org.apache.jetty.util.annotation.ManagedAttribute;
import io.hops.hudi.org.apache.jetty.util.component.AbstractLifeCycle;
import io.hops.hudi.org.apache.jetty.util.component.Dumpable;
import io.hops.hudi.org.apache.jetty.util.component.LifeCycle;
import io.hops.hudi.org.apache.jetty.websocket.common.WebSocketSession;
import io.hops.hudi.org.apache.jetty.websocket.common.WebSocketSessionListener;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class SessionTracker
extends AbstractLifeCycle
implements WebSocketSessionListener,
Dumpable {
    private final Set<WebSocketSession> sessions = Collections.newSetFromMap(new ConcurrentHashMap());

    public Set<WebSocketSession> getSessions() {
        return Collections.unmodifiableSet(new HashSet<WebSocketSession>(this.sessions));
    }

    @Override
    public void onSessionCreated(WebSocketSession session) {
        LifeCycle.start(session);
        this.sessions.add(session);
    }

    @Override
    public void onSessionClosed(WebSocketSession session) {
        this.sessions.remove(session);
        LifeCycle.stop(session);
    }

    @Override
    protected void doStop() throws Exception {
        for (WebSocketSession session : this.sessions) {
            LifeCycle.stop(session);
        }
        super.doStop();
    }

    @ManagedAttribute(value="Total number of active WebSocket Sessions")
    public int getNumSessions() {
        return this.sessions.size();
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        Dumpable.dumpObjects(out, indent, this, this.sessions);
    }
}

