/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.jetty.websocket.common.message;

import io.hops.hudi.org.apache.jetty.util.BufferUtil;
import io.hops.hudi.org.apache.jetty.util.ByteArrayOutputStream2;
import io.hops.hudi.org.apache.jetty.websocket.common.events.EventDriver;
import io.hops.hudi.org.apache.jetty.websocket.common.message.MessageAppender;
import java.io.IOException;
import java.nio.ByteBuffer;

public class SimpleBinaryMessage
implements MessageAppender {
    private static final int BUFFER_SIZE = 65535;
    private final EventDriver onEvent;
    protected ByteArrayOutputStream2 out;
    private int size;
    protected boolean finished;

    public SimpleBinaryMessage(EventDriver onEvent) {
        this.onEvent = onEvent;
        this.finished = false;
    }

    @Override
    public void appendFrame(ByteBuffer payload, boolean isLast) throws IOException {
        if (this.finished) {
            throw new IOException("Cannot append to finished buffer");
        }
        if (payload == null) {
            return;
        }
        this.onEvent.getPolicy().assertValidBinaryMessageSize(this.size + payload.remaining());
        this.size += payload.remaining();
        if (this.out == null) {
            this.out = isLast ? new ByteArrayOutputStream2(this.size) : new ByteArrayOutputStream2(65535);
        }
        BufferUtil.writeTo(payload, this.out);
    }

    @Override
    public void messageComplete() {
        this.finished = true;
        byte[] data = this.out == null ? new byte[]{} : (this.out.getCount() == this.out.getBuf().length ? this.out.getBuf() : this.out.toByteArray());
        this.onEvent.onBinaryMessage(data);
    }
}

